/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;
import weblogic.remoteconsole.server.token.SsoTokenManager;
import weblogic.remoteconsole.server.webapp.BaseResource;

public class SsoTokenResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(SsoTokenResource.class.getName());
    private static final String SSOID = "ssoid";
    private static final String TOKEN = "token";
    private static final String DOMAIN = "domain";
    private static final String EXPIRES = "expires";

    @GET
    @Produces(value={"application/json"})
    public Response getTokenAvailable(@QueryParam(value="ssoid") @DefaultValue(value="") String ssoid, @Context ResourceContext resourceContext) {
        AdminServerDataProvider provider;
        LOGGER.fine("GET token");
        if (ssoid == null || ssoid.isBlank()) {
            LOGGER.fine("GET token bad request: ssoid missing");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        LOGGER.fine("GET token ssoid = " + ssoid);
        SsoTokenManager ssoTokenManager = SsoTokenManager.getFromResourceContext(resourceContext);
        AdminServerDataProvider adminServerDataProvider = provider = ssoTokenManager != null ? ssoTokenManager.get(ssoid) : null;
        if (provider == null) {
            LOGGER.fine("GET token unable to find ssoid!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        boolean available = provider.isSsoTokenAvailable();
        LOGGER.fine("GET token available state: " + available);
        JsonObjectBuilder result = Json.createObjectBuilder().add(SSOID, ssoid).add("available", available);
        if (available) {
            result.add(EXPIRES, provider.getSsoTokenExpires());
        }
        return Response.ok().entity((Object)result.build()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response postToken(@Context ResourceContext resourceContext, JsonObject data) {
        AdminServerDataProvider provider;
        LOGGER.fine("POST token");
        String ssoid = this.getSsoId(data);
        if (ssoid == null || ssoid.isBlank()) {
            LOGGER.fine("POST token bad request: ssoid missing");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        LOGGER.fine("POST token ssoid = " + ssoid);
        SsoTokenManager ssoTokenManager = SsoTokenManager.getFromResourceContext(resourceContext);
        AdminServerDataProvider adminServerDataProvider = provider = ssoTokenManager != null ? ssoTokenManager.get(ssoid) : null;
        if (provider == null) {
            LOGGER.fine("POST token unable to find ssoid!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (provider.isSsoTokenAvailable()) {
            LOGGER.fine("POST token already available!");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.setSsoToken(provider, data)) {
            LOGGER.fine("POST token unable to set token!");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().build();
    }

    private boolean setSsoToken(AdminServerDataProvider provider, JsonObject data) {
        boolean result = false;
        try {
            JsonString tokenJson = data.getJsonString(TOKEN);
            JsonString domainJson = data.getJsonString(DOMAIN);
            JsonNumber expiresJson = data.getJsonNumber(EXPIRES);
            result = provider.setSsoToken(tokenJson != null ? tokenJson.getString() : null, domainJson != null ? domainJson.getString() : null, expiresJson != null ? expiresJson.longValueExact() : 0L);
        }
        catch (Exception exc) {
            LOGGER.log(Level.FINE, "Failure setting token: " + exc.toString(), exc);
        }
        return result;
    }

    private String getSsoId(JsonObject data) {
        String result = null;
        try {
            JsonString ssoidJson = data != null ? data.getJsonString(SSOID) : null;
            result = ssoidJson != null ? ssoidJson.getString() : null;
        }
        catch (Exception exc) {
            LOGGER.log(Level.FINE, "Failure reading ssoid: " + exc.toString(), exc);
        }
        return result;
    }
}

