/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.RequestBodyMapper;

public class SliceTableActionRequestBodyMapper
extends RequestBodyMapper<List<String>> {
    private static final String ROWS = "rows";
    private static final String VALUE = "value";

    public static Response<List<String>> fromRequestBody(InvocationContext ic, JsonObject requestBody) {
        return new SliceTableActionRequestBodyMapper(ic, requestBody).fromRequestBody();
    }

    private SliceTableActionRequestBodyMapper(InvocationContext ic, JsonObject requestBody) {
        super(ic, requestBody);
    }

    @Override
    protected void parseRequestBody() {
        ArrayList<String> identifiers = new ArrayList<String>();
        JsonObject rows = this.getOptionalJsonObject(this.getRequestBody(), ROWS);
        if (this.isOK() && rows != null) {
            JsonArray values = this.getRequiredJsonArray(rows, VALUE);
            for (int i = 0; this.isOK() && i < values.size(); ++i) {
                JsonObject row = this.asJsonObject(VALUE, (JsonValue)values.get(i));
                if (!this.isOK()) continue;
                String identifier = this.getRequiredString(row, VALUE);
                if (!this.isOK()) continue;
                identifiers.add(identifier);
            }
        }
        if (this.isOK()) {
            this.getResponse().setSuccess(identifiers);
        }
    }
}

