/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import javax.json.Json;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.ResponseMapper;

public class SimpleSearchResponseMapper
extends ResponseMapper<String> {
    public static javax.ws.rs.core.Response toResponse(InvocationContext ic, Response<String> response) {
        return new SimpleSearchResponseMapper(ic, response).toResponse();
    }

    private SimpleSearchResponseMapper(InvocationContext ic, Response<String> response) {
        super(ic, response);
    }

    @Override
    protected void addResults() {
        String searchName = (String)this.getResponse().getResults();
        Path simpleSearchResultsPath = new Path().childPath(this.getRecentSearchesParent()).childPath("RecentSearches").childPath(searchName);
        String queryParams = "";
        this.getEntityBuilder().add("resourceData", Json.createObjectBuilder().add("label", searchName).add("resourceData", this.getBackendRelativeUri(simpleSearchResultsPath, queryParams)));
    }

    private String getRecentSearchesParent() {
        String root = this.getInvocationContext().getPageRepo().getPageRepoDef().getName();
        if ("domainRuntime".equals(root)) {
            return "DomainRuntime";
        }
        if ("edit".equals(root) || "serverConfig".equals(root) || "compositeConfig".equals(root) || "securityData".equals(root)) {
            return "Domain";
        }
        throw new AssertionError((Object)("Root doesn't support search: " + root));
    }
}

