/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SimpleSearchCriteria;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.SimpleSearchRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.SimpleSearchResponseMapper;

public class SimpleSearchResource
extends BaseResource {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response search(JsonObject requestBody) {
        return SimpleSearchResponseMapper.toResponse(this.getInvocationContext(), this.getResponse(requestBody));
    }

    private Response<String> getResponse(JsonObject requestBody) {
        Response<String> response = new Response<String>();
        Response<SimpleSearchCriteria> criteriaResponse = SimpleSearchRequestBodyMapper.fromRequestBody(this.getInvocationContext(), requestBody);
        if (!criteriaResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(criteriaResponse);
        }
        SimpleSearchCriteria criteria = criteriaResponse.getResults();
        InvocationContext ic = this.getInvocationContext();
        Response<String> createResponse = ic.getPageRepo().asPageReaderRepo().getSimpleSearchManager(ic).createSearch(this.getInvocationContext(), criteria);
        if (!createResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(createResponse);
        }
        return response.setSuccess(createResponse.getResults());
    }
}

