/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.NavTreePath;
import weblogic.remoteconsole.server.repo.NavTreePathSegment;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanPropertyResults;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.ResponseMapper;

public class SearchResponseMapper
extends ResponseMapper<List<SearchBeanResults>> {
    public static javax.ws.rs.core.Response toResponse(InvocationContext ic, Response<List<SearchBeanResults>> response) {
        return new SearchResponseMapper(ic, response).toResponse();
    }

    private SearchResponseMapper(InvocationContext ic, Response<List<SearchBeanResults>> response) {
        super(ic, response);
    }

    @Override
    protected void addResults() {
        this.getEntityBuilder().add("beans", (JsonValue)this.beansResultsToJson((List)this.getResponse().getResults()).build());
    }

    private JsonArrayBuilder beansResultsToJson(List<SearchBeanResults> beansResults) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (SearchBeanResults beanResults : beansResults) {
            builder.add(this.beanResultsToJson(beanResults));
        }
        return builder;
    }

    private JsonObjectBuilder beanResultsToJson(SearchBeanResults beanResults) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("identity", this.propertyToJson(beanResults.getBeanTreePath()));
        builder.add("path", this.propertyToJson(new StringValue(SearchResponseMapper.getBeanPath(this.getInvocationContext(), beanResults))));
        builder.add("name", this.propertyToJson(new StringValue(SearchResponseMapper.getBeanName(this.getInvocationContext(), beanResults))));
        builder.add("type", this.propertyToJson(new StringValue(SearchResponseMapper.getBeanType(this.getInvocationContext(), beanResults))));
        for (SearchBeanPropertyResults propertyResults : beanResults.getPropertiesResults()) {
            builder.add(propertyResults.getPropertyDef().getFormFieldName(), this.propertyResultsToJson(propertyResults));
        }
        return builder;
    }

    public static String getBeanName(InvocationContext ic, SearchBeanResults beanResults) {
        BeanTreePath btp = beanResults.getBeanTreePath();
        if (btp.isCollectionChild()) {
            return btp.getLastSegment().getKey();
        }
        NavTreePath ntp = new NavTreePath(ic.getPageRepo(), btp);
        return ic.getLocalizer().localizeString(ntp.getLastSegment().getNavTreeNodeDef().getLabel(), new Object[0]);
    }

    public static String getBeanPath(InvocationContext ic, SearchBeanResults beanResults) {
        return SearchResponseMapper.getBeanNavTreePath(ic, beanResults).getSeparatedPath(" / ");
    }

    private static Path getBeanNavTreePath(InvocationContext ic, SearchBeanResults beanResults) {
        NavTreePath ntp = new NavTreePath(ic.getPageRepo(), beanResults.getBeanTreePath());
        Path path = new Path();
        for (NavTreePathSegment segment : ntp.getSegments()) {
            path.addComponent(ic.getLocalizer().localizeString(segment.getNavTreeNodeDef().getLabel(), new Object[0]));
            BeanTreePath btp = segment.getBeanTreePath();
            if (btp == null || !btp.isCollectionChild()) continue;
            path.addComponent(btp.getLastSegment().getKey());
        }
        return path;
    }

    public static Path getSortingKey(InvocationContext ic, SearchBeanResults beanResults) {
        Path sortingKey = new Path();
        sortingKey.addComponent(SearchResponseMapper.getBeanName(ic, beanResults));
        sortingKey.addPath(SearchResponseMapper.getBeanNavTreePath(ic, beanResults));
        return sortingKey;
    }

    public static String getBeanType(InvocationContext ic, SearchBeanResults beanResults) {
        return ic.getLocalizer().localizeString(beanResults.getTypeDef().getInstanceNameLabel(), new Object[0]);
    }

    private JsonObjectBuilder propertyResultsToJson(SearchBeanPropertyResults propertyResults) {
        String label = this.getInvocationContext().getLocalizer().localizeString(propertyResults.getPropertyDef().getLabel(), new Object[0]);
        return this.propertyToJson(propertyResults.getValue()).add("label", label);
    }

    private JsonObjectBuilder propertyToJson(Value value) {
        return Json.createObjectBuilder().add("value", this.valueToJson(value));
    }
}

