/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanFinder;
import weblogic.remoteconsole.server.repo.SearchBeanResults;
import weblogic.remoteconsole.server.repo.SearchCriteria;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.SearchRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.SearchResponseMapper;

public class SearchResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(SearchResource.class.getName());

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response search(JsonObject requestBody) {
        return SearchResponseMapper.toResponse(this.getInvocationContext(), this.getResponse(requestBody));
    }

    private Response<List<SearchBeanResults>> getResponse(JsonObject requestBody) {
        Response<List<SearchBeanResults>> response = new Response<List<SearchBeanResults>>();
        Response<SearchCriteria> criteriaResponse = SearchRequestBodyMapper.fromRequestBody(this.getInvocationContext(), requestBody);
        if (!criteriaResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(criteriaResponse);
        }
        SearchCriteria criteria = criteriaResponse.getResults();
        SearchBeanFinder finder = new SearchBeanFinder(this.getInvocationContext(), criteria);
        BeanReaderRepoSearchBuilder searchBuilder = this.getInvocationContext().getPageRepo().getBeanRepo().asBeanReaderRepo().createSearchBuilder(this.getInvocationContext(), false);
        finder.addToSearchBuilder(searchBuilder);
        Response<BeanReaderRepoSearchResults> searchResponse = searchBuilder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanReaderRepoSearchResults searchResults = searchResponse.getResults();
        List<SearchBeanResults> beansResults = finder.getResults(searchResults);
        return response.setSuccess(beansResults);
    }
}

