/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SearchBeanFilter;
import weblogic.remoteconsole.server.repo.SearchCriteria;
import weblogic.remoteconsole.server.repo.SearchPathSegmentFilter;
import weblogic.remoteconsole.server.repo.SearchProperty;
import weblogic.remoteconsole.server.repo.SearchValueFilter;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.RequestBodyMapper;

public class SearchRequestBodyMapper
extends RequestBodyMapper<SearchCriteria> {
    private static final String CRITERIA_FILTERS = "filters";
    private static final String CRITERIA_PROPERTIES = "properties";
    private static final String FILTER_REQUIRED = "required";
    private static final String FILTER_MATCHES = "matches";
    private static final String FILTER_BEAN_TREE_PATH = "beanTreePath";
    private static final String FILTER_NAV_TREE_PATH = "navTreePath";
    private static final String FILTER_KEY = "key";
    private static final String FILTER_KEY_CONTAINS = "keyContains";
    private static final String FILTER_BEAN_TYPE = "beanType";
    private static final String FILTER_BEAN_TYPE_CONTAINS = "beanTypeContains";
    private static final String FILTER_PATH_CONTAINS = "pathContains";
    private static final String FILTER_PROPERTY_NAME = "propertyName";
    private static final String FILTER_PROPERTY_LABEL_CONTAINS = "propertyLabelContains";
    private static final String FILTER_PROPERTY_TYPE = "propertyType";
    private static final String FILTER_VALUE_FILTER = "valueFilter";
    private static final String FILTER_INCLUDE_IN_RESULTS = "includeInResults";
    private static final String INCLUDE_IN_RESULTS_ALWAYS = "always";
    private static final String INCLUDE_IN_RESULTS_IF_MATCHES = "ifMatches";
    private static final String INCLUDE_IN_RESULTS_NEVER = "never";
    private static final String PROPERTY_TYPE_HEALTH_STATE = "healthState";
    private static final String PROPERTY_TYPE_REFERENCE = "reference";
    private static final String SEGMENT_ANY_VALUE = "anyValue";
    private static final String SEGMENT_EQUALS = "equals";
    private static final String SEGMENT_CONTAINS = "contains";
    private static final String VALUE_EQUALS = "equals";
    private static final String VALUE_LESS_THAN = "lessThan";
    private static final String VALUE_LESS_THAN_OR_EQUALS = "lessThanOrEquals";
    private static final String VALUE_GREATER_THAN = "greaterThan";
    private static final String VALUE_GREATER_THAN_OR_EQUALS = "greaterThanOrEquals";
    private static final String VALUE_ONE_OF = "oneOf";
    private static final String VALUE_CONTAINS = "contains";
    private static final String PROPERTY_PROPERTY_NAME = "propertyName";
    private static final String PROPERTY_PROPERTY_LABEL_CONTAINS = "propertyLabelContains";

    public static Response<SearchCriteria> fromRequestBody(InvocationContext ic, JsonObject requestBody) {
        return new SearchRequestBodyMapper(ic, requestBody).fromRequestBody();
    }

    private SearchRequestBodyMapper(InvocationContext ic, JsonObject requestBody) {
        super(ic, requestBody, null);
    }

    @Override
    protected void parseRequestBody() {
        SearchCriteria criteria = this.getSearchCriteria();
        if (this.isOK()) {
            this.getResponse().setSuccess(criteria);
        }
    }

    private SearchCriteria getSearchCriteria() {
        JsonObject object = this.getRequestBody();
        SearchCriteria criteria = new SearchCriteria();
        criteria.setFilters(this.getFilters(object));
        criteria.setProperties(this.getProperties(object));
        return criteria;
    }

    private List<SearchBeanFilter> getFilters(JsonObject object) {
        ArrayList<SearchBeanFilter> filters = new ArrayList<SearchBeanFilter>();
        JsonArray array = this.getOptionalJsonArray(object, CRITERIA_FILTERS);
        if (array != null) {
            for (int i = 0; this.isOK() && i < array.size(); ++i) {
                filters.add(this.getFilter((JsonValue)array.get(i)));
            }
        }
        return filters;
    }

    private SearchBeanFilter getFilter(JsonValue value) {
        JsonObject object = this.asJsonObject(CRITERIA_FILTERS, value);
        if (!this.isOK()) {
            return null;
        }
        SearchBeanFilter filter = new SearchBeanFilter();
        filter.setRequired(this.getOptionalBoolean(object, FILTER_REQUIRED, false));
        filter.setMatches(this.getOptionalBoolean(object, FILTER_MATCHES, true));
        this.validateSpecifiesOneOf(object, FILTER_BEAN_TREE_PATH, FILTER_NAV_TREE_PATH, FILTER_KEY, FILTER_KEY_CONTAINS, FILTER_BEAN_TYPE, FILTER_BEAN_TYPE_CONTAINS, FILTER_PATH_CONTAINS, "propertyName", "propertyLabelContains", FILTER_PROPERTY_TYPE);
        this.getBeanTreePath(filter, object);
        this.getNavTreePath(filter, object);
        filter.setKey(this.getOptionalString(object, FILTER_KEY));
        filter.setKeyContains(this.getOptionalString(object, FILTER_KEY_CONTAINS));
        filter.setBeanTypeContains(this.getOptionalString(object, FILTER_BEAN_TYPE_CONTAINS));
        filter.setPathContains(this.getOptionalString(object, FILTER_PATH_CONTAINS));
        filter.setPropertyName(this.getOptionalString(object, "propertyName"));
        filter.setPropertyLabelContains(this.getOptionalString(object, "propertyLabelContains"));
        this.getBeanTypeDef(filter, object);
        this.getPropertyType(filter, object);
        this.getValueFilter(filter, object);
        this.getIncludeInResults(filter, object);
        return this.isOK() ? filter : null;
    }

    private void getBeanTreePath(SearchBeanFilter filter, JsonObject object) {
        List<SearchPathSegmentFilter> segmentFilters = this.getPathSegmentFilters(object, FILTER_BEAN_TREE_PATH);
        if (this.isOK()) {
            filter.setBeanTreePath(segmentFilters);
        }
    }

    private void getNavTreePath(SearchBeanFilter filter, JsonObject object) {
        List<SearchPathSegmentFilter> segmentFilters = this.getPathSegmentFilters(object, FILTER_NAV_TREE_PATH);
        if (this.isOK()) {
            filter.setNavTreePath(segmentFilters);
        }
    }

    private List<SearchPathSegmentFilter> getPathSegmentFilters(JsonObject object, String key) {
        JsonArray segmentFilterObjects = this.getOptionalJsonArray(object, key);
        if (!this.isOK() || segmentFilterObjects == null) {
            return null;
        }
        ArrayList<SearchPathSegmentFilter> segmentFilters = new ArrayList<SearchPathSegmentFilter>();
        for (JsonValue value : segmentFilterObjects) {
            JsonObject segmentFilterObject = this.asJsonObject(key, value);
            if (!this.isOK()) {
                return null;
            }
            SearchPathSegmentFilter segmentFilter = this.getPathSegmentFilter(segmentFilterObject);
            if (!this.isOK()) {
                return null;
            }
            segmentFilters.add(segmentFilter);
        }
        return segmentFilters;
    }

    private SearchPathSegmentFilter getPathSegmentFilter(JsonObject object) {
        this.validateSpecifiesOneOf(object, SEGMENT_ANY_VALUE, "equals", "contains");
        SearchPathSegmentFilter segmentFilter = new SearchPathSegmentFilter();
        segmentFilter.setAnyValue(this.getOptionalBoolean(object, SEGMENT_ANY_VALUE));
        if (!this.isOK()) {
            return null;
        }
        segmentFilter.setEquals(this.getOptionalString(object, "equals"));
        if (!this.isOK()) {
            return null;
        }
        segmentFilter.setContains(this.getOptionalString(object, "contains"));
        if (!this.isOK()) {
            return null;
        }
        return segmentFilter;
    }

    private void getBeanTypeDef(SearchBeanFilter filter, JsonObject object) {
        String beanType = this.getOptionalString(object, FILTER_BEAN_TYPE);
        if (!this.isOK() || StringUtils.isEmpty((String)beanType)) {
            return;
        }
        BeanTypeDef beanTypeDef = this.getInvocationContext().getPageRepo().getBeanRepo().getBeanRepoDef().getTypeDef(beanType);
        if (beanTypeDef == null) {
            this.badFormat("Unknown type: " + beanType + " : " + String.valueOf(object));
        } else {
            filter.setBeanTypeDef(beanTypeDef);
        }
    }

    private void getPropertyType(SearchBeanFilter filter, JsonObject object) {
        String propertyType = this.getOptionalString(object, FILTER_PROPERTY_TYPE);
        if (!this.isOK() || StringUtils.isEmpty((String)propertyType)) {
            return;
        }
        this.validateMatchesOneOf(propertyType, PROPERTY_TYPE_HEALTH_STATE, PROPERTY_TYPE_REFERENCE);
        if (PROPERTY_TYPE_HEALTH_STATE.equals(propertyType)) {
            filter.setPropertyType(SearchBeanFilter.PropertyType.HEALTH_STATE);
        } else if (PROPERTY_TYPE_REFERENCE.equals(propertyType)) {
            filter.setPropertyType(SearchBeanFilter.PropertyType.REFERENCE);
        }
    }

    private void getValueFilter(SearchBeanFilter filter, JsonObject object) {
        this.validatePropertyFilterParameter(filter, object, FILTER_VALUE_FILTER);
        JsonObject valueFilterObject = this.getOptionalJsonObject(object, FILTER_VALUE_FILTER);
        if (!this.isOK() || valueFilterObject == null) {
            return;
        }
        SearchValueFilter valueFilter = new SearchValueFilter();
        this.validateSpecifiesOneOf(valueFilterObject, "equals", VALUE_LESS_THAN, VALUE_LESS_THAN_OR_EQUALS, VALUE_GREATER_THAN, VALUE_GREATER_THAN_OR_EQUALS, VALUE_ONE_OF, "contains");
        valueFilter.setEquals(this.getOptionalValue(valueFilterObject, "equals"));
        valueFilter.setLessThan(this.getOptionalValue(valueFilterObject, VALUE_LESS_THAN));
        valueFilter.setLessThanOrEquals(this.getOptionalValue(valueFilterObject, VALUE_LESS_THAN_OR_EQUALS));
        valueFilter.setGreaterThan(this.getOptionalValue(valueFilterObject, VALUE_GREATER_THAN));
        valueFilter.setGreaterThanOrEquals(this.getOptionalValue(valueFilterObject, VALUE_GREATER_THAN_OR_EQUALS));
        valueFilter.setOneOf(this.getOptionalValues(valueFilterObject, VALUE_ONE_OF));
        valueFilter.setContains(this.getOptionalString(valueFilterObject, "contains"));
        if (this.isOK()) {
            filter.setValueFilter(valueFilter);
        }
    }

    private void getIncludeInResults(SearchBeanFilter filter, JsonObject object) {
        String key = FILTER_INCLUDE_IN_RESULTS;
        this.validatePropertyFilterParameter(filter, object, key);
        if (!this.isOK() || !object.containsKey((Object)key)) {
            return;
        }
        String include = this.getOptionalString(object, key, INCLUDE_IN_RESULTS_IF_MATCHES);
        this.validateMatchesOneOf(include, INCLUDE_IN_RESULTS_ALWAYS, INCLUDE_IN_RESULTS_IF_MATCHES, INCLUDE_IN_RESULTS_NEVER);
        if (INCLUDE_IN_RESULTS_ALWAYS.equals(include)) {
            filter.setIncludeInResults(SearchBeanFilter.IncludeInResults.ALWAYS);
        } else if (INCLUDE_IN_RESULTS_NEVER.equals(include)) {
            filter.setIncludeInResults(SearchBeanFilter.IncludeInResults.NEVER);
        }
    }

    private void validatePropertyFilterParameter(SearchBeanFilter filter, JsonObject object, String key) {
        boolean isPropertyFilter = StringUtils.notEmpty((String)this.getOptionalString(object, "propertyName")) || StringUtils.notEmpty((String)this.getOptionalString(object, "propertyLabelContains")) || StringUtils.notEmpty((String)this.getOptionalString(object, FILTER_PROPERTY_TYPE));
        boolean haveValueFilter = object.containsKey((Object)FILTER_VALUE_FILTER);
        if (!isPropertyFilter && haveValueFilter) {
            this.badFormat(key + " must not be specified: " + String.valueOf(object));
        }
    }

    private List<SearchProperty> getProperties(JsonObject object) {
        ArrayList<SearchProperty> properties = new ArrayList<SearchProperty>();
        JsonArray array = this.getOptionalJsonArray(object, CRITERIA_PROPERTIES);
        if (this.isOK() && array != null) {
            for (int i = 0; this.isOK() && i < array.size(); ++i) {
                properties.add(this.getProperty((JsonValue)array.get(i)));
            }
        }
        return this.isOK() ? properties : null;
    }

    private SearchProperty getProperty(JsonValue value) {
        JsonObject object = this.asJsonObject(CRITERIA_PROPERTIES, value);
        if (!this.isOK()) {
            return null;
        }
        SearchProperty property = new SearchProperty();
        this.validateSpecifiesOneOf(object, "propertyName", "propertyLabelContains");
        property.setPropertyName(this.getOptionalString(object, "propertyName"));
        property.setPropertyLabelContains(this.getOptionalString(object, "propertyLabelContains"));
        return this.isOK() ? property : null;
    }

    private void validateSpecifiesOneOf(JsonObject object, String ... options) {
        int count = 0;
        for (String option : options) {
            if (!object.containsKey((Object)option)) continue;
            ++count;
        }
        if (count != 1) {
            this.badFormat("Must specify exactly one of " + Arrays.toString(options) + " : " + String.valueOf(object));
        }
    }

    private void validateMatchesOneOf(String value, String ... options) {
        for (String option : options) {
            if (!option.equals(value)) continue;
            return;
        }
        this.badFormat("Must specify one of " + Arrays.toString(options) + " : " + value);
    }

    private List<Value> getOptionalValues(JsonObject object, String key) {
        ArrayList<Value> values = new ArrayList<Value>();
        JsonArray array = this.getOptionalJsonArray(object, key);
        if (this.isOK() && array != null) {
            if (array.isEmpty()) {
                this.badFormat(key + " must not be an empty array: " + String.valueOf(object));
            }
            for (int i = 0; this.isOK() && i < array.size(); ++i) {
                values.add(this.asValue((JsonValue)array.get(i), key));
            }
        }
        return !this.isOK() || values.isEmpty() ? null : values;
    }

    private Value getOptionalValue(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        if (value == null) {
            return null;
        }
        return this.asValue(value, key);
    }

    private Value asValue(JsonValue value, String key) {
        JsonValue.ValueType typeHave = value.getValueType();
        if (typeHave == JsonValue.ValueType.STRING) {
            return new StringValue(this.asString(key, value));
        }
        if (typeHave == JsonValue.ValueType.NUMBER) {
            return new LongValue(this.asLong(key, value));
        }
        if (typeHave == JsonValue.ValueType.TRUE || typeHave == JsonValue.ValueType.FALSE) {
            return new BooleanValue(this.asBoolean(key, value));
        }
        BeanTreePath btp = this.asBeanTreePath(key, value);
        if (btp != null) {
            return btp;
        }
        this.badFormat(key + " must be a string, number, boolean or bean tree path: " + String.valueOf(typeHave));
        return null;
    }
}

