/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.Date;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.utils.DateUtils;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.DownloadValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LabelValue;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.SecretValue;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.ThrowableValue;
import weblogic.remoteconsole.server.repo.UnresolvedReference;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.UriUtils;

public abstract class ResponseMapper<T> {
    private InvocationContext invocationContext;
    private JsonObjectBuilder entityBuilder;
    private weblogic.remoteconsole.server.repo.Response<T> response;

    protected ResponseMapper(InvocationContext invocationContext, weblogic.remoteconsole.server.repo.Response<T> response) {
        this.invocationContext = invocationContext;
        this.response = response;
    }

    protected InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    protected JsonObjectBuilder getEntityBuilder() {
        return this.entityBuilder;
    }

    protected weblogic.remoteconsole.server.repo.Response<T> getResponse() {
        return this.response;
    }

    protected Response toResponse() {
        this.entityBuilder = Json.createObjectBuilder();
        this.addMessages();
        if (this.getResponse().isNotFound()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getEntityBuilder().build()).build();
        }
        if (this.getResponse().isServiceNotAvailable()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)this.getEntityBuilder().build()).build();
        }
        if (this.getResponse().isTimeout()) {
            return Response.status((Response.Status)Response.Status.GATEWAY_TIMEOUT).entity((Object)this.getEntityBuilder().build()).build();
        }
        if (this.getResponse().isUserBadRequest()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getEntityBuilder().build()).build();
        }
        if (this.getResponse().isFrontEndBadRequest()) {
            this.getEntityBuilder().add("frontEndBadRequest", true);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getEntityBuilder().build()).build();
        }
        if (this.getResponse().isSuccess()) {
            this.addResults();
            return Response.ok((Object)this.getEntityBuilder().build()).build();
        }
        throw new AssertionError((Object)("Unsupported Response " + String.valueOf(this.getResponse().getClass())));
    }

    private void addMessages() {
        weblogic.remoteconsole.server.repo.Response<T> response = this.getResponse();
        if (response.getMessages().isEmpty()) {
            if (response.isUserBadRequest()) {
                response.addFailureMessage(this.getInvocationContext().getLocalizer().localizeString(LocalizedConstants.REFER_TO_LOGS, new Object[0]));
            } else {
                return;
            }
        }
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Message pageMessage : this.getResponse().getMessages()) {
            builder.add(this.messageToJson(pageMessage));
        }
        this.getEntityBuilder().add("messages", builder);
    }

    private JsonObjectBuilder messageToJson(Message message) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("severity", this.getSeverity(message));
        builder.add("message", message.getText());
        String property = message.getProperty();
        if (StringUtils.notEmpty((String)property)) {
            builder.add("property", property);
        }
        return builder;
    }

    private String getSeverity(Message message) {
        if (message.isSuccess()) {
            return "info";
        }
        if (message.isWarning()) {
            return "warning";
        }
        if (message.isFailure()) {
            return "error";
        }
        throw new AssertionError((Object)"Unsupported message type");
    }

    protected abstract void addResults();

    protected void addValueToJsonObject(JsonObjectBuilder builder, Value value) {
        Value unsettableValue = Value.unsettableValue(value);
        if (unsettableValue == null) {
            return;
        }
        if (value.isSettable()) {
            SettableValue settable = value.asSettable();
            if (settable.isSet()) {
                builder.add("set", true);
            } else if (settable.isUnset()) {
                builder.add("set", false);
            }
        }
        if (unsettableValue.isUnknown()) {
            return;
        }
        if (unsettableValue.isModelToken()) {
            builder.add("modelToken", unsettableValue.asModelToken().getToken());
        } else {
            builder.add("value", this.valueToJson(unsettableValue));
        }
    }

    protected JsonValue valueToJson(Value value) {
        if (value.isArray()) {
            return this.arrayToJson(value.asArray());
        }
        if (value.isString()) {
            return this.stringToJson(value.asString());
        }
        if (value.isBoolean()) {
            return this.booleanToJson(value.asBoolean().getValue());
        }
        if (value.isLong()) {
            return Json.createValue((long)value.asLong().getValue());
        }
        if (value.isInt()) {
            return Json.createValue((int)value.asInt().getValue());
        }
        if (value.isDouble()) {
            return Json.createValue((double)value.asDouble().getValue());
        }
        if (value.isNullReference()) {
            return JsonValue.NULL;
        }
        if (value.isBeanTreePath()) {
            return this.beanTreePathToJson(value.asBeanTreePath());
        }
        if (value.isUnresolvedReference()) {
            return this.unresolvedReferenceToJson(value.asUnresolvedReference());
        }
        if (value.isReferenceAsReferences()) {
            return this.valueToJson(value.asReferenceAsReferences().asReference());
        }
        if (value.isSecret()) {
            return this.secretToJson(value.asSecret());
        }
        if (value.isDate()) {
            return this.dateToJson(value.asDate().getValue());
        }
        if (value.isProperties()) {
            return this.propertiesToJson(value.asProperties());
        }
        if (value.isDateAsLong()) {
            return this.valueToJson(value.asDateAsLong().asDate());
        }
        if (value.isHealthState()) {
            return Json.createValue((String)value.asHealthState().getValue());
        }
        if (value.isThrowable()) {
            return this.throwableToJson(value.asThrowable());
        }
        if (value.isEntitleNetExpression()) {
            return value.asEntitleNetExpression().getValue();
        }
        if (value.isDownload()) {
            return this.downloadToJson(value.asDownload());
        }
        if (value.isLabel()) {
            return this.labelToJson(value.asLabel());
        }
        throw new AssertionError((Object)("Unsupported value: " + String.valueOf(value.getClass())));
    }

    private JsonValue stringToJson(StringValue value) {
        String str = value.getValue();
        if (str == null) {
            return JsonValue.NULL;
        }
        return Json.createValue((String)str);
    }

    private JsonValue secretToJson(SecretValue value) {
        String str = value.getValue();
        if (str == null) {
            return JsonValue.NULL;
        }
        return Json.createValue((String)"********");
    }

    private JsonValue propertiesToJson(PropertiesValue value) {
        Properties properties = value.getValue();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String key : properties.stringPropertyNames()) {
            String val = properties.getProperty(key);
            builder.add(key, val);
        }
        return builder.build();
    }

    private JsonValue throwableToJson(ThrowableValue value) {
        return this.throwableToJson(value.getValue());
    }

    private JsonValue throwableToJson(Throwable throwable) {
        if (throwable == null) {
            return JsonValue.NULL;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("message", throwable.getMessage());
        builder.add("cause", this.throwableToJson(throwable.getCause()));
        return builder.build();
    }

    private JsonValue arrayToJson(ArrayValue array) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Value value : array.getValues()) {
            JsonObjectBuilder itemBuilder = Json.createObjectBuilder();
            this.addValueToJsonObject(itemBuilder, value);
            builder.add(itemBuilder);
        }
        return builder.build();
    }

    private JsonValue unresolvedReferenceToJson(UnresolvedReference unresolvedReference) {
        String key = unresolvedReference.getKey();
        return Json.createObjectBuilder().add("label", key).add("unresolvedReference", key).build();
    }

    private JsonValue booleanToJson(boolean val) {
        return val ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private JsonValue dateToJson(Date date) {
        return Json.createValue((String)StringUtils.nonNull((String)DateUtils.formatDate(date)));
    }

    protected JsonValue beanTreePathToJson(BeanTreePath beanTreePath) {
        return this.beanTreePathToJson(beanTreePath, "");
    }

    protected JsonValue beanTreePathToJson(BeanTreePath beanTreePath, String queryParams) {
        return this.beanTreePathToJson(beanTreePath, this.getBeanTreePathLabel(beanTreePath), queryParams);
    }

    protected JsonValue beanTreePathToJson(BeanTreePath beanTreePath, String label, String queryParams) {
        return Json.createObjectBuilder().add("label", label).add("resourceData", this.getBackendRelativeUri(beanTreePath, queryParams)).build();
    }

    protected JsonValue downloadToJson(DownloadValue download) {
        String anchor = "<a href=\"" + UriUtils.getBackendRelativeUri(this.getInvocationContext(), download.getPath()) + "\" download=\"" + download.getFileName() + "\" type=\"" + download.getMediaType() + "\" target=\"_blank\"></a>";
        return Json.createObjectBuilder().add("label", download.getLabel()).add("href", anchor).build();
    }

    protected JsonValue labelToJson(LabelValue label) {
        return Json.createObjectBuilder().add("label", label.getLabel()).build();
    }

    private String getBeanTreePathLabel(BeanTreePath beanTreePath) {
        if (beanTreePath == null) {
            return this.getInvocationContext().getLocalizer().localizeString(LocalizedConstants.NULL_REFERENCE, new Object[0]);
        }
        if (beanTreePath.isRoot()) {
            return "";
        }
        BeanTreePathSegment lastSegment = beanTreePath.getLastSegment();
        BeanChildDef childDef = lastSegment.getChildDef();
        if (childDef.isCollection() && lastSegment.isKeySet()) {
            return lastSegment.getKey();
        }
        return this.getInvocationContext().getLocalizer().localizeString(childDef.getLabel(), new Object[0]);
    }

    protected JsonValue getBackendRelativeUri(BeanTreePath beanTreePath, String queryParams) {
        if (beanTreePath == null) {
            return JsonValue.NULL;
        }
        return this.getBackendRelativeUri(beanTreePath.getPath(), queryParams);
    }

    protected JsonValue getBackendRelativeUri(Path rootRelativePath, String queryParams) {
        Path connectionRelativePath = new Path();
        String pageRepoName = this.getInvocationContext().getPageRepo().getPageRepoDef().getName();
        connectionRelativePath.addComponent(pageRepoName);
        connectionRelativePath.addComponent("data");
        connectionRelativePath.addPath(rootRelativePath);
        String backendRelativeUri = UriUtils.getBackendRelativeUri(this.getInvocationContext(), connectionRelativePath) + queryParams;
        return Json.createValue((String)backendRelativeUri);
    }
}

