/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.utils.DateUtils;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;

public abstract class RequestBodyMapper<T> {
    private InvocationContext ic;
    private JsonObject requestBody;
    private FormDataMultiPart parts;
    private Response<T> response = new Response();
    protected static final String PROP_RESOURCE_DATA = "resourceData";

    protected RequestBodyMapper(InvocationContext ic, JsonObject requestBody) {
        this(ic, requestBody, null);
    }

    protected RequestBodyMapper(InvocationContext ic, JsonObject requestBody, FormDataMultiPart parts) {
        this.ic = ic;
        this.requestBody = requestBody;
        this.parts = parts;
    }

    public Response<T> fromRequestBody() {
        if (this.isOK()) {
            this.parseRequestBody();
        }
        return this.getResponse();
    }

    protected InvocationContext getInvocationContext() {
        return this.ic;
    }

    protected JsonObject getRequestBody() {
        return this.requestBody;
    }

    protected FormDataMultiPart getParts() {
        return this.parts;
    }

    public Response<T> getResponse() {
        return this.response;
    }

    protected boolean isOK() {
        return this.getResponse().isSuccess();
    }

    protected abstract void parseRequestBody();

    protected JsonObject getRequiredJsonObject(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asJsonObject(key, value) : null;
    }

    protected JsonObject getOptionalJsonObject(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asJsonObject(key, value) : null;
    }

    protected JsonArray getRequiredJsonArray(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asJsonArray(key, value) : null;
    }

    protected JsonArray getOptionalJsonArray(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asJsonArray(key, value) : null;
    }

    protected String getRequiredString(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asString(key, value) : null;
    }

    protected String getOptionalString(JsonObject object, String key) {
        return this.getOptionalString(object, key, null);
    }

    protected String getOptionalString(JsonObject object, String key, String defaultValue) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asString(key, value) : defaultValue;
    }

    protected boolean getRequiredBoolean(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asBoolean(key, value) : false;
    }

    protected boolean getOptionalBoolean(JsonObject object, String key) {
        return this.getOptionalBoolean(object, key, false);
    }

    protected boolean getOptionalBoolean(JsonObject object, String key, boolean dflt) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asBoolean(key, value) : dflt;
    }

    protected int getRequiredInt(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asInt(key, value) : 0;
    }

    protected int getOptionalInt(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asInt(key, value) : 0;
    }

    protected long getRequiredLong(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asLong(key, value) : 0L;
    }

    protected long getOptionalLong(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asLong(key, value) : 0L;
    }

    protected double getRequiredDouble(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asDouble(key, value) : 0.0;
    }

    protected double getOptionalDouble(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asDouble(key, value) : 0.0;
    }

    protected Date getRequiredDate(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asDate(key, value) : null;
    }

    protected Date getOptionalDate(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asDate(key, value) : null;
    }

    protected BeanTreePath getRequiredBeanTreePath(JsonObject object, String key) {
        JsonValue value = this.getRequiredJsonValue(object, key);
        return value != null ? this.asBeanTreePath(key, value) : null;
    }

    protected BeanTreePath getOptionalBeanTreePath(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        return value != null ? this.asBeanTreePath(key, value) : null;
    }

    protected BeanTreePath asBeanTreePath(String key, JsonValue jsonValue) {
        JsonObject jsonObject = this.asJsonObject(key, jsonValue);
        if (!this.isOK()) {
            return null;
        }
        String resourceData = this.getRequiredString(jsonObject, PROP_RESOURCE_DATA);
        if (StringUtils.isEmpty((String)resourceData)) {
            this.badFormat(key + " resourceData must not be null or empty");
            return null;
        }
        Path requiredPrefixPath = new Path();
        requiredPrefixPath.addComponent("api");
        requiredPrefixPath.addComponent(this.getInvocationContext().getProvider().getName());
        requiredPrefixPath.addComponent(this.getInvocationContext().getPageRepo().getPageRepoDef().getName());
        requiredPrefixPath.addComponent("data");
        String requiredPrefix = "/" + UrlUtils.pathToRelativeUri(requiredPrefixPath);
        if (!resourceData.startsWith(requiredPrefix)) {
            this.badFormat(key + " resourceData must start with " + requiredPrefix + " : " + resourceData);
            return null;
        }
        Path repoRelativePath = UrlUtils.relativeUriToPath(resourceData.substring(requiredPrefix.length()));
        return BeanTreePath.create(this.getInvocationContext().getPageRepo().getBeanRepo(), repoRelativePath);
    }

    protected JsonValue getRequiredJsonValue(JsonObject object, String key) {
        JsonValue value = this.getOptionalJsonValue(object, key);
        if (value == null) {
            this.badFormat(key + " is required");
            return null;
        }
        return value;
    }

    protected JsonValue getOptionalJsonValue(JsonObject object, String key) {
        return object.containsKey((Object)key) ? (JsonValue)object.get((Object)key) : null;
    }

    protected JsonObject asJsonObject(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.OBJECT, JsonValue.ValueType.NULL)) {
            if (value == JsonValue.NULL) {
                return JsonValue.EMPTY_JSON_OBJECT;
            }
            return value.asJsonObject();
        }
        return null;
    }

    protected JsonArray asJsonArray(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.ARRAY, JsonValue.ValueType.NULL)) {
            if (value == JsonValue.NULL) {
                return JsonValue.EMPTY_JSON_ARRAY;
            }
            return value.asJsonArray();
        }
        return null;
    }

    protected String asString(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.STRING, JsonValue.ValueType.NULL)) {
            if (JsonString.class.isInstance(value)) {
                return ((JsonString)JsonString.class.cast(value)).getString();
            }
            return null;
        }
        return null;
    }

    protected boolean asBoolean(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.TRUE, JsonValue.ValueType.FALSE)) {
            return value == JsonValue.TRUE;
        }
        return false;
    }

    protected int asInt(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.NUMBER)) {
            try {
                return ((JsonNumber)JsonNumber.class.cast(value)).intValueExact();
            }
            catch (ArithmeticException e) {
                this.badFormat(key + " must be an integer: " + String.valueOf(value));
            }
        }
        return 0;
    }

    protected long asLong(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.NUMBER)) {
            try {
                return ((JsonNumber)JsonNumber.class.cast(value)).longValueExact();
            }
            catch (ArithmeticException e) {
                this.badFormat(key + " must be a long: " + String.valueOf(value));
            }
        }
        return 0L;
    }

    protected double asDouble(String key, JsonValue value) {
        if (this.validateType(value, key, JsonValue.ValueType.NUMBER)) {
            return ((JsonNumber)JsonNumber.class.cast(value)).doubleValue();
        }
        return 0.0;
    }

    protected Date asDate(String key, JsonValue value) {
        String dateAsString = this.asString(key, value);
        if (this.isOK()) {
            try {
                return DateUtils.parseDate(dateAsString);
            }
            catch (ParseException e) {
                this.badFormat(e.getMessage());
            }
        }
        return null;
    }

    protected boolean validateType(JsonValue value, String key, JsonValue.ValueType ... typesWant) {
        JsonValue.ValueType typeHave = value.getValueType();
        for (JsonValue.ValueType typeWant : typesWant) {
            if (typeWant != typeHave) continue;
            return true;
        }
        this.badFormat(key + " must be " + Arrays.toString(typesWant) + ", received " + String.valueOf(typeHave));
        return false;
    }

    protected void badFormat(String message) {
        this.getResponse().addFailureMessage(message);
        this.getResponse().setFrontEndBadRequest();
    }
}

