/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;
import weblogic.remoteconsole.server.providers.Provider;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.webapp.AboutResource;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.BookmarksResource;
import weblogic.remoteconsole.server.webapp.DomainStatusResource;
import weblogic.remoteconsole.server.webapp.FailedRequestException;
import weblogic.remoteconsole.server.webapp.LogoutResource;
import weblogic.remoteconsole.server.webapp.PageRepoResource;
import weblogic.remoteconsole.server.webapp.PropertyListPageRepoResource;
import weblogic.remoteconsole.server.webapp.ProviderResource;
import weblogic.remoteconsole.server.webapp.SsoTokenResource;
import weblogic.remoteconsole.server.webapp.WebAppUtils;
import weblogic.remoteconsole.server.webapp.WebLogicRestRuntimeTreeMonitoringResource;

@Path(value="api")
public class RemoteConsoleResource
extends BaseResource {
    public static final String PROVIDER_MANAGEMENT_PATH = "providers";
    public static final String ABOUT_PATH = "about";
    public static final String BOOKMARKS_PATH = "bookmarks";
    public static final String LOGOUT_PATH = "logout";
    public static final String SSO_TOKEN_PATH = "token";
    public static final String DOMAIN_STATUS_PATH = "domainStatus";
    @Context
    ResourceContext resourceContext;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;

    @Path(value="logout")
    public LogoutResource getLogoutResource() {
        return new LogoutResource();
    }

    @Path(value="about")
    public AboutResource getAboutResourceNew() {
        return new AboutResource();
    }

    @Path(value="bookmarks")
    public BookmarksResource getBookmarksResourceNew() {
        return new BookmarksResource();
    }

    @Path(value="domainStatus")
    public DomainStatusResource getStatusResource() {
        if (!(this.getInvocationContext().getProvider() instanceof AdminServerDataProvider)) {
            throw new FailedRequestException(Response.Status.NOT_FOUND.getStatusCode(), "The provider " + this.getInvocationContext().getProvider().getName() + " is not an AdminServerDataProvider");
        }
        return this.copyContext(new DomainStatusResource());
    }

    @Path(value="providers")
    public ProviderResource getProviderResource() {
        return new ProviderResource();
    }

    @Path(value="token")
    public SsoTokenResource getSsoTokenResource() {
        return new SsoTokenResource();
    }

    @Path(value="edit")
    public PageRepoResource getWebLogicRestEditTreeConfigurationResource() {
        if (!this.getInvocationContext().setPageRepoByName("edit")) {
            throw new FailedRequestException(Response.Status.NOT_FOUND.getStatusCode(), "There is no edit in " + this.getInvocationContext().getProvider().getName());
        }
        this.updateLastUsed();
        return this.copyContext(new PageRepoResource());
    }

    @Path(value="compositeConfig")
    public PageRepoResource getWDTCompositeConfigurationResource() {
        if (!this.getInvocationContext().setPageRepoByName("compositeConfig")) {
            throw new FailedRequestException(Response.Status.NOT_FOUND.getStatusCode(), "There is no compositeConfig in " + this.getInvocationContext().getProvider().getName());
        }
        return this.copyContext(new PageRepoResource());
    }

    @Path(value="propertyList")
    public BaseResource getPropertyListConfigurationResource() {
        return this.copyContext(new PropertyListPageRepoResource());
    }

    @Path(value="serverConfig")
    public PageRepoResource getWebLogicRestRuntimeTreeConfigurationResource() {
        if (!this.getInvocationContext().setPageRepoByName("serverConfig")) {
            throw new FailedRequestException(Response.Status.NOT_FOUND.getStatusCode(), "There is no serverConfig in " + this.getInvocationContext().getProvider().getName());
        }
        this.updateLastUsed();
        return this.copyContext(new PageRepoResource());
    }

    @Path(value="securityData")
    public PageRepoResource getWebLogicRestSecurityDataResource() {
        if (!this.getInvocationContext().setPageRepoByName("securityData")) {
            throw new FailedRequestException(Response.Status.NOT_FOUND.getStatusCode(), "There is no securityData in " + this.getInvocationContext().getProvider().getName());
        }
        this.updateLastUsed();
        return this.copyContext(new PageRepoResource());
    }

    @Path(value="domainRuntime")
    public PageRepoResource getWebLogicRestRuntimeTreeMonitoringResource() {
        if (!this.getInvocationContext().setPageRepoByName("domainRuntime")) {
            throw new FailedRequestException(Response.Status.NOT_FOUND.getStatusCode(), "There is no domainRuntime in " + this.getInvocationContext().getProvider().getName());
        }
        this.updateLastUsed();
        return this.copyContext(new WebLogicRestRuntimeTreeMonitoringResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized InvocationContext getInvocationContext() {
        InvocationContext ret = super.getInvocationContext();
        if (ret != null) {
            return ret;
        }
        ret = WebAppUtils.getInvocationContextFromResourceContext(this.resourceContext);
        if (ret == null) {
            ret = new InvocationContext(this.resourceContext, this.headers, this.uriInfo);
        }
        RemoteConsoleResource remoteConsoleResource = this;
        synchronized (remoteConsoleResource) {
            this.setInvocationContext(ret);
        }
        return ret;
    }

    private void updateLastUsed() {
        Provider provider = this.getInvocationContext().getProvider();
        if (provider instanceof AdminServerDataProvider) {
            ((AdminServerDataProvider)provider).updateLastUsed();
        }
    }
}

