/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;
import weblogic.remoteconsole.server.providers.Provider;
import weblogic.remoteconsole.server.providers.ProviderManager;
import weblogic.remoteconsole.server.providers.WDTModelDataProvider;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.WebAppUtils;

public class ProviderResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(ProviderResource.class.getName());
    private static final Set<String> reservedNames = new HashSet<String>();
    public static final String DOMAIN_URL = "domainUrl";
    public static final String WDT_MODEL = "model";
    public static final String WDT_MODELS = "modelNames";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY_LISTS = "propertyLists";
    public static final String PROVIDER_TYPE = "providerType";
    public static final String PROVIDER_NAME = "name";
    public static final String PROVIDER_LABEL = "label";
    public static final String PROVIDER_SETTINGS = "settings";
    public static final String PROVIDER_INSECURE = "insecure";
    public static final String PROXY_OVERRIDE = "proxyOverride";
    public static final String PROVIDER_SSO = "sso";
    public static final String PROVIDER_LOCAL = "local";
    public static final String TEST_ACTION = "test";
    @Context
    HttpHeaders headers;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pathSegments: .+}")
    public Response getProviderInfoWithPath(@QueryParam(value="action") @DefaultValue(value="none") String action, @PathParam(value="pathSegments") List<PathSegment> pathSegments, @Context ResourceContext resourceContext) {
        int nameIndex = 0;
        if (pathSegments.size() <= nameIndex) {
            return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Need name")).build();
        }
        String first = pathSegments.get(nameIndex).getPath();
        String typeConstraint = null;
        String nameConstraint = null;
        if (first.equals("AdminServerConnection") || first.equals("WDTModel") || first.equals("WDTCompositeModel") || first.equals("PropertyList")) {
            typeConstraint = first;
            if (pathSegments.size() <= ++nameIndex) {
                return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Need name")).build();
            }
        }
        nameConstraint = pathSegments.get(nameIndex).getPath();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            if (typeConstraint != null && !prov.getType().equals(typeConstraint) || nameConstraint != null && !prov.getName().equals(nameConstraint)) continue;
            if (action.equals(TEST_ACTION)) {
                prov.test(ic);
                ProviderResource.removeSsoTokenAdminServerConnection(pm, prov);
            }
            if (action.equals("start")) {
                prov.start(ic);
                ProviderResource.removeSsoTokenAdminServerConnection(pm, prov);
            }
            return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)prov.toJSON(ic), (String)"application/json")).build();
        }
        pm.save(ic);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"No such provider")).build();
    }

    private static void removeSsoTokenAdminServerConnection(ProviderManager pm, Provider provider) {
        if (provider.getType().equals("AdminServerConnection")) {
            pm.removeSsoToken(provider.getName());
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/help")
    public Response getAllHelp(@Context ResourceContext resourceContext) {
        JsonObjectBuilder ret = Json.createObjectBuilder();
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        ret.add("data", (JsonValue)ProviderManager.getAllHelp(ic));
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)ret.build(), (String)"application/json")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/AdminServerConnection")
    public Response getProviderInfoAdminServerDataProviders(@Context ResourceContext resourceContext) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            if (!prov.getType().equals("AdminServerConnection")) continue;
            builder.add((JsonValue)prov.toJSON(ic));
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/WDTModel")
    public Response getProviderInfoWDTModelDataProviders(@Context ResourceContext resourceContext) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            if (!prov.getType().equals("WDTModel")) continue;
            builder.add((JsonValue)prov.toJSON(ic));
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/WDTCompositeModel")
    public Response getProviderInfoWDTCompositeDataProviders(@Context ResourceContext resourceContext) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            if (!prov.getType().equals("WDTCompositeModel")) continue;
            builder.add((JsonValue)prov.toJSON(ic));
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/PropertyList")
    public Response getProviderInfoPropertyListDataProviders(@Context ResourceContext resourceContext) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            if (!prov.getType().equals("PropertyList")) continue;
            builder.add((JsonValue)prov.toJSON(ic));
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getProviderInfoAll(@Context ResourceContext resourceContext) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            builder.add((JsonValue)prov.toJSON(ic));
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteProviderInfoAll(@Context ResourceContext resourceContext) {
        ProviderManager.getFromContext(resourceContext).terminateAllProviders();
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok().entity((Object)Json.createObjectBuilder().build()).type("application/json")).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/AdminServerConnection")
    public Response submitProviderInfoAdminPath(@Context ResourceContext resourceContext, @HeaderParam(value="Authorization") String authHeader, JsonObject data) {
        LOGGER.fine("POST provider");
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        if (data == null) {
            LOGGER.fine("POST create bad request: no data");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Request Content").build();
        }
        JsonString jname = data.getJsonString(PROVIDER_NAME);
        if (jname == null) {
            LOGGER.fine("POST create bad request: no name");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Name").build();
        }
        String name = jname.getString();
        JsonString jsonLabel = data.getJsonString(PROVIDER_LABEL);
        String label = jsonLabel == null ? name : jsonLabel.getString();
        return ProviderResource.submitAdminServerDataProviderInfo(pm, name, label, resourceContext, authHeader, data);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/WDTModel")
    public Response submitProviderInfoWDTModelPath(@Context ResourceContext resourceContext, @FormDataParam(value="data") InputStream dataStream, @FormDataParam(value="model") InputStream modelStream, @FormDataParam(value="model") FormDataContentDisposition modelContent) throws Exception {
        JsonString jsonLabel;
        LOGGER.fine("POST provider");
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        JsonObject data = Json.createReader((InputStream)dataStream).readObject();
        JsonString jname = data.getJsonString(PROVIDER_NAME);
        if (jname == null) {
            LOGGER.fine("POST create bad request: no name");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Name").build();
        }
        String name = jname.getString();
        ArrayList<String> propLists = null;
        JsonArray jprops = data.getJsonArray(PROPERTY_LISTS);
        if (jprops != null && !jprops.isEmpty()) {
            LOGGER.fine("POST specified property list providers");
            propLists = new ArrayList<String>(jprops.size());
            for (int i = 0; i < jprops.size(); ++i) {
                propLists.add(jprops.getString(i));
            }
        }
        boolean isJson = false;
        if (modelContent != null && modelContent.getFileName() != null) {
            String fileName = modelContent.getFileName().trim().toLowerCase();
            isJson = fileName.endsWith(".json");
        }
        String label = (jsonLabel = data.getJsonString(PROVIDER_LABEL)) == null ? name : jsonLabel.getString();
        return ProviderResource.submitWDTModelDataProviderInfo(pm, name, label, resourceContext, modelStream, propLists, isJson);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/WDTCompositeModel")
    public Response submitProviderInfoWDTCompositeModels(@Context ResourceContext resourceContext, JsonObject data) {
        LOGGER.fine("POST provider");
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        if (data == null) {
            LOGGER.fine("POST create bad request: no data");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Request Content").build();
        }
        JsonString jname = data.getJsonString(PROVIDER_NAME);
        if (jname == null) {
            LOGGER.fine("POST create bad request: no name");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Name").build();
        }
        String name = jname.getString();
        JsonString jsonLabel = data.getJsonString(PROVIDER_LABEL);
        String label = jsonLabel == null ? name : jsonLabel.getString();
        return ProviderResource.submitWDTCompositeDataProviderInfo(pm, name, label, resourceContext, data);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/PropertyList")
    public Response submitProviderInfoPropertyListDataProviders(@Context ResourceContext resourceContext, @FormDataParam(value="data") InputStream dataStream, @FormDataParam(value="properties") InputStream propertiesStream) {
        LOGGER.fine("POST provider");
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        JsonObject data = Json.createReader((InputStream)dataStream).readObject();
        JsonString jname = data.getJsonString(PROVIDER_NAME);
        if (jname == null) {
            LOGGER.fine("POST create bad request: no name");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Name").build();
        }
        String name = jname.getString();
        JsonString jsonLabel = data.getJsonString(PROVIDER_LABEL);
        String label = jsonLabel == null ? name : jsonLabel.getString();
        return ProviderResource.submitPropertyListDataProviderInfo(pm, name, label, resourceContext, propertiesStream);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response submitProviderInfoAny(@Context ResourceContext resourceContext, @HeaderParam(value="Authorization") String authorizationHeader, JsonObject data) {
        LOGGER.fine("POST provider");
        if (data == null) {
            LOGGER.fine("POST create bad request: no data");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Request Content").build();
        }
        if (data.getJsonArray("dataProviders") != null) {
            JsonArray dataProviders = data.getJsonArray("dataProviders");
            for (int i = 0; i < dataProviders.size(); ++i) {
                Response resp = this.createOneAnyProvider(resourceContext, authorizationHeader, dataProviders.getJsonObject(i));
                if (resp.getStatus() == Response.Status.CREATED.getStatusCode()) continue;
                return resp;
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)Json.createObjectBuilder().build()).type("application/json").build();
        }
        return this.createOneAnyProvider(resourceContext, authorizationHeader, data);
    }

    private Response createOneAnyProvider(@Context ResourceContext resourceContext, @HeaderParam(value="Authorization") String authorizationHeader, JsonObject data) {
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        JsonString jname = data.getJsonString(PROVIDER_NAME);
        if (jname == null) {
            LOGGER.fine("POST create bad request: no name");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Name").build();
        }
        String name = jname.getString();
        JsonString jsonLabel = data.getJsonString(PROVIDER_LABEL);
        String label = jsonLabel == null ? name : jsonLabel.getString();
        JsonString jtype = data.getJsonString(PROVIDER_TYPE);
        if (jtype == null) {
            LOGGER.fine("POST create bad request: no type");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Type").build();
        }
        if (jtype.getString().equals("AdminServerConnection")) {
            return ProviderResource.submitAdminServerDataProviderInfo(pm, name, label, resourceContext, authorizationHeader, data);
        }
        if (jtype.getString().equals("WDTModel")) {
            return ProviderResource.submitWDTModelDataProviderInfo(pm, name, label, resourceContext, data);
        }
        if (jtype.getString().equals("WDTCompositeModel")) {
            return ProviderResource.submitWDTCompositeDataProviderInfo(pm, name, label, resourceContext, data);
        }
        if (jtype.getString().equals("PropertyList")) {
            return ProviderResource.submitPropertyListDataProviderInfo(pm, name, label, resourceContext, data);
        }
        LOGGER.fine("POST create bad request: bad type");
        return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)("Unknown Data Provider Type " + jtype.getString() + " for " + name)).build();
    }

    private static Response submitAdminServerDataProviderInfo(ProviderManager pm, String name, String label, ResourceContext resourceContext, String authorizationHeader, JsonObject data) {
        if (reservedNames.contains(name)) {
            LOGGER.fine("POST create reserved name: " + name);
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Reserved name").build();
        }
        JsonString jurl = data.getJsonString(DOMAIN_URL);
        if (jurl == null) {
            LOGGER.fine("POST create bad request");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing URL").build();
        }
        String url = jurl.getString();
        boolean sso = ProviderResource.getSsoAdminServerDataProviderSetting(data);
        if (StringUtils.isEmpty((String)url) || !sso && StringUtils.isEmpty((String)authorizationHeader)) {
            LOGGER.fine("POST create bad request");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing Admin Server Data Provider Content").build();
        }
        boolean local = ProviderResource.getDirectAdminServerDataProviderSetting(data);
        LOGGER.fine("POST data: " + data.toString());
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        ProviderResource.updateAdminServerDataProvider(pm.createAdminServerDataProvider(name, label, url, authorizationHeader, sso, local), data);
        pm.save(ic);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((Response.Status)Response.Status.CREATED).entity((Object)pm.getJSON(name, ic)).type("application/json")).build();
    }

    private static boolean getSsoAdminServerDataProviderSetting(JsonObject data) {
        JsonValue sso;
        JsonObject bag = data.getJsonObject(PROVIDER_SETTINGS);
        return bag != null && bag != JsonValue.NULL && (sso = (JsonValue)bag.get((Object)PROVIDER_SSO)) != null && sso != JsonValue.NULL && bag.getBoolean(PROVIDER_SSO);
    }

    private static boolean getDirectAdminServerDataProviderSetting(JsonObject data) {
        JsonValue localJSON;
        JsonObject bag = data.getJsonObject(PROVIDER_SETTINGS);
        return bag != null && bag != JsonValue.NULL && (localJSON = (JsonValue)bag.get((Object)PROVIDER_LOCAL)) != null && localJSON != JsonValue.NULL && bag.getBoolean(PROVIDER_LOCAL);
    }

    private static void updateAdminServerDataProvider(AdminServerDataProvider provider, JsonObject data) {
        JsonValue proxyOverride;
        JsonObject bag = data.getJsonObject(PROVIDER_SETTINGS);
        if (bag == null || bag == JsonValue.NULL) {
            LOGGER.finest("No supplied AdminServerConnection settings!");
            return;
        }
        JsonValue insecure = (JsonValue)bag.get((Object)PROVIDER_INSECURE);
        if (insecure != null && insecure != JsonValue.NULL && bag.getBoolean(PROVIDER_INSECURE)) {
            provider.setInsecureConnection(true);
        }
        if ((proxyOverride = (JsonValue)bag.get((Object)PROXY_OVERRIDE)) != null && proxyOverride != JsonValue.NULL) {
            provider.setProxyOverride(bag.getString(PROXY_OVERRIDE));
        }
    }

    private static Response submitWDTModelDataProviderInfo(ProviderManager pm, String name, String label, ResourceContext resourceContext, JsonObject data) {
        Response response;
        JsonString jmodel;
        ArrayList<String> propLists = null;
        JsonArray jprops = data.getJsonArray(PROPERTY_LISTS);
        if (jprops != null && !jprops.isEmpty()) {
            LOGGER.fine("POST specified property list providers");
            propLists = new ArrayList<String>(jprops.size());
            for (int i = 0; i < jprops.size(); ++i) {
                propLists.add(jprops.getString(i));
            }
        }
        if ((jmodel = data.getJsonString(WDT_MODEL)) == null || jmodel == JsonValue.NULL) {
            if (propLists != null && pm.hasProvider(name, "WDTModel")) {
                return ProviderResource.updateWDTModelDataProviderInfo(pm, name, resourceContext, propLists);
            }
            LOGGER.fine("POST create bad request: no model");
            return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"No Model")).build();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(jmodel.getString().getBytes());
        try {
            response = ProviderResource.submitWDTModelDataProviderInfo(pm, name, label, resourceContext, is, propLists, false);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LOGGER.fine("POST create bad request: bad model - " + ioe.toString());
                return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Bad Model").build();
            }
        }
        is.close();
        return response;
    }

    private static Response submitWDTModelDataProviderInfo(ProviderManager pm, String name, String label, ResourceContext resourceContext, InputStream modelStream, List<String> propLists, boolean isJson) {
        if (reservedNames.contains(name)) {
            LOGGER.fine("POST create reserved name: " + name);
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Reserved name").build();
        }
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        WDTModelDataProvider provider = pm.createWDTModelDataProvider(name, label);
        provider.parseModel(modelStream, isJson, ic);
        if (propLists != null) {
            provider.setPropertyListProviders(propLists, pm);
        }
        pm.save(ic);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((Response.Status)Response.Status.CREATED).entity((Object)pm.getJSON(name, ic)).type("application/json")).build();
    }

    private static Response updateWDTModelDataProviderInfo(ProviderManager pm, String name, ResourceContext resourceContext, List<String> propLists) {
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        WDTModelDataProvider provider = (WDTModelDataProvider)pm.getProvider(name, "WDTModel");
        provider.setPropertyListProviders(propLists, pm);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((Response.Status)Response.Status.OK).entity((Object)pm.getJSON(name, ic)).type("application/json")).build();
    }

    private static Response submitPropertyListDataProviderInfo(ProviderManager pm, String name, String label, ResourceContext resourceContext, JsonObject data) {
        Response response;
        JsonString properties = data.getJsonString(PROPERTIES);
        if (properties == null || properties == JsonValue.NULL) {
            LOGGER.fine("POST create bad request: no properties");
            return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"No Properties")).build();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(properties.getString().getBytes());
        try {
            response = ProviderResource.submitPropertyListDataProviderInfo(pm, name, label, resourceContext, is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LOGGER.fine("POST create bad request: bad properties - " + ioe.toString());
                return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Bad Properties").build();
            }
        }
        is.close();
        return response;
    }

    private static Response submitPropertyListDataProviderInfo(ProviderManager pm, String name, String label, ResourceContext resourceContext, InputStream propertiesStream) {
        if (reservedNames.contains(name)) {
            LOGGER.fine("POST create reserved name: " + name);
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Reserved name").build();
        }
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        pm.createPropertyListDataProvider(name, label).parse(propertiesStream, ic);
        pm.save(ic);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((Response.Status)Response.Status.CREATED).entity((Object)pm.getJSON(name, ic)).type("application/json")).build();
    }

    private static Response submitWDTCompositeDataProviderInfo(ProviderManager pm, String name, String label, ResourceContext resourceContext, JsonObject data) {
        if (reservedNames.contains(name)) {
            LOGGER.fine("POST create reserved name: " + name);
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Reserved name").build();
        }
        JsonArray jmodels = data.getJsonArray(WDT_MODELS);
        if (jmodels == null || jmodels.isEmpty()) {
            LOGGER.fine("POST create bad request");
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Missing model names").build();
        }
        ArrayList<String> models = new ArrayList<String>(jmodels.size());
        for (int i = 0; i < jmodels.size(); ++i) {
            String model = jmodels.getString(i);
            if (!pm.hasProvider(model, "WDTModel")) {
                LOGGER.fine("POST create bad request - not found: " + model);
                return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Model not found").build();
            }
            models.add(model);
        }
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        pm.createWDTCompositeDataProvider(name, label, models).checkModels(ic);
        pm.save(ic);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((Response.Status)Response.Status.CREATED).entity((Object)pm.getJSON(name, ic)).type("application/json")).build();
    }

    @DELETE
    @Path(value="/{pathSegments: .+}")
    public Response deleteProvider(@Context ResourceContext resourceContext, @PathParam(value="pathSegments") List<PathSegment> pathSegments) {
        int nameIndex = 0;
        String first = pathSegments.get(0).getPath();
        String typeConstraint = null;
        String nameConstraint = null;
        if (first.equals("AdminServerConnection") || first.equals("WDTModel") || first.equals("WDTCompositeModel") || first.equals("PropertyList")) {
            typeConstraint = first;
            ++nameIndex;
        }
        if (pathSegments.size() <= nameIndex) {
            return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Need name")).build();
        }
        nameConstraint = pathSegments.get(nameIndex).getPath();
        ProviderManager pm = ProviderManager.getFromContext(resourceContext);
        for (Provider prov : pm.getAll()) {
            if (typeConstraint != null && !prov.getType().equals(typeConstraint) || nameConstraint != null && !prov.getName().equals(nameConstraint)) continue;
            pm.deleteProvider(prov.getName());
            InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
            pm.save(ic);
            return WebAppUtils.addCookieFromContext(resourceContext, Response.ok().entity((Object)Json.createObjectBuilder().build()).type("application/json")).build();
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"No such provider")).build();
    }

    static {
        reservedNames.add("about");
        reservedNames.add("domainStatus");
        reservedNames.add("token");
        reservedNames.add("providers");
        reservedNames.add("AdminServerConnection");
        reservedNames.add("WDTModel");
        reservedNames.add("WDTCompositeModel");
        reservedNames.add("PropertyList");
    }
}

