/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.providers.PropertyListDataProvider;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.FailedRequestException;

public class PropertyListPageRepoResource
extends BaseResource {
    public static final LocalizableString PROPERTY_LIST_CONFIGURATION_LABEL = LocalizedConstants.PROPERTY_LIST_CONFIGURATION_LABEL;
    public static final LocalizableString PROPERTY_LIST_PROPERTIES = LocalizedConstants.PROPERTY_LIST_PROPERTIES;
    public static final LocalizableString PROPERTY_LIST_HELP_TEXT = LocalizedConstants.PROPERTY_LIST_HELP_TEXT;

    @GET
    @Path(value="data/{pathSegments: .+}")
    public Response getDataResource() {
        PropertyListDataProvider provider = (PropertyListDataProvider)this.getInvocationContext().getProvider();
        JsonObjectBuilder entity = Json.createObjectBuilder();
        JsonArrayBuilder empty = Json.createArrayBuilder();
        String labelProperties = this.getInvocationContext().getLocalizer().localizeString(PROPERTY_LIST_PROPERTIES, new Object[0]);
        entity.add("breadCrumbs", empty);
        entity.add("links", empty);
        entity.add("pageDescription", provider.getPageDescription());
        entity.add("navigation", "Properties");
        JsonObjectBuilder self = Json.createObjectBuilder();
        self.add("label", labelProperties);
        self.add("resourceData", provider.getResourceData());
        entity.add("self", (JsonValue)self.build());
        JsonObjectBuilder data = Json.createObjectBuilder();
        JsonObjectBuilder properties = Json.createObjectBuilder();
        properties.add("set", "true");
        JsonObjectBuilder value = Json.createObjectBuilder();
        Properties propertyList = provider.getProperties();
        for (String key : propertyList.stringPropertyNames()) {
            value.add(key, propertyList.getProperty(key));
        }
        properties.add("value", (JsonValue)value.build());
        data.add("Properties", (JsonValue)properties.build());
        entity.add("data", (JsonValue)data.build());
        return Response.ok().entity((Object)entity.build()).type("application/json").build();
    }

    @POST
    @Path(value="data/{pathSegments: .+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postDataResource(JsonObject requestBody) {
        boolean updateProperties;
        PropertyListDataProvider provider = (PropertyListDataProvider)this.getInvocationContext().getProvider();
        Properties propertyList = provider.getProperties();
        JsonString jaction = requestBody.getJsonString("action");
        boolean bl = updateProperties = jaction != null && "update".equalsIgnoreCase(jaction.getString());
        if (!updateProperties) {
            propertyList.clear();
        }
        for (Map.Entry entry : requestBody.getJsonObject("data").getJsonObject("Properties").getJsonObject("value").entrySet()) {
            String value = ((JsonValue)entry.getValue()).toString();
            value = value.substring(1, value.length() - 1);
            propertyList.put(entry.getKey(), value);
        }
        return Response.ok().entity((Object)Json.createObjectBuilder().build()).build();
    }

    @GET
    @Path(value="pages/{pathSegments: .+}")
    @Produces(value={"application/json"})
    public Object getPagesResource() {
        JsonObjectBuilder entity = Json.createObjectBuilder();
        JsonObjectBuilder sliceForm = Json.createObjectBuilder();
        JsonArrayBuilder properties = Json.createArrayBuilder();
        JsonObjectBuilder property = Json.createObjectBuilder();
        String labelPropertyList = this.getInvocationContext().getLocalizer().localizeString(PROPERTY_LIST_CONFIGURATION_LABEL, new Object[0]);
        String helpText = "<p>" + this.getInvocationContext().getLocalizer().localizeString(PROPERTY_LIST_HELP_TEXT, new Object[0]) + "</p>";
        property.add("name", "Properties");
        property.add("label", labelPropertyList);
        property.add("helpSummaryHTML", helpText);
        property.add("detailedHelpHTML", helpText);
        property.add("type", "properties");
        properties.add((JsonValue)property.build());
        sliceForm.add("properties", (JsonValue)properties.build());
        entity.add("sliceForm", (JsonValue)sliceForm.build());
        return Response.ok().entity((Object)entity.build()).type("application/json").build();
    }

    @POST
    @Path(value="navtree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavTree(JsonObject requestBody) {
        JsonObjectBuilder entity = Json.createObjectBuilder();
        JsonArrayBuilder contents = Json.createArrayBuilder();
        JsonObjectBuilder collectionChild = Json.createObjectBuilder();
        String labelProperties = this.getInvocationContext().getLocalizer().localizeString(PROPERTY_LIST_PROPERTIES, new Object[0]);
        collectionChild.add("expandable", false);
        collectionChild.add("label", labelProperties);
        collectionChild.add("name", "Properties");
        collectionChild.add("type", "collectionChild");
        JsonObjectBuilder rdj = Json.createObjectBuilder();
        PropertyListDataProvider provider = (PropertyListDataProvider)this.getInvocationContext().getProvider();
        rdj.add("label", labelProperties);
        rdj.add("resourceData", provider.getResourceData());
        collectionChild.add("resourceData", rdj);
        contents.add((JsonValue)collectionChild.build());
        entity.add("contents", (JsonValue)contents.build());
        return Response.ok().entity((Object)entity.build()).type("application/json").build();
    }

    @Path(value="download")
    @GET
    @Produces(value={"application/octet-stream"})
    public Object download() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, FailedRequestException {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                PropertyListDataProvider provider = (PropertyListDataProvider)PropertyListPageRepoResource.this.getInvocationContext().getProvider();
                provider.getProperties().store(writer, null);
            }
        };
        return Response.ok((Object)stream).build();
    }
}

