/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.utils.CustomizerInvocationUtils;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.DownloadBeanRepo;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.ChangeManagerResource;
import weblogic.remoteconsole.server.webapp.CreatableBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.CreatableOptionalSingletonBeanResource;
import weblogic.remoteconsole.server.webapp.DeletableCollectionChildBeanResource;
import weblogic.remoteconsole.server.webapp.DownloadResource;
import weblogic.remoteconsole.server.webapp.EditableCollectionChildBeanResource;
import weblogic.remoteconsole.server.webapp.EditableMandatorySingletonBeanResource;
import weblogic.remoteconsole.server.webapp.EditableOptionalSingletonBeanResource;
import weblogic.remoteconsole.server.webapp.NavTreeResource;
import weblogic.remoteconsole.server.webapp.PageDescriptionsResource;
import weblogic.remoteconsole.server.webapp.ReadOnlyBeanCollectionResource;
import weblogic.remoteconsole.server.webapp.ReadOnlyCollectionChildBeanResource;
import weblogic.remoteconsole.server.webapp.ReadOnlyMandatorySingletonBeanResource;
import weblogic.remoteconsole.server.webapp.ReadOnlyOptionalSingletonBeanResource;
import weblogic.remoteconsole.server.webapp.SearchResource;
import weblogic.remoteconsole.server.webapp.SimpleSearchResource;

public class PageRepoResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(PageRepoResource.class.getName());

    protected void setBeanTreePath(List<PathSegment> pathSegments) {
        this.getInvocationContext().setIdentity(BeanTreePath.create(this.getInvocationContext().getPageRepo().getBeanRepo(), this.getPathFromPathSegments(pathSegments)));
    }

    @Path(value="data/{pathSegments: .+}")
    public Object getDataResource(@PathParam(value="pathSegments") List<PathSegment> pathSegments, @QueryParam(value="properties") String properties) {
        this.getInvocationContext().setProperties(properties);
        this.setBeanTreePath(pathSegments);
        if (this.getInvocationContext().getBeanTreePath() == null) {
            return null;
        }
        BaseResource resource = this.createCustomResource();
        if (resource == null) {
            resource = this.createStandardResource();
        }
        return this.copyContext(resource);
    }

    private BaseResource createCustomResource() {
        String methodName = this.getInvocationContext().getBeanTreePath().getTypeDef().getCreateResourceMethod();
        if (StringUtils.isEmpty((String)methodName)) {
            return null;
        }
        Method method = CustomizerInvocationUtils.getMethod(methodName);
        CustomizerInvocationUtils.checkSignature(method, BaseResource.class, new Type[]{InvocationContext.class});
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getInvocationContext());
        Object resourceAsObject = CustomizerInvocationUtils.invokeMethod(method, args);
        return (BaseResource)resourceAsObject;
    }

    private BaseResource createStandardResource() {
        BeanTreePath beanTreePath = this.getInvocationContext().getBeanTreePath();
        if (beanTreePath.isCollection()) {
            if (beanTreePath.isCreatable()) {
                return new CreatableBeanCollectionResource();
            }
            return new ReadOnlyBeanCollectionResource();
        }
        if (beanTreePath.isCollectionChild()) {
            if (beanTreePath.isDeletable()) {
                return new DeletableCollectionChildBeanResource();
            }
            if (beanTreePath.isEditable()) {
                return new EditableCollectionChildBeanResource();
            }
            return new ReadOnlyCollectionChildBeanResource();
        }
        if (beanTreePath.isOptionalSingleton()) {
            if (beanTreePath.isCreatable()) {
                return new CreatableOptionalSingletonBeanResource();
            }
            if (beanTreePath.isEditable()) {
                return new EditableOptionalSingletonBeanResource();
            }
            return new ReadOnlyOptionalSingletonBeanResource();
        }
        if (beanTreePath.isMandatorySingleton()) {
            if (beanTreePath.isEditable()) {
                return new EditableMandatorySingletonBeanResource();
            }
            return new ReadOnlyMandatorySingletonBeanResource();
        }
        throw new AssertionError((Object)("Not a collection, optional singleton or mandatory singleton: " + String.valueOf(beanTreePath)));
    }

    @Path(value="pages")
    public Object getPagesResource() {
        return this.copyContext(new PageDescriptionsResource());
    }

    @Path(value="navtree")
    public Object getNavTreeResource() {
        return this.copyContext(new NavTreeResource());
    }

    @Path(value="search")
    public Object getSearchResource() {
        return this.copyContext(new SearchResource());
    }

    @Path(value="simpleSearch")
    public Object getSimpleSearchResource() {
        return this.copyContext(new SimpleSearchResource());
    }

    @Path(value="changeManager")
    public Object getChangeManagerResource() {
        if (!this.getInvocationContext().getPageRepo().supportsChangeManager()) {
            LOGGER.info("BAD REQUEST: tried to get a change manager for a repo without one");
            throw new WebApplicationException(Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)"There is no change manager support for this type of repository").build());
        }
        return this.copyContext(new ChangeManagerResource());
    }

    @Path(value="download")
    public Object getDownloadResource() {
        BeanRepo beanRepo = this.getInvocationContext().getPageRepo().getBeanRepo();
        if (!(beanRepo instanceof DownloadBeanRepo)) {
            LOGGER.info("BAD REQUEST: BeanRepo does not support download");
            throw new WebApplicationException(Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)"There is no download support for this type of repository").build());
        }
        return this.copyContext(new DownloadResource());
    }
}

