/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.repodef.PageRepoDef;
import weblogic.remoteconsole.common.repodef.PagesPath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageDescription;
import weblogic.remoteconsole.server.repo.PageRepo;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.GetPageDescResponseMapper;

public class PageDescriptionsResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(PageDescriptionsResource.class.getName());

    @GET
    @javax.ws.rs.Path(value="{typeName}")
    @Produces(value={"application/json"})
    public Response getPageDescription(@PathParam(value="typeName") String typeName, @QueryParam(value="view") @DefaultValue(value="") String view, @QueryParam(value="actionForm") @DefaultValue(value="") String actionForm, @QueryParam(value="action") @DefaultValue(value="") String action) {
        LOGGER.fine("getPageDescription typeName=" + StringUtils.cleanStringForLogging((Object)typeName) + " view=" + StringUtils.cleanStringForLogging((Object)view) + " actionForm=" + StringUtils.cleanStringForLogging((Object)actionForm) + " action=" + StringUtils.cleanStringForLogging((Object)action));
        return GetPageDescResponseMapper.toResponse(this.getInvocationContext(), this.getResponse(typeName, view, actionForm, action));
    }

    private weblogic.remoteconsole.server.repo.Response<JsonObject> getResponse(String typeName, String view, String actionForm, String action) {
        InvocationContext ic = this.getInvocationContext();
        weblogic.remoteconsole.server.repo.Response<JsonObject> response = new weblogic.remoteconsole.server.repo.Response<JsonObject>();
        PageRepo pageRepo = ic.getPageRepo();
        PagePath pagePath = this.computePagePath(typeName, view, actionForm, action);
        if (pagePath == null) {
            return response.setNotFound();
        }
        ic.setPagePath(pagePath);
        weblogic.remoteconsole.server.repo.Response<PageDef> pageDefResponse = pageRepo.asPageReaderRepo().getPageDef(ic);
        if (!pageDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pageDefResponse);
        }
        PageDef pageDef = pageDefResponse.getResults();
        JsonObject pageDesc = PageDescription.getPageDescription(pageDef, ic);
        return response.setSuccess(pageDesc);
    }

    private PagePath computePagePath(String typeName, String view, String actionForm, String action) {
        PagePath basePagePath = this.computeBasePagePath(typeName, view);
        if (basePagePath != null && "inputForm".equals(actionForm)) {
            if (StringUtils.isEmpty((String)action)) {
                throw new AssertionError((Object)("Action must be specified for input forms: type=" + typeName + " view=" + view));
            }
            return PagePath.newActionInputFormPagePath(basePagePath, action);
        }
        return basePagePath;
    }

    private PagePath computeBasePagePath(String typeName, String view) {
        PageRepoDef pageRepoDef = this.getInvocationContext().getPageRepo().getPageRepoDef();
        BeanTypeDef typeDef = pageRepoDef.getBeanRepoDef().getTypeDef(typeName);
        if (typeDef == null) {
            return null;
        }
        PagesPath pagesPath = new PagesPath(pageRepoDef, typeDef);
        if ("table".equals(view)) {
            return PagePath.newTablePagePath(pagesPath);
        }
        if ("createForm".equals(view)) {
            return PagePath.newCreateFormPagePath(pagesPath);
        }
        String slicePath = view;
        return PagePath.newSlicePagePath(pagesPath, new Path(slicePath));
    }
}

