/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.server.repo.NavTreeNode;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.BaseResource;
import weblogic.remoteconsole.server.webapp.NavTreeNodeRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.NavTreeNodeResponseMapper;

public class NavTreeResource
extends BaseResource {
    private static final Logger LOGGER = Logger.getLogger(NavTreeResource.class.getName());

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public javax.ws.rs.core.Response expandNavTreeNodes(JsonObject requestBody) {
        LOGGER.fine("expandNavTreeNodes" + StringUtils.cleanStringForLogging((Object)requestBody.toString()));
        return NavTreeNodeResponseMapper.toResponse(this.getInvocationContext(), this.getResponse(requestBody));
    }

    private Response<List<NavTreeNode>> getResponse(JsonObject requestBody) {
        Response<List<NavTreeNode>> response = NavTreeNodeRequestBodyMapper.fromRequestBody(this.getInvocationContext(), requestBody);
        if (!response.isSuccess()) {
            return response;
        }
        return this.getInvocationContext().getPageRepo().asPageReaderRepo().expandNavTreeNodes(this.getInvocationContext(), response.getResults());
    }
}

