/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.NavTreeNode;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.ResponseMapper;

public class NavTreeNodeResponseMapper
extends ResponseMapper<List<NavTreeNode>> {
    public static javax.ws.rs.core.Response toResponse(InvocationContext invocationContext, Response<List<NavTreeNode>> response) {
        return new NavTreeNodeResponseMapper(invocationContext, response).toResponse();
    }

    private NavTreeNodeResponseMapper(InvocationContext invocationContext, Response<List<NavTreeNode>> response) {
        super(invocationContext, response);
    }

    @Override
    protected void addResults() {
        this.getEntityBuilder().add("contents", (JsonValue)this.navTreeNodesToJson((List)this.getResponse().getResults()));
    }

    private JsonArray navTreeNodesToJson(List<NavTreeNode> nodes) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (NavTreeNode node : nodes) {
            if (node.getResourceData() != null && !this.getInvocationContext().getProvider().isValidPath(node.getResourceData().getPath().getDotSeparatedPath())) continue;
            builder.add((JsonValue)this.navTreeNodeToJson(node));
        }
        return builder.build();
    }

    private JsonObject navTreeNodeToJson(NavTreeNode node) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addIfNotEmpty(builder, "name", node.getName());
        this.addIfNotEmpty(builder, "label", node.getLabel());
        this.addIfNotFalse(builder, "expanded", node.isExpanded());
        this.addIfNotTrue(builder, "expandable", node.isExpandable());
        this.addIfNotTrue(builder, "selectable", node.isSelectable());
        this.addIfNotEmpty(builder, "type", this.getType(node));
        this.addIfNotEmpty(builder, "contents", this.navTreeNodesToJson(node.getContents()));
        if (node.getType() != NavTreeNode.Type.GROUP) {
            builder.add("resourceData", this.beanTreePathToJson(node.getResourceData()));
        }
        return builder.build();
    }

    private String getType(NavTreeNode node) {
        NavTreeNode.Type type = node.getType();
        if (NavTreeNode.Type.GROUP == type) {
            return "group";
        }
        if (NavTreeNode.Type.ROOT == type) {
            return "root";
        }
        if (NavTreeNode.Type.COLLECTION == type) {
            return "collection";
        }
        if (NavTreeNode.Type.COLLECTION_CHILD == type) {
            return "collectionChild";
        }
        if (NavTreeNode.Type.SINGLETON == type) {
            return "singleton";
        }
        throw new AssertionError((Object)("Unknown NavTreeNode.Type " + String.valueOf((Object)type)));
    }

    private void addIfNotEmpty(JsonObjectBuilder builder, String key, String val) {
        if (StringUtils.notEmpty((String)val)) {
            builder.add(key, val);
        }
    }

    private void addIfNotEmpty(JsonObjectBuilder builder, String key, JsonArray val) {
        if (!val.isEmpty()) {
            builder.add(key, (JsonValue)val);
        }
    }

    private void addIfNotTrue(JsonObjectBuilder builder, String key, boolean val) {
        if (!val) {
            builder.add(key, val);
        }
    }

    private void addIfNotFalse(JsonObjectBuilder builder, String key, boolean val) {
        if (val) {
            builder.add(key, val);
        }
    }
}

