/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.NavTreeNode;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.RequestBodyMapper;

public class NavTreeNodeRequestBodyMapper
extends RequestBodyMapper<List<NavTreeNode>> {
    public static Response<List<NavTreeNode>> fromRequestBody(InvocationContext ic, JsonObject requestBody) {
        return new NavTreeNodeRequestBodyMapper(ic, requestBody).fromRequestBody();
    }

    private NavTreeNodeRequestBodyMapper(InvocationContext ic, JsonObject requestBody) {
        super(ic, requestBody, null);
    }

    @Override
    protected void parseRequestBody() {
        List<NavTreeNode> nodes = this.getNavTreeNodes(this.getRequestBody());
        if (this.isOK()) {
            this.getResponse().setSuccess(nodes);
        }
    }

    private List<NavTreeNode> getNavTreeNodes(JsonObject object) {
        ArrayList<NavTreeNode> nodes = new ArrayList<NavTreeNode>();
        JsonArray array = this.getOptionalJsonArray(object, "contents");
        if (this.isOK() && array != null) {
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = this.asJsonObject("contents", (JsonValue)array.get(i));
                if (!this.isOK()) continue;
                NavTreeNode node = this.getNavTreeNode(obj);
                nodes.add(node);
            }
        }
        return nodes;
    }

    private NavTreeNode getNavTreeNode(JsonObject object) {
        NavTreeNode node = new NavTreeNode();
        node.setName(this.getRequiredString(object, "name"));
        node.setExpanded(this.getOptionalBoolean(object, "expanded"));
        node.setContents(this.getNavTreeNodes(object));
        return node;
    }
}

