/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.customizers.JMSMessageManagementRuntimeMBeanCustomizer;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.FormRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.VoidResponseMapper;

public class JMSMessageManagementRuntimeMBeanUpdateHelper {
    private JMSMessageManagementRuntimeMBeanUpdateHelper() {
    }

    public static javax.ws.rs.core.Response update(InvocationContext ic, JsonObject requestBody) {
        Response<Void> response = new Response<Void>();
        Response<InvocationContext> icResponse = ic.getPageRepo().asPageReaderRepo().getActualSliceInvocationContext(ic);
        if (!icResponse.isSuccess()) {
            response.copyUnsuccessfulResponse(icResponse);
            return VoidResponseMapper.toResponse(ic, response);
        }
        InvocationContext actualIc = icResponse.getResults();
        if (!JMSMessageManagementRuntimeMBeanUpdateHelper.isMessageFiltersSlice(actualIc)) {
            return javax.ws.rs.core.Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        response = JMSMessageManagementRuntimeMBeanUpdateHelper.doUpdate(actualIc, requestBody);
        return VoidResponseMapper.toResponse(actualIc, response);
    }

    private static boolean isMessageFiltersSlice(InvocationContext ic) {
        Path path;
        return ic.getPagePath().isSlicePagePath() && ((path = ic.getPagePath().asSlicePagePath().getSlicePath()).equals((Object)new Path("Messages.Criteria")) || path.equals((Object)new Path("Messages.Filters")));
    }

    private static Response<Void> doUpdate(InvocationContext ic, JsonObject requestBody) {
        Response response = new Response();
        Response<List<FormProperty>> unmarshalResponse = FormRequestBodyMapper.fromRequestBody(ic, requestBody);
        if (!unmarshalResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(unmarshalResponse);
        }
        return JMSMessageManagementRuntimeMBeanCustomizer.updateMessageFilters(ic, unmarshalResponse.getResults());
    }
}

