/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.InvokeActionHelper;
import weblogic.remoteconsole.server.webapp.SliceTableActionRequestBodyMapper;

public class JMSMessageManagementRuntimeMBeanInvokeActionHelper
extends InvokeActionHelper {
    private static Map<String, String> SELECTED_MESSAGES_ACTIONS = Map.of("deleteSelectedMessages", "deleteMessages", "exportSelectedMessages", "exportMessages", "moveSelectedMessages", "moveMessages");

    private JMSMessageManagementRuntimeMBeanInvokeActionHelper(InvocationContext ic, String action, JsonObject requestBody) {
        super(ic, action, requestBody);
    }

    public static javax.ws.rs.core.Response invokeMessagesAction(InvocationContext ic, String action, JsonObject requestBody) {
        return new JMSMessageManagementRuntimeMBeanInvokeActionHelper(ic, action, requestBody).invokeAction();
    }

    @Override
    protected Response<Void> invokeSliceTableRowsAction() {
        String actionName = this.getPageActionDef().getActionName();
        if ("viewMessage".equals(actionName)) {
            return new Response<Object>().setSuccess(null);
        }
        if (SELECTED_MESSAGES_ACTIONS.containsKey(actionName)) {
            return this.invokeSelectedMessagesAction();
        }
        return super.invokeSliceTableRowsAction();
    }

    private Response<Void> invokeSelectedMessagesAction() {
        Response response = new Response();
        String selectorActionName = SELECTED_MESSAGES_ACTIONS.get(this.getPageActionDef().getActionName());
        Response<String> r = this.createSelectorForRows();
        if (r == null) {
            return response.setSuccess(null);
        }
        if (!r.isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        String selector = r.getResults();
        JsonObject selectorActionRequestBody = this.createSelectorActionRequestBody(selector);
        JMSMessageManagementRuntimeMBeanInvokeActionHelper selectorActionHelper = new JMSMessageManagementRuntimeMBeanInvokeActionHelper(this.getInvocationContext(), selectorActionName, this.createSelectorActionRequestBody(selector));
        return selectorActionHelper.invokeActionReturnResponse();
    }

    private Response<String> createSelectorForRows() {
        Response<String> response = new Response<String>();
        Response<List<String>> r = SliceTableActionRequestBodyMapper.fromRequestBody(this.getInvocationContext(), this.getRequestBody());
        if (!r.isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        List<String> identities = r.getResults();
        if (identities.isEmpty()) {
            return null;
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String identity : identities) {
            if (!first) {
                sb.append(" OR ");
            }
            first = false;
            String selectorValue = StringUtils.nonNull((String)identity).replaceAll("'", "''");
            sb.append("( JMSMessageID = '" + selectorValue + "' )");
        }
        return response.setSuccess(sb.toString());
    }

    private JsonObject createSelectorActionRequestBody(String selector) {
        return Json.createObjectBuilder().add("data", Json.createObjectBuilder((JsonObject)this.getRequestBody().getJsonObject("data")).add("selector", Json.createObjectBuilder().add("value", selector))).build();
    }
}

