/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import java.util.Map;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.customizers.JDBCSystemResourceMBeanCustomizerUtils;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.UpdateHelper;

public class JDBCSystemResourceMBeanUpdateHelper
extends UpdateHelper {
    private static final String PROP_DRIVER_NAME = "JDBCResource.JDBCDriverParams.DriverName";
    private static final String PROP_GLOBAL_TRANSACTIONS_PROTOCOL = "JDBCResource.JDBCDataSourceParams.GlobalTransactionsProtocol";

    @Override
    protected Response<Void> updateUnderlyingBeans(InvocationContext ic, List<FormProperty> properties) {
        Response<Void> response = super.updateUnderlyingBeans(ic, properties);
        if (response.isSuccess()) {
            this.validateTransactionConfiguration(ic, response);
        }
        return response;
    }

    private void validateTransactionConfiguration(InvocationContext ic, Response<Void> updateResponse) {
        Map<String, Value> propToValue;
        String driverName;
        Boolean isXA;
        Response<Map<String, Value>> getResponse = ic.getPageRepo().getBeanRepo().asBeanReaderRepo().getBeanProperties(ic, List.of(PROP_DRIVER_NAME, PROP_GLOBAL_TRANSACTIONS_PROTOCOL), false);
        if (getResponse.isSuccess() && (isXA = JDBCSystemResourceMBeanCustomizerUtils.isXADriver(driverName = (propToValue = getResponse.getResults()).get(PROP_DRIVER_NAME).asString().getValue())) != null) {
            String protocol = propToValue.get(PROP_GLOBAL_TRANSACTIONS_PROTOCOL).asString().getValue();
            boolean isTwoPhaseCommit = "TwoPhaseCommit".equals(protocol);
            if (isXA.booleanValue() && !isTwoPhaseCommit) {
                updateResponse.addSuccessMessage(ic.getLocalizer().localizeString(LocalizedConstants.JDBC_XA_DRIVER_INCOMPATIBLE_GLOBAL_TRANSACTIONS_PROTOCOL, new Object[0]));
            } else if (!isXA.booleanValue() && isTwoPhaseCommit) {
                updateResponse.addSuccessMessage(ic.getLocalizer().localizeString(LocalizedConstants.JDBC_NON_XA_DRIVER_INCOMPATIBLE_GLOBAL_TRANSACTIONS_PROTOCOL, new Object[0]));
            }
        }
    }
}

