/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.ActionInputFormPagePath;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.webapp.FormRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.GetPageResponseMapper;
import weblogic.remoteconsole.server.webapp.SliceTableActionRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.TableActionRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.VoidResponseMapper;

public class InvokeActionHelper {
    private InvocationContext ic;
    private String action;
    private JsonObject requestBody;
    private PageActionDef pageActionDef;
    private List<FormProperty> formProperties;
    private FormDataMultiPart parts;

    public InvokeActionHelper(InvocationContext ic, String action, JsonObject requestBody) {
        this(ic, action, requestBody, null);
    }

    public InvokeActionHelper(InvocationContext ic, String action, JsonObject requestBody, FormDataMultiPart parts) {
        this.ic = ic;
        this.action = action;
        this.requestBody = requestBody;
        this.parts = parts;
    }

    protected InvocationContext getInvocationContext() {
        return this.ic;
    }

    protected String getAction() {
        return this.action;
    }

    protected JsonObject getRequestBody() {
        return this.requestBody;
    }

    protected FormDataMultiPart getParts() {
        return this.parts;
    }

    protected PageActionDef getPageActionDef() {
        return this.pageActionDef;
    }

    protected List<FormProperty> getFormProperties() {
        return this.formProperties;
    }

    public static Response invokeAction(InvocationContext ic, String action, JsonObject requestBody) {
        return new InvokeActionHelper(ic, action, requestBody).invokeAction();
    }

    public static Response invokeAction(InvocationContext ic, String action, JsonObject requestBody, FormDataMultiPart parts) {
        return new InvokeActionHelper(ic, action, requestBody, parts).invokeAction();
    }

    public Response invokeAction() {
        return VoidResponseMapper.toResponse(this.ic, this.invokeActionReturnResponse());
    }

    public weblogic.remoteconsole.server.repo.Response<Void> invokeActionReturnResponse() {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<Object> r = this.verifyExists();
        if (!r.isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        if (this.ic.getPagePath().isSlicePagePath()) {
            r = this.ic.getPageRepo().asPageReaderRepo().getActualSliceInvocationContext(this.ic);
            if (!r.isSuccess()) {
                return response.copyUnsuccessfulResponse(r);
            }
            this.ic = (InvocationContext)r.getResults();
        }
        if (!(r = this.findPageActionDef()).isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        this.pageActionDef = (PageActionDef)r.getResults();
        r = this.unmarshalInputForm();
        if (!r.isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        this.formProperties = (List)r.getResults();
        return this.invokePageAction();
    }

    private weblogic.remoteconsole.server.repo.Response<Void> invokePageAction() {
        if (!"none".equals(this.getPageActionDef().getRows())) {
            if (this.ic.getBeanTreePath().isCollection()) {
                return this.invokeTableRowsAction();
            }
            if (this.getPageActionDef().getPageDef().isSliceTableDef()) {
                if (this.getPageActionDef().getPageDef().asSliceTableDef().isUseRowIdentities()) {
                    return this.invokeTableRowsAction();
                }
                return this.invokeSliceTableRowsAction();
            }
        }
        return this.invokeBeanAction(this.getInvocationContext());
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> invokeTableRowsAction() {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<List<BeanTreePath>> rbResponse = TableActionRequestBodyMapper.fromRequestBody(this.getInvocationContext(), this.getRequestBody());
        if (!rbResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(rbResponse);
        }
        return this.invokeTableRowsAction(rbResponse.getResults());
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> invokeTableRowsAction(List<BeanTreePath> rowBTPs) {
        ArrayList<weblogic.remoteconsole.server.repo.Response<Void>> rowResponses = new ArrayList<weblogic.remoteconsole.server.repo.Response<Void>>();
        for (BeanTreePath rowBTP : rowBTPs) {
            rowResponses.add(this.invokeBeanAction(this.getTableRowIC(rowBTP)));
        }
        return this.aggregateRowResponses(rowResponses);
    }

    protected InvocationContext getTableRowIC(BeanTreePath rowBTP) {
        InvocationContext rowIC = new InvocationContext(this.getInvocationContext());
        rowIC.setIdentity(rowBTP);
        rowIC.setIdentifier(null);
        return rowIC;
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> invokeSliceTableRowsAction() {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<List<String>> rbResponse = SliceTableActionRequestBodyMapper.fromRequestBody(this.getInvocationContext(), this.getRequestBody());
        if (!rbResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(rbResponse);
        }
        ArrayList<weblogic.remoteconsole.server.repo.Response<Void>> rowResponses = new ArrayList<weblogic.remoteconsole.server.repo.Response<Void>>();
        for (String rowIdentifier : rbResponse.getResults()) {
            rowResponses.add(this.invokeBeanAction(this.getSliceTableRowIC(rowIdentifier)));
        }
        return this.aggregateRowResponses(rowResponses);
    }

    protected InvocationContext getSliceTableRowIC(String rowIdentifier) {
        InvocationContext rowIC = new InvocationContext(this.getInvocationContext());
        rowIC.setIdentifier(rowIdentifier);
        return rowIC;
    }

    private weblogic.remoteconsole.server.repo.Response<Void> aggregateRowResponses(List<weblogic.remoteconsole.server.repo.Response<Void>> rowResponses) {
        weblogic.remoteconsole.server.repo.Response<Void> response = new weblogic.remoteconsole.server.repo.Response<Void>();
        weblogic.remoteconsole.server.repo.Response successesResponse = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response failuresResponse = new weblogic.remoteconsole.server.repo.Response();
        boolean someRowsSucceeded = false;
        for (weblogic.remoteconsole.server.repo.Response<Void> rowResponse : rowResponses) {
            if (rowResponse.isSuccess()) {
                successesResponse.copyMessages(rowResponse);
                someRowsSucceeded = true;
                response.setSuccess(null);
                continue;
            }
            failuresResponse.copyMessages(rowResponse);
            if (someRowsSucceeded) continue;
            if (response.isSuccess()) {
                response.copyStatus(rowResponse);
                continue;
            }
            response.setUserBadRequest();
        }
        response.copyMessages(failuresResponse);
        response.copyMessages(successesResponse);
        return response;
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> invokeBeanAction(InvocationContext beanIC) {
        return beanIC.getPageRepo().asPageReaderRepo().invokeAction(beanIC, this.getPageActionDef(), this.getFormProperties());
    }

    public static Response getActionInputForm(InvocationContext ic, String action, JsonObject requestBody) {
        return new InvokeActionHelper(ic, action, requestBody).getActionInputForm();
    }

    public Response getActionInputForm() {
        weblogic.remoteconsole.server.repo.Response<InvocationContext> icResponse = this.getActionInputFormIC();
        if (!icResponse.isSuccess()) {
            weblogic.remoteconsole.server.repo.Response<Void> response = new weblogic.remoteconsole.server.repo.Response<Void>();
            response.copyUnsuccessfulResponse(icResponse);
            return VoidResponseMapper.toResponse(this.getInvocationContext(), response);
        }
        InvocationContext aifIC = icResponse.getResults();
        return GetPageResponseMapper.toResponse(aifIC, this.getActionInputFormReturnResponse());
    }

    private weblogic.remoteconsole.server.repo.Response<Page> getActionInputFormReturnResponse() {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<Object> r = this.verifyExists();
        if (!r.isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        if (this.ic.getPagePath().isSlicePagePath()) {
            r = this.ic.getPageRepo().asPageReaderRepo().getActualSliceInvocationContext(this.ic);
            if (!r.isSuccess()) {
                return response.copyUnsuccessfulResponse(r);
            }
            this.ic = (InvocationContext)r.getResults();
        }
        if (!(r = this.findPageActionDef()).isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        this.pageActionDef = (PageActionDef)r.getResults();
        if ("none".equals(this.getPageActionDef().getRows())) {
            return this.getActionInputFormFromIC();
        }
        if (this.getInvocationContext().getBeanTreePath().isCollection()) {
            return this.getTableRowsActionInputForm();
        }
        if (this.getPageActionDef().getPageDef().isSliceTableDef()) {
            if (this.getPageActionDef().getPageDef().asSliceTableDef().isUseRowIdentities()) {
                return this.getTableRowsActionInputForm();
            }
            return this.getSliceTableRowsActionInputForm();
        }
        return this.getBeanActionInputForm();
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> verifyExists() {
        return this.getInvocationContext().getPageRepo().asPageReaderRepo().verifyExists(this.getInvocationContext(), this.getInvocationContext().getBeanTreePath());
    }

    private weblogic.remoteconsole.server.repo.Response<Page> getTableRowsActionInputForm() {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<List<BeanTreePath>> rbResponse = TableActionRequestBodyMapper.fromRequestBody(this.getInvocationContext(), this.getRequestBody());
        if (!rbResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(rbResponse);
        }
        this.getInvocationContext().setIdentities(rbResponse.getResults());
        return this.getActionInputFormFromIC();
    }

    protected weblogic.remoteconsole.server.repo.Response<Page> getSliceTableRowsActionInputForm() {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<List<String>> rbResponse = SliceTableActionRequestBodyMapper.fromRequestBody(this.getInvocationContext(), this.getRequestBody());
        if (!rbResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(rbResponse);
        }
        this.getInvocationContext().setIdentifiers(rbResponse.getResults());
        return this.getActionInputFormFromIC();
    }

    protected weblogic.remoteconsole.server.repo.Response<Page> getBeanActionInputForm() {
        return this.getActionInputFormFromIC();
    }

    protected weblogic.remoteconsole.server.repo.Response<Page> getActionInputFormFromIC() {
        weblogic.remoteconsole.server.repo.Response<Page> response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<InvocationContext> icResponse = this.getActionInputFormIC();
        if (!icResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(icResponse);
        }
        InvocationContext aifIC = icResponse.getResults();
        response = aifIC.getPageRepo().asPageReaderRepo().getPage(aifIC);
        return response;
    }

    protected weblogic.remoteconsole.server.repo.Response<InvocationContext> getActionInputFormIC() {
        weblogic.remoteconsole.server.repo.Response<InvocationContext> response = new weblogic.remoteconsole.server.repo.Response<InvocationContext>();
        InvocationContext inputFormIC = new InvocationContext(this.ic);
        inputFormIC.setPagePath(PagePath.newActionInputFormPagePath(this.ic.getPagePath(), this.action));
        return response.setSuccess(inputFormIC);
    }

    private weblogic.remoteconsole.server.repo.Response<PageActionDef> findPageActionDef() {
        weblogic.remoteconsole.server.repo.Response<PageActionDef> response = new weblogic.remoteconsole.server.repo.Response<PageActionDef>();
        if (StringUtils.isEmpty((String)this.action)) {
            response.addFailureMessage("Action not specified");
            response.setFrontEndBadRequest();
            return response;
        }
        weblogic.remoteconsole.server.repo.Response<List<PageActionDef>> actionsResponse = this.getPageActionDefs();
        if (!actionsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(actionsResponse);
        }
        PageActionDef pageActionDef = this.findPageActionDef(actionsResponse.getResults());
        if (pageActionDef != null) {
            response.setSuccess(pageActionDef);
        } else {
            response.addFailureMessage("Action not found: " + this.getAction());
            response.setFrontEndBadRequest();
        }
        return response;
    }

    private PageActionDef findPageActionDef(List<PageActionDef> pageActionDefs) {
        Path actionPath = new Path(this.getAction());
        for (PageActionDef pageActionDef : pageActionDefs) {
            if (pageActionDef.isInvokable()) {
                if (!actionPath.equals((Object)pageActionDef.getActionPath())) continue;
                return pageActionDef;
            }
            PageActionDef childPageActionDef = this.findPageActionDef(pageActionDef.getActionDefs());
            if (childPageActionDef == null) continue;
            return childPageActionDef;
        }
        return null;
    }

    private weblogic.remoteconsole.server.repo.Response<List<PageActionDef>> getPageActionDefs() {
        weblogic.remoteconsole.server.repo.Response<List<PageActionDef>> response = new weblogic.remoteconsole.server.repo.Response<List<PageActionDef>>();
        weblogic.remoteconsole.server.repo.Response<PageDef> pageDefResponse = this.ic.getPageRepo().asPageReaderRepo().getPageDef(this.getInvocationContext());
        if (!pageDefResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pageDefResponse);
        }
        return response.setSuccess(pageDefResponse.getResults().getActionDefs());
    }

    private weblogic.remoteconsole.server.repo.Response<List<FormProperty>> unmarshalInputForm() {
        ActionInputFormDef inputFormDef = this.pageActionDef.getInputFormDef();
        if (inputFormDef == null) {
            return new weblogic.remoteconsole.server.repo.Response().setSuccess(List.of());
        }
        ActionInputFormPagePath aifpp = PagePath.newActionInputFormPagePath(this.getInvocationContext().getPagePath(), this.pageActionDef.getActionName());
        InvocationContext aifIC = new InvocationContext(this.getInvocationContext());
        aifIC.setPagePath(aifpp);
        JsonObject inputFormRequestBody = Json.createObjectBuilder((JsonObject)this.getRequestBody()).remove("rows").build();
        return FormRequestBodyMapper.fromRequestBody(aifIC, inputFormRequestBody, this.getParts());
    }
}

