/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.ActionInputFormDef;
import weblogic.remoteconsole.common.repodef.ActionInputFormPagePath;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.common.repodef.PageActionDef;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.FilteringDashboardDefManager;
import weblogic.remoteconsole.server.repo.Form;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Link;
import weblogic.remoteconsole.server.repo.ModelTokens;
import weblogic.remoteconsole.server.repo.Option;
import weblogic.remoteconsole.server.repo.OptionsSource;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.PageDescription;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.Table;
import weblogic.remoteconsole.server.repo.TableCell;
import weblogic.remoteconsole.server.repo.TableRow;
import weblogic.remoteconsole.server.webapp.ChangeManagerStatusResponseMapper;
import weblogic.remoteconsole.server.webapp.ResponseMapper;
import weblogic.remoteconsole.server.webapp.UriUtils;

public class GetPageResponseMapper
extends ResponseMapper<Page> {
    public static Response toResponse(InvocationContext ic, weblogic.remoteconsole.server.repo.Response<Page> response) {
        return new GetPageResponseMapper(ic, response).toResponse();
    }

    private GetPageResponseMapper(InvocationContext ic, weblogic.remoteconsole.server.repo.Response<Page> response) {
        super(ic, response);
    }

    @Override
    protected void addResults() {
        if (this.getPage().isForm()) {
            this.addForm();
        }
        if (this.getPage().isTable()) {
            this.addTable();
        }
        this.addPageDescription();
    }

    private void addPageDescription() {
        if (this.getPage().getPageDef().isInstanceBasedPDJ()) {
            this.getEntityBuilder().add("inlinePageDescription", (JsonValue)PageDescription.getPageDescription(this.getPage().getPageDef(), this.getInvocationContext()));
        } else {
            this.getEntityBuilder().add("pageDescription", this.getPage().getBackendRelativePDJURI());
        }
    }

    private void addForm() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        Form form = this.getPage().asForm();
        this.addPageInfo();
        if (form.isExists()) {
            this.addModelTokens(form);
            for (FormProperty propertyValue : form.getProperties()) {
                builder.add(propertyValue.getName(), this.formPropertyValueToJson(propertyValue));
            }
            this.getEntityBuilder().add("data", builder);
        }
    }

    private JsonObjectBuilder formPropertyValueToJson(FormProperty propertyValue) {
        JsonArray jsonOptionsSources;
        List<OptionsSource> optionsSources;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addValueToJsonObject(builder, propertyValue.getValue());
        List<Option> options = propertyValue.getOptions();
        if (options != null) {
            builder.add("options", this.optionsToJson(options));
        }
        if ((optionsSources = propertyValue.getOptionsSources()) != null && !(jsonOptionsSources = this.optionsSourcesToJson(optionsSources).build()).isEmpty()) {
            builder.add("optionsSources", (JsonValue)jsonOptionsSources);
        }
        return builder;
    }

    private void addTable() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        Table table = this.getPage().asTable();
        this.addPageInfo();
        this.addDisplayedColumns(table);
        this.addCustomizeTableLink(table);
        for (TableRow tableRowValues : table.getRows()) {
            builder.add(this.tableRowToJson(tableRowValues));
        }
        String kind = this.getPage().getBeanTreePathKind();
        if (this.getInvocationContext().getBeanTreePath().isCollection()) {
            boolean deletable = "creatableCollection".equals(kind) || "deletableCollection".equals(kind);
            this.getEntityBuilder().add("deletable", deletable);
        }
        this.getEntityBuilder().add("data", builder);
    }

    private void addCustomizeTableLink(Table table) {
        Path slicePath;
        Object queryParams = "?action=customizeTable";
        PagePath pagePath = this.getInvocationContext().getPagePath();
        Path path = slicePath = pagePath.isSlicePagePath() ? pagePath.asSlicePagePath().getSlicePath() : new Path();
        if (!slicePath.isEmpty()) {
            queryParams = (String)queryParams + "&slice=" + slicePath.getDotSeparatedPath();
        }
        this.getEntityBuilder().add("tableCustomizer", this.getBackendRelativeUri(table.getSelf().getPath(), (String)queryParams));
    }

    private void addDisplayedColumns(Table table) {
        List<String> columns = table.getDisplayedColumns();
        if (!columns.isEmpty()) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (String column : columns) {
                builder.add(column);
            }
            this.getEntityBuilder().add("displayedColumns", builder);
        }
    }

    private JsonObjectBuilder tableRowToJson(TableRow tableRowValues) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        String identifier = tableRowValues.getIdentifier();
        if (!StringUtils.isEmpty((String)identifier)) {
            TableCell cellValue = new TableCell("identifier", new StringValue(identifier));
            builder.add(cellValue.getName(), this.tableCellToJson(cellValue));
        }
        for (TableCell cellValue : tableRowValues.getCells()) {
            builder.add(cellValue.getName(), this.tableCellToJson(cellValue));
        }
        return builder;
    }

    private JsonObjectBuilder tableCellToJson(TableCell cellValue) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addValueToJsonObject(builder, cellValue.getValue());
        return builder;
    }

    private void addPageInfo() {
        this.addSelf();
        this.addBreadCrumbs();
        this.addLinks();
        this.addChangeManagerStatus();
        this.addIntroductionHTML();
        this.addActions();
    }

    private void addSelf() {
        Path navigation = this.getPage().getNavTreePath();
        if (!navigation.isEmpty()) {
            this.getEntityBuilder().add("navigation", UrlUtils.pathToRelativeUri(navigation));
        }
        BeanTreePath btp = this.getPage().getSelf();
        PagePath pagePath = this.getPage().getPageDef().getPagePath();
        JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)this.beanTreePathToJson(btp, pagePath.getRDJQueryParams()).asJsonObject());
        String kind = this.getPage().getBeanTreePathKind();
        if (kind != null) {
            builder.add("kind", kind);
        }
        this.getEntityBuilder().add("self", (JsonValue)builder.build());
        if (btp.isCreatable()) {
            this.getEntityBuilder().add("createForm", this.beanTreePathToJson(btp, "?view=createForm"));
        }
        if (pagePath.isActionInputFormPagePath()) {
            ActionInputFormPagePath aifpp = pagePath.asActionInputFormPagePath();
            this.addRDJLink(this.getEntityBuilder(), btp, aifpp.getParentPagePath(), "invoker", "action=" + aifpp.getAction());
        }
        this.addCustomFilteringDashboardCreateFormLink(btp);
    }

    private void addCustomFilteringDashboardCreateFormLink(BeanTreePath btp) {
        if (!FilteringDashboardDefManager.isSupportsFilteringDashboards(this.getInvocationContext(), btp)) {
            return;
        }
        String queryParams = this.computeCustomFilteringDashboardCreateFormQueryParams(btp);
        String tree = btp.getSegments().get(0).getChildDef().getChildName();
        Path dashboardsPath = new Path(tree).childPath("Dashboards");
        BeanTreePath dashboardsBtp = BeanTreePath.create(btp.getBeanRepo(), dashboardsPath);
        this.getEntityBuilder().add("dashboardCreateForm", this.beanTreePathToJson(dashboardsBtp, this.getInvocationContext().getLocalizer().localizeString(LocalizedConstants.NEW_CUSTOM_FILTERING_DASHBOARD_LABEL, new Object[0]), queryParams));
    }

    private String computeCustomFilteringDashboardCreateFormQueryParams(BeanTreePath btp) {
        return "?view=createForm&" + FilteringDashboardDefManager.computePathQueryParam(btp);
    }

    private void addBreadCrumbs() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (BeanTreePath breadCrumb : this.getPage().getBreadCrumbs()) {
            builder.add(this.valueToJson(breadCrumb));
        }
        this.getEntityBuilder().add("breadCrumbs", builder);
    }

    private void addLinks() {
        JsonArrayBuilder linksBuilder = Json.createArrayBuilder();
        for (Link link : this.getPage().getLinks()) {
            JsonObjectBuilder linkBuilder = Json.createObjectBuilder().add("label", link.getLabel()).add("resourceData", UriUtils.getBackendRelativeUri(this.getInvocationContext(), link.getResourceData()));
            String nfm = link.getNotFoundMessage();
            if (StringUtils.notEmpty((String)nfm)) {
                linkBuilder.add("notFoundMessage", nfm);
            }
            linksBuilder.add(linkBuilder);
        }
        this.getEntityBuilder().add("links", linksBuilder);
    }

    private void addChangeManagerStatus() {
        ChangeManagerStatusResponseMapper.addChangeManagerStatus(this.getEntityBuilder(), this.getPage().getChangeManagerStatus());
    }

    private void addIntroductionHTML() {
        String localizedIntroductionHTML = this.getPage().getLocalizedIntroductionHTML();
        if (StringUtils.notEmpty((String)localizedIntroductionHTML)) {
            this.getEntityBuilder().add("introductionHTML", localizedIntroductionHTML);
        }
    }

    private void addActions() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.addActions(builder, this.getPage().getSelf(), this.getPage().getPageDef().getActionDefs());
        JsonObject actions = builder.build();
        if (!actions.isEmpty()) {
            this.getEntityBuilder().add("actions", (JsonValue)actions);
        }
    }

    private void addActions(JsonObjectBuilder builder, BeanTreePath btp, List<PageActionDef> actionDefs) {
        for (PageActionDef actionDef : actionDefs) {
            if (actionDef.isInvokable()) {
                String action = actionDef.getActionName();
                ActionInputFormDef inputForm = actionDef.getInputFormDef();
                PagePath pagePath = this.getPage().getPageDef().getPagePath();
                JsonObjectBuilder actionBuilder = Json.createObjectBuilder();
                if (inputForm != null) {
                    this.addRDJLink(actionBuilder, btp, pagePath, "inputForm", "actionForm=inputForm&action=" + action);
                } else {
                    this.addRDJLink(actionBuilder, btp, pagePath, "invoker", "action=" + action);
                }
                builder.add(action, actionBuilder);
            }
            this.addActions(builder, btp, actionDef.getActionDefs());
        }
    }

    private JsonArrayBuilder optionsToJson(List<Option> options) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Option option : options) {
            builder.add(Json.createObjectBuilder().add("label", option.getLabel()).add("value", this.valueToJson(option.getValue())));
        }
        return builder;
    }

    private JsonArrayBuilder optionsSourcesToJson(List<OptionsSource> optionsSources) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (OptionsSource optionsSource : optionsSources) {
            BeanTreePath btp = optionsSource.getBeanTreePath();
            if (btp == null || !btp.isCollection() || !btp.getLastSegment().getChildDef().isCreatable()) continue;
            builder.add(this.valueToJson(btp));
        }
        return builder;
    }

    private void addModelTokens(Form form) {
        List<OptionsSource> optionsSources;
        ModelTokens modelTokens = form.getModelTokens();
        if (modelTokens == null) {
            return;
        }
        JsonObjectBuilder modelTokensBuilder = Json.createObjectBuilder();
        List<Option> options = modelTokens.getOptions();
        if (options != null && !options.isEmpty()) {
            modelTokensBuilder.add("options", this.optionsToJson(options));
        }
        if ((optionsSources = modelTokens.getOptionsSources()) != null && !optionsSources.isEmpty()) {
            JsonArrayBuilder sourcesBuilder = Json.createArrayBuilder();
            for (OptionsSource source : optionsSources) {
                sourcesBuilder.add(Json.createObjectBuilder().add("label", source.getLabel()).add("resourceData", source.getResourceData()));
            }
            modelTokensBuilder.add("optionsSources", sourcesBuilder);
        }
        this.getEntityBuilder().add("modelTokens", modelTokensBuilder);
    }

    private void addRDJLink(JsonObjectBuilder builder, BeanTreePath btp, PagePath pagePath, String link, String extraQps) {
        String baseQps = pagePath.getRDJQueryParams();
        String separator = StringUtils.isEmpty((String)baseQps) ? "?" : "&";
        String qps = baseQps + separator + extraQps;
        builder.add(link, Json.createObjectBuilder().add("resourceData", this.getBackendRelativeUri(btp, qps)));
    }

    private Page getPage() {
        return (Page)this.getResponse().getResults();
    }
}

