/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import weblogic.remoteconsole.common.repodef.PageActionParamDef;
import weblogic.remoteconsole.common.repodef.PageDef;
import weblogic.remoteconsole.common.repodef.PageFieldDef;
import weblogic.remoteconsole.common.repodef.PagePropertyDef;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DateAsLongValue;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.EntitleNetExpressionValue;
import weblogic.remoteconsole.server.repo.FileContentsValue;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.ModelToken;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SecretValue;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.UnresolvedReference;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.RequestBodyMapper;

public class FormRequestBodyMapper
extends RequestBodyMapper<List<FormProperty>> {
    private static final String PROP_SET = "set";
    private static final String PROP_VALUE = "value";
    private static final String PROP_MODEL_TOKEN = "modelToken";
    private static final String PROP_UNRESOLVED_REFERENCE = "unresolvedReference";
    private PageDef pageDef;
    private List<PageFieldDef> fieldDefs;

    public static Response<List<FormProperty>> fromRequestBody(InvocationContext ic, JsonObject requestBody) {
        return FormRequestBodyMapper.fromRequestBody(ic, requestBody, null);
    }

    public static Response<List<FormProperty>> fromRequestBody(InvocationContext ic, JsonObject requestBody, FormDataMultiPart parts) {
        return new FormRequestBodyMapper(ic, requestBody, parts).fromRequestBody();
    }

    private FormRequestBodyMapper(InvocationContext ic, JsonObject requestBody, FormDataMultiPart parts) {
        super(ic, requestBody, parts);
        Response<PageDef> pageDefResponse = ic.getPageRepo().asPageReaderRepo().getPageDef(this.getInvocationContext());
        if (!pageDefResponse.isSuccess()) {
            this.getResponse().copyUnsuccessfulResponse(pageDefResponse);
            return;
        }
        this.pageDef = pageDefResponse.getResults();
        if (this.pageDef.isSliceFormDef()) {
            this.fieldDefs = new ArrayList<PagePropertyDef>(this.pageDef.asSliceFormDef().getAllPropertyDefs());
        } else if (this.pageDef.isCreateFormDef()) {
            this.fieldDefs = new ArrayList<PagePropertyDef>(this.pageDef.asCreateFormDef().getAllPropertyDefs());
        } else if (this.pageDef.isActionInputFormDef()) {
            this.fieldDefs = new ArrayList<PageActionParamDef>(this.pageDef.asActionInputFormDef().getParamDefs());
        } else {
            throw new AssertionError((Object)("Not a slice form or create form: " + String.valueOf(this.getInvocationContext().getPagePath())));
        }
    }

    @Override
    protected void parseRequestBody() {
        List<FormProperty> formProperties = this.getFormProperties();
        if (this.isOK()) {
            this.getResponse().setSuccess(formProperties);
        }
    }

    private List<FormProperty> getFormProperties() {
        ArrayList<FormProperty> formProperties = new ArrayList<FormProperty>();
        JsonObject propertiesJson = this.getRequiredJsonObject(this.getRequestBody(), "data");
        if (!this.isOK()) {
            return null;
        }
        for (String string : propertiesJson.keySet()) {
            FormProperty formProperty = this.getFormProperty(string, propertiesJson);
            if (!this.isOK()) {
                return null;
            }
            if (formProperty == null) continue;
            formProperties.add(formProperty);
        }
        if (this.getParts() != null) {
            for (Map.Entry entry : this.getParts().getFields().entrySet()) {
                List parts = (List)entry.getValue();
                if (parts == null || parts.isEmpty()) {
                    this.badFormat("No parts for the property " + (String)entry.getKey());
                    return null;
                }
                if (parts.size() > 1) {
                    this.badFormat("More than one part for the property " + (String)entry.getKey());
                    return null;
                }
                FormProperty formProperty = this.getFormProperty((FormDataBodyPart)parts.get(0));
                if (!this.isOK()) {
                    return null;
                }
                if (formProperty == null) continue;
                formProperties.add(formProperty);
            }
        }
        return formProperties;
    }

    private FormProperty getFormProperty(String name, JsonObject propertiesJson) {
        PageFieldDef fieldDef = this.getFieldDef(name);
        if (!this.isOK()) {
            return null;
        }
        if (this.isReadOnly(fieldDef)) {
            return null;
        }
        JsonObject propertyJson = this.getRequiredJsonObject(propertiesJson, name);
        if (!this.isOK()) {
            return null;
        }
        Value value = this.getPropertyValue(fieldDef, propertyJson);
        if (!this.isOK()) {
            return null;
        }
        if (value == null) {
            return null;
        }
        return new FormProperty(fieldDef, value);
    }

    private FormProperty getFormProperty(FormDataBodyPart part) {
        if (part == null) {
            return null;
        }
        String name = part.getFormDataContentDisposition().getName();
        if ("requestBody".equals(name)) {
            return null;
        }
        PageFieldDef fieldDef = this.getFieldDef(name);
        if (!this.isOK()) {
            return null;
        }
        if (this.isReadOnly(fieldDef)) {
            return null;
        }
        if (!fieldDef.isFileContents()) {
            this.badFormat("Property is not an uploaded file: " + name);
            return null;
        }
        FileContentsValue value = new FileContentsValue(part.getFormDataContentDisposition().getFileName(), (InputStream)part.getEntityAs(InputStream.class), part.getMediaType().getType());
        return new FormProperty(fieldDef, new SettableValue(value));
    }

    private boolean isReadOnly(PageFieldDef fieldDef) {
        if (this.pageDef.isSliceFormDef()) {
            return !fieldDef.asPagePropertyDef().isUpdateWritable();
        }
        if (this.pageDef.isCreateFormDef()) {
            return !fieldDef.asPagePropertyDef().isCreateWritable();
        }
        if (this.pageDef.isActionInputFormDef()) {
            return false;
        }
        throw new AssertionError((Object)("Unsupported form " + String.valueOf(this.pageDef) + " " + String.valueOf(fieldDef)));
    }

    private PageFieldDef getFieldDef(String name) {
        for (PageFieldDef fieldDef : this.fieldDefs) {
            if (!this.getFieldName(fieldDef).equals(name)) continue;
            return fieldDef;
        }
        this.badFormat("Unsupported field name: " + name);
        return null;
    }

    private Value getPropertyValue(PageFieldDef fieldDef, JsonObject propertyJson) {
        Value value;
        String fieldName = this.getFieldName(fieldDef);
        boolean hasValue = propertyJson.containsKey((Object)PROP_VALUE);
        boolean hasModelToken = propertyJson.containsKey((Object)PROP_MODEL_TOKEN);
        if (hasValue && hasModelToken) {
            this.badFormat(fieldName + " specifies value and modelToken");
            return null;
        }
        if (!hasValue && !hasModelToken) {
            boolean set = this.isSet(propertyJson);
            if (!this.isOK()) {
                return null;
            }
            if (set) {
                this.badFormat(fieldName + " doesn't specify value or modelToken");
                return null;
            }
            return new SettableValue(null, false);
        }
        Value value2 = value = hasValue && fieldDef.isArray() && !fieldDef.isReferenceAsReferences() ? this.getValueAsArrayValue(fieldDef, propertyJson) : this.getSingleValue(fieldDef, propertyJson);
        if (value == null) {
            return null;
        }
        return this.createSettableValue(propertyJson, value);
    }

    private Value getValueAsArrayValue(PageFieldDef fieldDef, JsonObject propertyJson) {
        JsonArray itemsJson = this.getRequiredJsonArray(propertyJson, PROP_VALUE);
        if (!this.isOK()) {
            return null;
        }
        ArrayList<Value> values = new ArrayList<Value>();
        for (int i = 0; i < itemsJson.size(); ++i) {
            JsonObject itemJson = this.asJsonObject(this.getFieldName(fieldDef), (JsonValue)itemsJson.get(i));
            if (!this.isOK()) {
                return null;
            }
            Value value = this.getSingleValue(fieldDef, itemJson);
            if (!this.isOK()) {
                return null;
            }
            values.add(value);
        }
        return new ArrayValue(values);
    }

    private Value getSingleValue(PageFieldDef fieldDef, JsonObject json) {
        String fieldName = this.getFieldName(fieldDef);
        boolean hasValue = json.containsKey((Object)PROP_VALUE);
        boolean hasModelToken = json.containsKey((Object)PROP_MODEL_TOKEN);
        if (hasValue && hasModelToken) {
            this.badFormat(fieldName + " specifies value and modelToken");
            return null;
        }
        if (!hasValue && !hasModelToken) {
            this.badFormat(fieldName + " does not specify value or modelToken");
            return null;
        }
        if (hasModelToken) {
            return this.getValueAsModelToken(fieldDef, json);
        }
        JsonValue jsonValue = this.getRequiredJsonValue(json, PROP_VALUE);
        if (!this.isOK()) {
            return null;
        }
        if (fieldDef.isString()) {
            return this.getValueAsString(fieldDef, jsonValue);
        }
        if (fieldDef.isBoolean()) {
            return this.getValueAsBoolean(fieldDef, jsonValue);
        }
        if (fieldDef.isInt()) {
            return this.getValueAsInt(fieldDef, jsonValue);
        }
        if (fieldDef.isLong()) {
            return this.getValueAsLong(fieldDef, jsonValue);
        }
        if (fieldDef.isDouble()) {
            return this.getValueAsDouble(fieldDef, jsonValue);
        }
        if (fieldDef.isSecret()) {
            return this.getValueAsSecret(fieldDef, jsonValue);
        }
        if (fieldDef.isReference()) {
            return this.getValueAsReference(fieldDef, jsonValue);
        }
        if (fieldDef.isDateAsLong()) {
            return this.getValueAsDateAsLong(fieldDef, jsonValue);
        }
        if (fieldDef.isDate()) {
            return this.getValueAsDate(fieldDef, jsonValue);
        }
        if (fieldDef.isProperties()) {
            return this.getValueAsProperties(fieldDef, jsonValue);
        }
        if (fieldDef.isEntitleNetExpression()) {
            return this.getValueAsEntitleNetExpression(fieldDef, jsonValue);
        }
        throw new AssertionError((Object)("Unsupported field type " + String.valueOf(fieldDef)));
    }

    private Value getValueAsModelToken(PageFieldDef fieldDef, JsonObject propertyJson) {
        String modelToken = this.getRequiredString(propertyJson, PROP_MODEL_TOKEN);
        if (!this.isOK()) {
            return null;
        }
        return new ModelToken(modelToken);
    }

    private Value getValueAsString(PageFieldDef fieldDef, JsonValue jsonValue) {
        String val = this.asString(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new StringValue(val);
    }

    private Value getValueAsBoolean(PageFieldDef fieldDef, JsonValue jsonValue) {
        boolean val = this.asBoolean(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new BooleanValue(val);
    }

    private Value getValueAsInt(PageFieldDef fieldDef, JsonValue jsonValue) {
        int val = this.asInt(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new IntValue(val);
    }

    private Value getValueAsLong(PageFieldDef fieldDef, JsonValue jsonValue) {
        long val = this.asLong(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new LongValue(val);
    }

    private Value getValueAsDouble(PageFieldDef fieldDef, JsonValue jsonValue) {
        double val = this.asDouble(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new DoubleValue(val);
    }

    private Value getValueAsSecret(PageFieldDef fieldDef, JsonValue jsonValue) {
        String val = this.asString(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new SecretValue(val);
    }

    private Value getValueAsReference(PageFieldDef fieldDef, JsonValue jsonValue) {
        if (jsonValue == JsonValue.NULL) {
            return NullReference.INSTANCE;
        }
        JsonObject jsonObject = this.asJsonObject(fieldDef.getFormFieldName(), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        boolean haveResolvedRef = jsonObject.containsKey((Object)"resourceData");
        boolean haveUnresolvedRef = jsonObject.containsKey((Object)PROP_UNRESOLVED_REFERENCE);
        if (haveResolvedRef && haveUnresolvedRef) {
            this.badFormat(String.valueOf(fieldDef) + " specifies both resourceData and unresolvedReference");
            return null;
        }
        if (!haveResolvedRef && !haveUnresolvedRef) {
            this.badFormat(String.valueOf(fieldDef) + " doesn't specify resourceData or unresolvedReference");
            return null;
        }
        if (haveResolvedRef) {
            return this.asBeanTreePath(fieldDef.getFormFieldName(), jsonValue);
        }
        return this.asUnresolvedReference(fieldDef, jsonValue);
    }

    private UnresolvedReference asUnresolvedReference(PageFieldDef fieldDef, JsonValue jsonValue) {
        if (!fieldDef.isPagePropertyDef()) {
            throw new AssertionError((Object)("Unresolved references not supported for " + String.valueOf(fieldDef) + " " + String.valueOf(jsonValue)));
        }
        if (!fieldDef.asPagePropertyDef().isSupportsUnresolvedReferences()) {
            this.badFormat(String.valueOf(fieldDef) + " doesn't support unresolved references");
            return null;
        }
        JsonObject jsonObject = this.asJsonObject(fieldDef.getFormFieldName(), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        String key = this.getRequiredString(jsonObject, PROP_UNRESOLVED_REFERENCE);
        if (!this.isOK()) {
            return null;
        }
        return new UnresolvedReference(key);
    }

    private Value getValueAsDate(PageFieldDef fieldDef, JsonValue jsonValue) {
        Date date = this.asDate(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new DateValue(date);
    }

    private Value getValueAsDateAsLong(PageFieldDef fieldDef, JsonValue jsonValue) {
        Date date = this.asDate(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        return new DateAsLongValue(date);
    }

    private Value getValueAsProperties(PageFieldDef fieldDef, JsonValue jsonValue) {
        JsonObject jsonObject = this.asJsonObject(this.getFieldName(fieldDef), jsonValue);
        if (!this.isOK()) {
            return null;
        }
        Properties properties = new Properties();
        for (String key : jsonObject.keySet()) {
            String value = this.getRequiredString(jsonObject, key);
            if (!this.isOK()) {
                return null;
            }
            properties.setProperty(key, value);
        }
        return new PropertiesValue(properties);
    }

    private Value getValueAsEntitleNetExpression(PageFieldDef fieldDef, JsonValue jsonValue) {
        return new EntitleNetExpressionValue(jsonValue);
    }

    private String getFieldName(PageFieldDef fieldDef) {
        return fieldDef.getFormFieldName();
    }

    private SettableValue createSettableValue(JsonObject propertyJson, Value value) {
        boolean set = this.isSet(propertyJson);
        if (!this.isOK()) {
            return null;
        }
        return new SettableValue(value, set);
    }

    private boolean isSet(JsonObject propertyJson) {
        if (propertyJson.containsKey((Object)PROP_SET)) {
            return this.getRequiredBoolean(propertyJson, PROP_SET);
        }
        return true;
    }
}

