/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.RequestBodyMapper;

public class DisplayedColumnsRequestBodyMapper
extends RequestBodyMapper<List<String>> {
    private static final String DISPLAYED_COLUMNS = "displayedColumns";

    public static Response<List<String>> fromRequestBody(InvocationContext ic, JsonObject requestBody) {
        return new DisplayedColumnsRequestBodyMapper(ic, requestBody).fromRequestBody();
    }

    private DisplayedColumnsRequestBodyMapper(InvocationContext ic, JsonObject requestBody) {
        super(ic, requestBody, null);
    }

    @Override
    protected void parseRequestBody() {
        if (this.getRequestBody() == null) {
            this.getResponse().setSuccess(null);
            return;
        }
        JsonArray arr = this.getOptionalJsonArray(this.getRequestBody(), DISPLAYED_COLUMNS);
        if (!this.isOK()) {
            return;
        }
        if (arr == null) {
            this.getResponse().setSuccess(null);
            return;
        }
        ArrayList<String> displayedColumns = new ArrayList<String>();
        for (int i = 0; this.isOK() && i < arr.size(); ++i) {
            displayedColumns.add(this.asString(DISPLAYED_COLUMNS, (JsonValue)arr.get(i)));
        }
        if (!this.isOK()) {
            return;
        }
        this.getResponse().setSuccess(displayedColumns);
    }
}

