/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.List;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfig;
import weblogic.remoteconsole.server.repo.FilteringDashboardConfigManager;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.FormRequestBodyMapper;
import weblogic.remoteconsole.server.webapp.UpdateHelper;
import weblogic.remoteconsole.server.webapp.VoidResponseMapper;

public class CustomFilteringDashboardUpdateHelper {
    private CustomFilteringDashboardUpdateHelper() {
    }

    public static javax.ws.rs.core.Response update(InvocationContext ic, JsonObject requestBody) {
        Response<Void> response = new Response<Void>();
        Response<InvocationContext> icResponse = ic.getPageRepo().asPageReaderRepo().getActualSliceInvocationContext(ic);
        if (!icResponse.isSuccess()) {
            response.copyUnsuccessfulResponse(icResponse);
            return VoidResponseMapper.toResponse(ic, response);
        }
        InvocationContext actualIc = icResponse.getResults();
        Response<Boolean> readOnlyResponse = UpdateHelper.isReadOnly(actualIc);
        if (!readOnlyResponse.isSuccess()) {
            response.copyUnsuccessfulResponse(readOnlyResponse);
        } else {
            if (readOnlyResponse.getResults().booleanValue()) {
                return javax.ws.rs.core.Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
            }
            response = CustomFilteringDashboardUpdateHelper.doUpdate(actualIc, requestBody);
        }
        return VoidResponseMapper.toResponse(actualIc, response);
    }

    private static Response<Void> doUpdate(InvocationContext ic, JsonObject requestBody) {
        Response response = new Response();
        Response<List<FormProperty>> unmarshalResponse = FormRequestBodyMapper.fromRequestBody(ic, requestBody);
        if (!unmarshalResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(unmarshalResponse);
        }
        Response<FilteringDashboardConfig> configResponse = FilteringDashboardConfigManager.updateConfig(ic, unmarshalResponse.getResults());
        if (!configResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(configResponse);
        }
        return ic.getPageRepo().asPageReaderRepo().getDashboardManager(ic).updateCustomFilteringDashboard(ic, configResponse.getResults());
    }
}

