/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.repo.BeanEditorRepo;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeansPropertyValues;
import weblogic.remoteconsole.server.repo.FormProperty;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.PageEditorRepo;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.CreateResponseMapper;
import weblogic.remoteconsole.server.webapp.FormRequestBodyMapper;

public class CreateHelper {
    protected CreateHelper() {
    }

    public static Response create(InvocationContext ic, JsonObject requestBody) {
        return new CreateHelper().createBean(ic, requestBody);
    }

    public static Response create(InvocationContext ic, JsonObject requestBody, FormDataMultiPart parts) {
        return new CreateHelper().createBean(ic, requestBody, parts);
    }

    public Response createBean(InvocationContext ic, JsonObject requestBody) {
        return this.createBean(ic, requestBody, null);
    }

    public Response createBean(InvocationContext ic, JsonObject requestBody, FormDataMultiPart parts) {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        boolean multiPart = parts != null;
        weblogic.remoteconsole.server.repo.Response<List<FormProperty>> unmarshalResponse = FormRequestBodyMapper.fromRequestBody(ic, requestBody, parts);
        if (!unmarshalResponse.isSuccess()) {
            return CreateResponseMapper.toResponse(ic, new weblogic.remoteconsole.server.repo.Response().copyUnsuccessfulResponse(unmarshalResponse));
        }
        List<FormProperty> properties = unmarshalResponse.getResults();
        return CreateResponseMapper.toResponse(ic, this.createBeanInternal(ic, properties, multiPart));
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> createBean(InvocationContext ic, List<FormProperty> properties, boolean multiPart) {
        return this.createBean(ic, properties);
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> createBean(InvocationContext ic, List<FormProperty> properties) {
        return ic.getPageRepo().asPageEditorRepo().create(ic, properties);
    }

    protected weblogic.remoteconsole.server.repo.Response<BeanTreePath> createBeanInternal(InvocationContext ic, List<FormProperty> properties, boolean multiPart) {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        weblogic.remoteconsole.server.repo.Response<BeanTreePath> pathResponse = this.computeNewBeanPath(ic, properties);
        if (!pathResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(pathResponse);
        }
        BeanTreePath newBeanPath = pathResponse.getResults();
        weblogic.remoteconsole.server.repo.Response<Void> existsResponse = ic.getPageRepo().asPageReaderRepo().verifyDoesntExist(ic, newBeanPath);
        if (!existsResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(existsResponse);
        }
        weblogic.remoteconsole.server.repo.Response<Void> createResponse = this.createBean(ic, properties, multiPart);
        if (!createResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(createResponse);
        }
        return response.copyMessages(createResponse).setSuccess(newBeanPath);
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> cloneBean(InvocationContext ic, BeanTreePath copyFromBTP, BeanTreePath copyToBTP, List<FormProperty> formProperties) {
        HashSet<Path> propertiesToIgnore = new HashSet<Path>();
        for (FormProperty formProperty : formProperties) {
            propertiesToIgnore.add(formProperty.getFieldDef().asBeanPropertyDef().getPropertyPath());
        }
        return this.cloneBean(ic, copyFromBTP, copyToBTP, propertiesToIgnore);
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> cloneBean(InvocationContext ic, BeanTreePath copyFromBTP, BeanTreePath copyToBTP, Set<Path> propertiesToIgnore) {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        InvocationContext copyFromIC = new InvocationContext(ic, copyFromBTP);
        InvocationContext copyToIC = new InvocationContext(ic, copyToBTP);
        weblogic.remoteconsole.server.repo.Response<BeansPropertyValues> getResponse = this.getPropertiesToClone(copyFromIC, copyToIC, propertiesToIgnore);
        if (!getResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(getResponse);
        }
        weblogic.remoteconsole.server.repo.Response<Void> r = this.setCloneProperties(copyToIC, getResponse.getResults());
        if (!r.isSuccess()) {
            return response.copyUnsuccessfulResponse(r);
        }
        return response.setSuccess(null);
    }

    private weblogic.remoteconsole.server.repo.Response<BeansPropertyValues> getPropertiesToClone(InvocationContext copyFromIC, InvocationContext copyToIC, Set<Path> propertiesToIgnore) {
        weblogic.remoteconsole.server.repo.Response<BeansPropertyValues> response = new weblogic.remoteconsole.server.repo.Response<BeansPropertyValues>();
        BeansPropertyValues values = new BeansPropertyValues(copyToIC.getBeanTreePath());
        BeanTreePath copyFromBTP = copyFromIC.getBeanTreePath();
        List<BeanPropertyDef> propertyDefsToClone = this.getPropertyDefsToClone(copyFromBTP, propertiesToIgnore);
        BeanReaderRepoSearchBuilder builder = this.beanEditor(copyFromIC).createSearchBuilder(copyFromIC, true);
        for (BeanPropertyDef propertyDef : propertyDefsToClone) {
            builder.addProperty(copyFromBTP, propertyDef);
        }
        weblogic.remoteconsole.server.repo.Response<BeanReaderRepoSearchResults> searchResponse = builder.search();
        if (!searchResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(searchResponse);
        }
        BeanSearchResults beanResults = searchResponse.getResults().getBean(copyFromBTP);
        if (beanResults == null) {
            response.addFailureMessage("Bean to copy from does not exist: " + String.valueOf(copyFromBTP));
            return response.setUserBadRequest();
        }
        for (BeanPropertyDef propertyDef : propertyDefsToClone) {
            SettableValue settableValue;
            Value value = beanResults.getUnsortedValue(propertyDef);
            if (value == null || !(settableValue = value.asSettable()).isSet()) continue;
            values.addPropertyValue(new BeanPropertyValue(propertyDef, settableValue));
        }
        return response.setSuccess(values);
    }

    private List<BeanPropertyDef> getPropertyDefsToClone(BeanTreePath copyFromBTP, Set<Path> propertiesToIgnore) {
        ArrayList<BeanPropertyDef> toClone = new ArrayList<BeanPropertyDef>();
        for (BeanPropertyDef propertyDef : copyFromBTP.getTypeDef().getPropertyDefs()) {
            if (!this.shouldCloneProperty(propertyDef, propertiesToIgnore)) continue;
            toClone.add(propertyDef);
        }
        return toClone;
    }

    private boolean shouldCloneProperty(BeanPropertyDef propertyDef, Set<Path> propertiesToIgnore) {
        if (!propertyDef.isUpdateWritable()) {
            return false;
        }
        if (propertiesToIgnore.contains(propertyDef.getPropertyPath())) {
            return false;
        }
        return this.isSettable(propertyDef);
    }

    private boolean isSettable(BeanPropertyDef propertyDef) {
        BeanTypeDef typeDef = propertyDef.getTypeDef();
        if (!propertyDef.getParentPath().isEmpty()) {
            typeDef = typeDef.getChildDef(propertyDef.getParentPath()).getChildTypeDef();
        }
        return typeDef.isSettable();
    }

    private weblogic.remoteconsole.server.repo.Response<Void> setCloneProperties(InvocationContext copyToIC, BeansPropertyValues values) {
        weblogic.remoteconsole.server.repo.Response response = new weblogic.remoteconsole.server.repo.Response();
        for (BeanPropertyValues beanValues : values.getSortedBeansPropertyValues()) {
            weblogic.remoteconsole.server.repo.Response<Void> r = this.beanEditor(copyToIC).updateBean(copyToIC, beanValues);
            if (r.isSuccess()) continue;
            return response.copyUnsuccessfulResponse(r);
        }
        return response.setSuccess(null);
    }

    protected weblogic.remoteconsole.server.repo.Response<Void> cleanupFailedCreate(InvocationContext ic, BeanTreePath newBeanBTP) {
        return this.pageEditor(ic).delete(new InvocationContext(ic, newBeanBTP));
    }

    protected PageEditorRepo pageEditor(InvocationContext ic) {
        return ic.getPageRepo().asPageEditorRepo();
    }

    protected BeanEditorRepo beanEditor(InvocationContext ic) {
        return ic.getPageRepo().getBeanRepo().asBeanEditorRepo();
    }

    protected weblogic.remoteconsole.server.repo.Response<BeanTreePath> computeNewBeanPath(InvocationContext ic, List<FormProperty> properties) {
        weblogic.remoteconsole.server.repo.Response<BeanTreePath> response = new weblogic.remoteconsole.server.repo.Response<BeanTreePath>();
        BeanTreePath creatorBeanPath = ic.getBeanTreePath();
        if (creatorBeanPath.isOptionalSingleton()) {
            return response.setSuccess(creatorBeanPath);
        }
        if (creatorBeanPath.isCollection()) {
            weblogic.remoteconsole.server.repo.Response<String> keyResponse = this.getKey(ic, properties);
            if (!keyResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(keyResponse);
            }
            Path collectionPath = creatorBeanPath.getPath();
            String childKey = keyResponse.getResults();
            Path childPath = collectionPath.childPath(childKey);
            BeanTreePath childBeanPath = BeanTreePath.create(creatorBeanPath.getBeanRepo(), childPath);
            return response.setSuccess(childBeanPath);
        }
        throw new AssertionError((Object)"Not an optional singleton or collection");
    }

    protected weblogic.remoteconsole.server.repo.Response<String> getKey(InvocationContext ic, List<FormProperty> properties) {
        return this.findRequiredStringProperty(ic, ic.getBeanTreePath().getTypeDef().getKeyPropertyDef().getPropertyPath(), properties);
    }

    protected weblogic.remoteconsole.server.repo.Response<String> findRequiredStringProperty(InvocationContext ic, Path propertyPath, List<FormProperty> properties) {
        String value = this.findOptionalStringProperty(propertyPath, properties);
        weblogic.remoteconsole.server.repo.Response<String> response = new weblogic.remoteconsole.server.repo.Response<String>();
        if (StringUtils.isEmpty((String)value)) {
            response.addFailureMessage(ic.getLocalizer().localizeString(LocalizedConstants.REQUIRED_PROPERTY_NOT_SPECIFIED, propertyPath));
            return response.setUserBadRequest();
        }
        return response.setSuccess(value);
    }

    protected String findOptionalStringProperty(Path propertyPath, List<FormProperty> properties) {
        for (FormProperty property : properties) {
            if (!property.getFieldDef().asBeanPropertyDef().getPropertyPath().equals((Object)propertyPath)) continue;
            return this.getStringPropertyValue(property);
        }
        return null;
    }

    private String getStringPropertyValue(FormProperty property) {
        SettableValue settableValue = property.getValue().asSettable();
        if (!settableValue.isUnset()) {
            Value value = settableValue.getValue();
            if (value.isString()) {
                if (StringUtils.notEmpty((String)value.asString().getValue())) {
                    return value.asString().getValue();
                }
            } else {
                throw new AssertionError((Object)("Non-string key " + String.valueOf(property.getFieldDef())));
            }
        }
        return null;
    }

    protected boolean findOptionalBooleanProperty(Path propertyPath, List<FormProperty> properties, boolean dflt) {
        for (FormProperty property : properties) {
            if (!property.getFieldDef().asBeanPropertyDef().getPropertyPath().equals((Object)propertyPath)) continue;
            return this.getBooleanPropertyValue(property, dflt);
        }
        return dflt;
    }

    private boolean getBooleanPropertyValue(FormProperty property, boolean dflt) {
        SettableValue settableValue = property.getValue().asSettable();
        if (!settableValue.isUnset()) {
            Value value = settableValue.getValue();
            if (value.isBoolean()) {
                return value.asBoolean().getValue();
            }
            throw new AssertionError((Object)("Non-boolean key " + String.valueOf(property.getFieldDef())));
        }
        return dflt;
    }
}

