/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import weblogic.remoteconsole.server.webapp.BeanResource;
import weblogic.remoteconsole.server.webapp.CreateHelper;
import weblogic.remoteconsole.server.webapp.DeleteHelper;
import weblogic.remoteconsole.server.webapp.UpdateHelper;

public class CreatableOptionalSingletonBeanResource
extends BeanResource {
    private static final String VIEW_SLICE = "slice";
    private static final String VIEW_CREATE_FORM = "createForm";

    @GET
    @Produces(value={"application/json"})
    public Response get(@QueryParam(value="view") @DefaultValue(value="slice") String view, @QueryParam(value="slice") @DefaultValue(value="") String slice, @QueryParam(value="reload") @DefaultValue(value="false") boolean reload) {
        this.getInvocationContext().setReload(reload);
        if (VIEW_SLICE.equals(view)) {
            this.setSlicePagePath(slice);
            return this.getSlice();
        }
        if (VIEW_CREATE_FORM.equals(view)) {
            this.setCreateFormPagePath();
            return this.getCreateForm();
        }
        throw new AssertionError((Object)("Invalid view:" + view + ", singleton=" + this.getPageRepoRelativeUri() + ". Valid views are slice and createForm."));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(@QueryParam(value="slice") @DefaultValue(value="") String slice, @QueryParam(value="action") @DefaultValue(value="update") String action, @QueryParam(value="actionForm") @DefaultValue(value="") String actionForm, @QueryParam(value="identifier") @DefaultValue(value="") String identifier, JsonObject requestBody) {
        return this.internalPost(slice, action, actionForm, identifier, requestBody, null);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response post(@QueryParam(value="slice") @DefaultValue(value="") String slice, @QueryParam(value="action") @DefaultValue(value="update") String action, @QueryParam(value="actionForm") @DefaultValue(value="") String actionForm, @QueryParam(value="identifier") @DefaultValue(value="") String identifier, @FormDataParam(value="requestBody") JsonObject requestBody, FormDataMultiPart parts) {
        return this.internalPost(slice, action, actionForm, identifier, requestBody, parts);
    }

    protected Response internalPost(String slice, String action, String actionForm, String identifier, JsonObject requestBody, FormDataMultiPart parts) {
        this.getInvocationContext().setIdentifier(identifier);
        if ("create".equals(action)) {
            this.setCreateFormPagePath();
            return this.createOptionalSingleton(requestBody, parts);
        }
        this.setSlicePagePath(slice);
        if ("customizeTable".equals(action)) {
            return this.customizeTable(requestBody);
        }
        if ("inputForm".equals(actionForm)) {
            return this.getActionInputForm(action, requestBody);
        }
        if ("update".equals(action)) {
            return this.updateSliceForm(requestBody);
        }
        return this.invokeAction(action, requestBody, parts);
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response delete() {
        return this.deleteOptionalSingleton();
    }

    protected Response getSlice() {
        return this.getPage();
    }

    protected Response getCreateForm() {
        return this.getPage();
    }

    protected Response updateSliceForm(JsonObject requestBody) {
        return UpdateHelper.update(this.getInvocationContext(), requestBody);
    }

    protected Response createOptionalSingleton(JsonObject requestBody, FormDataMultiPart parts) {
        if (parts == null) {
            return this.createOptionalSingleton(requestBody);
        }
        return CreateHelper.create(this.getInvocationContext(), requestBody, parts);
    }

    protected Response createOptionalSingleton(JsonObject requestBody) {
        return CreateHelper.create(this.getInvocationContext(), requestBody);
    }

    protected Response deleteOptionalSingleton() {
        return DeleteHelper.delete(this.getInvocationContext());
    }
}

