/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import weblogic.remoteconsole.server.webapp.BeanResource;
import weblogic.remoteconsole.server.webapp.CreateHelper;

public class CreatableBeanCollectionResource
extends BeanResource {
    private static final String VIEW_TABLE = "table";
    private static final String VIEW_CREATE_FORM = "createForm";

    @GET
    @Produces(value={"application/json"})
    public Response get(@QueryParam(value="view") @DefaultValue(value="table") String view, @QueryParam(value="reload") @DefaultValue(value="false") boolean reload) {
        this.getInvocationContext().setReload(reload);
        if (VIEW_TABLE.equals(view)) {
            this.setTablePagePath();
            return this.getTable();
        }
        if (VIEW_CREATE_FORM.equals(view)) {
            this.setCreateFormPagePath();
            return this.getCreateForm();
        }
        throw new AssertionError((Object)("Invalid view:" + view + ", collection=" + this.getPageRepoRelativeUri() + ". Valid views are table and createForm."));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(@QueryParam(value="action") @DefaultValue(value="create") String action, @QueryParam(value="actionForm") @DefaultValue(value="") String actionForm, JsonObject requestBody) {
        return this.internalPost(action, actionForm, requestBody, null);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response post(@QueryParam(value="action") @DefaultValue(value="create") String action, @QueryParam(value="actionForm") @DefaultValue(value="") String actionForm, @FormDataParam(value="requestBody") JsonObject requestBody, FormDataMultiPart parts) {
        return this.internalPost(action, actionForm, requestBody, parts);
    }

    protected Response internalPost(String action, String actionForm, JsonObject requestBody, FormDataMultiPart parts) {
        if ("create".equals(action)) {
            this.setCreateFormPagePath();
            return this.createCollectionChild(requestBody, parts);
        }
        this.setTablePagePath();
        if ("customizeTable".equals(action)) {
            return this.customizeTable(requestBody);
        }
        if ("inputForm".equals(actionForm)) {
            return this.getActionInputForm(action, requestBody);
        }
        return this.invokeAction(action, requestBody, parts);
    }

    protected Response createCollectionChild(JsonObject requestBody, FormDataMultiPart parts) {
        if (parts == null) {
            return this.createCollectionChild(requestBody);
        }
        return CreateHelper.create(this.getInvocationContext(), requestBody, parts);
    }

    protected Response createCollectionChild(JsonObject requestBody) {
        return CreateHelper.create(this.getInvocationContext(), requestBody);
    }

    protected Response getCreateForm() {
        return this.getPage();
    }

    protected Response getCreateFormActionInputForm() {
        return this.getPage();
    }

    protected Response getTable() {
        return this.getPage();
    }
}

