/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.core.Response;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.SlicesDef;
import weblogic.remoteconsole.server.repo.AddedBean;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.Changes;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.ModifiedBeanProperty;
import weblogic.remoteconsole.server.repo.RemovedBean;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.webapp.ChangeManagerStatusResponseMapper;
import weblogic.remoteconsole.server.webapp.ResponseMapper;

public class ChangesResponseMapper
extends ResponseMapper<Changes> {
    public static Response toResponse(InvocationContext invocationContext, weblogic.remoteconsole.server.repo.Response<Changes> response) {
        return new ChangesResponseMapper(invocationContext, response).toResponse();
    }

    private ChangesResponseMapper(InvocationContext invocationContext, weblogic.remoteconsole.server.repo.Response<Changes> response) {
        super(invocationContext, response);
    }

    @Override
    protected void addResults() {
        Changes changes = (Changes)this.getResponse().getResults();
        ChangeManagerStatusResponseMapper.addChangeManagerStatus(this.getEntityBuilder(), changes.getChangeManagerStatus());
        JsonObjectBuilder dataBldr = Json.createObjectBuilder();
        this.addModifications(dataBldr, changes);
        this.addAdditions(dataBldr, changes);
        this.addRemovals(dataBldr, changes);
        this.getEntityBuilder().add("data", dataBldr);
    }

    private void addModifications(JsonObjectBuilder dataBldr, Changes changes) {
        dataBldr.add("modifications", this.formatModifications(this.sortModifications(changes)));
    }

    private JsonArrayBuilder formatModifications(Map<String, Map<String, ModifiedBeanProperty>> sortedModifications) {
        JsonArrayBuilder modsBldr = Json.createArrayBuilder();
        for (Map.Entry<String, Map<String, ModifiedBeanProperty>> beanEntry : sortedModifications.entrySet()) {
            String breadCrumbs = beanEntry.getKey();
            BeanTreePath beanPath = null;
            JsonArrayBuilder propsBldr = Json.createArrayBuilder();
            for (Map.Entry<String, ModifiedBeanProperty> propEntry : beanEntry.getValue().entrySet()) {
                Value newValue;
                String propLabel = propEntry.getKey();
                ModifiedBeanProperty propMod = propEntry.getValue();
                beanPath = this.getPagePath(propMod.getBeanTreePath());
                JsonObjectBuilder propBldr = Json.createObjectBuilder();
                propBldr.add("label", propLabel);
                Value oldValue = propMod.getOldValue();
                if (oldValue != null) {
                    JsonObjectBuilder valBldr = Json.createObjectBuilder();
                    this.addValueToJsonObject(valBldr, Value.unsettableValue(oldValue));
                    propBldr.add("oldValue", valBldr);
                }
                if ((newValue = propMod.getNewValue()) != null) {
                    JsonObjectBuilder valBldr = Json.createObjectBuilder();
                    this.addValueToJsonObject(valBldr, Value.unsettableValue(newValue));
                    propBldr.add("newValue", valBldr);
                }
                propsBldr.add(propBldr);
            }
            JsonObjectBuilder beanBldr = Json.createObjectBuilder();
            beanBldr.add("bean", this.beanTreePathToJson(beanPath, breadCrumbs, ""));
            beanBldr.add("properties", propsBldr);
            modsBldr.add(beanBldr);
        }
        return modsBldr;
    }

    private Map<String, Map<String, ModifiedBeanProperty>> sortModifications(Changes changes) {
        TreeMap<String, Map<String, ModifiedBeanProperty>> sortedModifications = new TreeMap<String, Map<String, ModifiedBeanProperty>>();
        for (ModifiedBeanProperty modification : changes.getModifications()) {
            BeanTreePath beanPath = modification.getBeanTreePath();
            BeanTreePath pagePath = this.getPagePath(beanPath);
            Path pagePropertyPrefix = this.getPropertyPrefix(beanPath, pagePath);
            String breadCrumbs = this.getBreadCrumbs(pagePath);
            TreeMap<String, ModifiedBeanProperty> sortedProperties = (TreeMap<String, ModifiedBeanProperty>)sortedModifications.get(breadCrumbs);
            if (sortedProperties == null) {
                sortedProperties = new TreeMap<String, ModifiedBeanProperty>();
                sortedModifications.put(breadCrumbs, sortedProperties);
            }
            Path pageRelativePropertyPath = pagePropertyPrefix.childPath(modification.getPath());
            String propertyLabel = this.getPropertyLabel(pagePath, pageRelativePropertyPath);
            sortedProperties.put(propertyLabel, modification);
        }
        return sortedModifications;
    }

    private String getPropertyLabel(BeanTreePath pagePath, Path pageRelativePropertyPath) {
        return pageRelativePropertyPath.getDotSeparatedPath();
    }

    private BeanTreePath getPagePath(BeanTreePath beanPath) {
        BeanChildDef lastChildDef = beanPath.getLastSegment().getChildDef();
        if (this.hasSlices(lastChildDef)) {
            return beanPath;
        }
        Path path = beanPath.getPath();
        Path parentPath = path.subPath(0, path.length() - 1);
        return this.getPagePath(BeanTreePath.create(this.getInvocationContext().getPageRepo().getBeanRepo(), parentPath));
    }

    private Path getPropertyPrefix(BeanTreePath beanPath, BeanTreePath pagePath) {
        return beanPath.getPath().subPath(pagePath.getPath().length(), beanPath.getPath().length());
    }

    private void addAdditions(JsonObjectBuilder dataBldr, Changes changes) {
        TreeMap<String, AddedBean> sortedAdditions = new TreeMap<String, AddedBean>();
        for (AddedBean addition : changes.getAdditions()) {
            sortedAdditions.put(this.getBreadCrumbs(addition.getBeanTreePath()), addition);
        }
        JsonArrayBuilder bldr = Json.createArrayBuilder();
        for (Map.Entry entry : sortedAdditions.entrySet()) {
            bldr.add(this.beanTreePathToJson(((AddedBean)entry.getValue()).getBeanTreePath(), (String)entry.getKey(), ""));
        }
        dataBldr.add("additions", bldr);
    }

    private void addRemovals(JsonObjectBuilder dataBldr, Changes changes) {
        TreeMap<String, RemovedBean> sortedRemovals = new TreeMap<String, RemovedBean>();
        for (RemovedBean removal : changes.getRemovals()) {
            sortedRemovals.put(this.getBreadCrumbs(removal.getBeanTreePath()), removal);
        }
        JsonArrayBuilder bldr = Json.createArrayBuilder();
        for (Map.Entry entry : sortedRemovals.entrySet()) {
            bldr.add(Json.createObjectBuilder().add("label", (String)entry.getKey()));
        }
        dataBldr.add("removals", bldr);
    }

    private String getBreadCrumbs(BeanTreePath beanPath) {
        Path breadCrumbs = new Path();
        for (BeanTreePathSegment segment : beanPath.getSegments()) {
            BeanChildDef childDef = segment.getChildDef();
            if (!this.hasSlices(childDef)) continue;
            breadCrumbs.addComponent(this.getInvocationContext().getLocalizer().localizeString(childDef.getLabel(), new Object[0]));
            if (!childDef.isCollection() || !segment.isKeySet()) continue;
            breadCrumbs.addComponent(segment.getKey());
        }
        return breadCrumbs.getSlashSeparatedPath();
    }

    private boolean hasSlices(BeanChildDef childDef) {
        SlicesDef slicesDef = this.getInvocationContext().getPageRepo().getPageRepoDef().getSlicesDef(childDef.getChildTypeDef());
        return slicesDef != null;
    }
}

