/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.server.PersistenceManager;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.webapp.WebAppUtils;

public class BookmarksResource {
    private static final Logger LOGGER = Logger.getLogger(BookmarksResource.class.getName());
    private static final String FILENAME = "bookmarks.json";
    private static final String FILETYPE = "bookmarksV1";

    private static String badFile(InvocationContext ic, String fileName) {
        String newPath = null;
        while (new File(newPath = fileName + "-" + new Random().nextInt(100000)).exists()) {
        }
        LOGGER.warning("Bookmarks file is tainted, tainted file saved as " + newPath);
        new File(fileName).renameTo(new File(newPath));
        return newPath;
    }

    private static void checkSupported(InvocationContext ic) {
        if (PersistenceManager.getPersistenceFilePath(ic) == null) {
            throw new WebApplicationException(Response.status((int)Response.Status.METHOD_NOT_ALLOWED.getStatusCode(), (String)"There is no support for bookmarks in this deployment").build());
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context ResourceContext resourceContext) {
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        BookmarksResource.checkSupported(ic);
        JsonArray wholeThing = BookmarksResource.readBookmarksFromFile(ic);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (wholeThing != null) {
            builder.add("bookmarks", (JsonValue)wholeThing);
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    private static String getKey(JsonObject bookmark) {
        if (!bookmark.containsKey((Object)"value")) {
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Every bookmark must have a URL").build());
        }
        String value = bookmark.getString("value");
        JsonObject slice = bookmark.getJsonObject("slice");
        if (slice != null && slice.containsKey((Object)"name")) {
            if (((JsonValue)slice.get((Object)"name")).getValueType() != JsonValue.ValueType.STRING) {
                throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"A slice must be a string").build());
            }
            return value + "slice-" + slice.getString("name");
        }
        return value;
    }

    @PUT
    @Produces(value={"application/json"})
    public Response put(@Context ResourceContext resourceContext, JsonObject data) {
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        BookmarksResource.checkSupported(ic);
        if (!data.containsKey((Object)"bookmarks") || ((JsonValue)data.get((Object)"bookmarks")).getValueType() != JsonValue.ValueType.ARRAY) {
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"A PUT request must put in some bookmarks").build());
        }
        JsonArray fillThemIn = data.getJsonArray("bookmarks");
        JsonArray currentBookmarks = BookmarksResource.readBookmarksFromFile(ic);
        JsonArrayBuilder outputBookmarks = Json.createArrayBuilder();
        HashSet<String> covered = new HashSet<String>();
        if (currentBookmarks != null) {
            for (JsonObject currentBookmark : currentBookmarks.getValuesAs(JsonObject.class)) {
                String currentKey = BookmarksResource.getKey(currentBookmark);
                for (JsonObject newBookmark : fillThemIn.getValuesAs(JsonObject.class)) {
                    String newKey = BookmarksResource.getKey(newBookmark);
                    if (!newKey.equals(currentKey)) continue;
                    currentBookmark = newBookmark;
                    covered.add(currentKey);
                }
                outputBookmarks.add((JsonValue)currentBookmark);
            }
        }
        for (JsonObject newBookmark : fillThemIn.getValuesAs(JsonObject.class)) {
            String newKey = BookmarksResource.getKey(newBookmark);
            if (covered.contains(newKey)) continue;
            outputBookmarks.add((JsonValue)newBookmark);
        }
        JsonArray outputArray = outputBookmarks.build();
        BookmarksResource.writeBookmarksToFile(ic, outputArray);
        JsonObjectBuilder result = Json.createObjectBuilder();
        result.add("bookmarks", (JsonValue)outputArray);
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)result.build(), (String)"application/json")).build();
    }

    @POST
    @Produces(value={"application/json"})
    public Response post(@Context ResourceContext resourceContext, JsonObject data) {
        InvocationContext ic = WebAppUtils.getInvocationContextFromResourceContext(resourceContext);
        BookmarksResource.checkSupported(ic);
        JsonArray wholeThing = null;
        try {
            wholeThing = data.getJsonArray("bookmarks");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BookmarksResource.writeBookmarksToFile(ic, wholeThing);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (wholeThing != null) {
            builder.add("bookmarks", (JsonValue)wholeThing);
        }
        return WebAppUtils.addCookieFromContext(resourceContext, Response.ok((Object)builder.build(), (String)"application/json")).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonArray readBookmarksFromFile(InvocationContext ic) {
        String path = PersistenceManager.getPersistenceFilePath(ic);
        String fullPath = path + "/bookmarks.json";
        if (!new File(fullPath).exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(fullPath);){
            JsonObject in = Json.createReader((InputStream)is).readObject();
            if (in.getString("fileType") == null || !in.getString("fileType").equals(FILETYPE)) {
                BookmarksResource.badFile(ic, fullPath);
                JsonArray jsonArray = null;
                return jsonArray;
            }
            JsonArray jsonArray = in.getJsonArray("bookmarks");
            return jsonArray;
        }
        catch (Exception ioe) {
            LOGGER.severe("Problem reading " + fullPath + ": " + ioe.getMessage());
            BookmarksResource.badFile(ic, fullPath);
            return null;
        }
    }

    private static void writeBookmarksToFile(InvocationContext ic, JsonArray theWholeThing) {
        String path = PersistenceManager.getPersistenceFilePath(ic);
        if (!new File(path).isDirectory()) {
            new File(path).mkdirs();
        }
        String fullPath = path + "/bookmarks.json";
        if (theWholeThing == null || theWholeThing.size() == 0) {
            new File(fullPath).delete();
            return;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("fileType", FILETYPE);
        builder.add("bookmarks", (JsonValue)theWholeThing);
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writerWithDefaultPrettyPrinter().writeValue(new File(fullPath), mapper.readValue(builder.build().toString(), Object.class));
        }
        catch (Throwable t) {
            LOGGER.severe("Problem writing " + fullPath + ": " + t.getMessage());
            throw new WebApplicationException(Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)("Can't write bookmarks file " + t.getMessage())).build());
        }
    }
}

