/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.webapp.WebAppUtils;

public class AboutResource {
    private static List<CapabilityProvider> provs = new ArrayList<CapabilityProvider>();

    @GET
    @Produces(value={"application/json"})
    public Response about(@Context ResourceContext context) {
        ArrayList<String> caps = new ArrayList<String>();
        for (CapabilityProvider capabilityProvider : provs) {
            caps.addAll(capabilityProvider.getCapabilities());
        }
        JsonArrayBuilder capArray = Json.createArrayBuilder();
        for (String cap : caps) {
            capArray.add(cap);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("about", (JsonValue)Json.createObjectBuilder().add("name", ConsoleBackendRuntimeConfig.getName()).add("version", ConsoleBackendRuntimeConfig.getVersion()).add("capabilities", (JsonValue)capArray.build()).build());
        return WebAppUtils.addCookieFromContext(context, Response.ok((Object)jsonObjectBuilder.build(), (String)"application/json")).build();
    }

    public static void addCapabilityProvider(CapabilityProvider prov) {
        provs.add(prov);
    }

    public static interface CapabilityProvider {
        public List<String> getCapabilities();
    }
}

