/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.utils;

import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

public class WebLogicRestRequestImpl
implements WebLogicRestRequest {
    private final Connection connection;
    private final Client client;
    private final String serverUrl;
    private final String root;
    private final List<String> path;
    private final Map<String, Object> headers;
    private final Map<String, Object> queryParams;
    private final boolean readTimeoutCustomized;
    private final int readTimeout;
    private final boolean connectTimeoutCustomized;
    private final int connectTimeout;

    WebLogicRestRequestImpl(WebLogicRestRequest.Builder builder) {
        this.connection = builder.connection();
        this.client = builder.client();
        this.serverUrl = builder.serverUrl();
        this.root = builder.root();
        this.path = builder.path();
        this.headers = builder.headers();
        this.queryParams = builder.queryParams();
        this.readTimeoutCustomized = builder.readTimeoutCustomized();
        this.readTimeout = builder.readTimeout();
        this.connectTimeoutCustomized = builder.connectTimeoutCustomized();
        this.connectTimeout = builder.connectTimeout();
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public String serverUrl() {
        return this.serverUrl;
    }

    @Override
    public String root() {
        return this.root;
    }

    @Override
    public List<String> path() {
        return this.path;
    }

    @Override
    public Object header(String key) {
        return this.headers.get(key);
    }

    @Override
    public Map<String, Object> headers() {
        return this.headers;
    }

    @Override
    public Object queryParam(String key) {
        return this.queryParams.get(key);
    }

    @Override
    public Map<String, Object> queryParams() {
        return this.queryParams;
    }

    @Override
    public boolean readTimeoutCustomized() {
        return this.readTimeoutCustomized;
    }

    @Override
    public int readTimeout() {
        if (!this.readTimeoutCustomized) {
            throw new AssertionError((Object)"Read timeout not customized");
        }
        return this.readTimeout;
    }

    @Override
    public boolean connectTimeoutCustomized() {
        return this.connectTimeoutCustomized;
    }

    @Override
    public int connectTimeout() {
        if (!this.connectTimeoutCustomized) {
            throw new AssertionError((Object)"Connect timeout not customized");
        }
        return this.connectTimeout;
    }
}

