/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.utils;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import weblogic.remoteconsole.server.connection.Connection;
import weblogic.remoteconsole.server.utils.WebLogicRestRequestException;
import weblogic.remoteconsole.server.utils.WebLogicRestRequestImpl;

public interface WebLogicRestRequest {
    public static final String CURRENT_WEBLOGIC_REST_API_ROOT = "/management/weblogic/12.2.1.0.0";
    public static final String LEGACY_WEBLOGIC_REST_API_ROOT = "/management/wls/latest";

    public Connection connection();

    public Client client();

    public String serverUrl();

    public String root();

    public List<String> path();

    public Object header(String var1);

    public Map<String, Object> headers();

    public Object queryParam(String var1);

    public Map<String, Object> queryParams();

    public boolean readTimeoutCustomized();

    public int readTimeout();

    public boolean connectTimeoutCustomized();

    public int connectTimeout();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Logger LOGGER = Logger.getLogger(Builder.class.getName());
        private static final AtomicInteger WRR_COUNTER = new AtomicInteger(1);
        private Connection connection;
        private Client client;
        private String serverUrl;
        private String root = "/management/weblogic/12.2.1.0.0";
        private List<String> path;
        private Map<String, Object> headers = new HashMap<String, Object>();
        private Map<String, Object> queryParams = new HashMap<String, Object>();
        private boolean readTimeoutCustomized = false;
        private int readTimeout;
        private boolean connectTimeoutCustomized = false;
        private int connectTimeout;

        private Builder() {
        }

        public WebLogicRestRequest build() {
            Context requestContext = Context.builder().id("wrr-" + WRR_COUNTER.getAndIncrement()).build();
            return (WebLogicRestRequest)Contexts.runInContext((Context)requestContext, this::doBuild);
        }

        public Builder header(String key, Object value) {
            if (key != null) {
                this.headers.put(key, value);
            }
            return this;
        }

        public Builder asynchronous(boolean asynchronous) {
            if (asynchronous) {
                return this.header("Prefer", "respond-async,wait=2");
            }
            this.headers.remove("Prefer");
            return this;
        }

        public Builder expandedValues(boolean expandedValues) {
            return this.queryParam("expandedValues", expandedValues);
        }

        public Builder internal(boolean internal) {
            return this.queryParam("internal", internal);
        }

        public Builder saveChanges(boolean saveChanges) {
            return this.queryParam("saveChanges", saveChanges);
        }

        public Builder queryParam(String key, Object value) {
            if (key != null) {
                this.queryParams.put(key, value);
            }
            return this;
        }

        Connection connection() {
            return this.connection;
        }

        public Builder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        Client client() {
            return this.client;
        }

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        String serverUrl() {
            return this.serverUrl;
        }

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        String root() {
            return this.root;
        }

        public Builder root(String root) {
            this.root = root;
            return this;
        }

        List<String> path() {
            return this.path;
        }

        public Builder path(List<String> path) {
            this.path = path;
            return this;
        }

        public Builder path(String path) {
            this.path = new ArrayList<String>();
            this.path.add(path);
            return this;
        }

        Map<String, Object> headers() {
            return this.headers;
        }

        public Builder headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        Map<String, Object> queryParams() {
            return this.queryParams;
        }

        public Builder queryParams(Map<String, Object> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public boolean readTimeoutCustomized() {
            return this.readTimeoutCustomized;
        }

        public int readTimeout() {
            return this.readTimeout;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeoutCustomized = true;
            this.readTimeout = readTimeout;
            return this;
        }

        public boolean connectTimeoutCustomized() {
            return this.connectTimeoutCustomized;
        }

        public int connectTimeout() {
            return this.connectTimeout;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeoutCustomized = true;
            this.connectTimeout = connectTimeout;
            return this;
        }

        private WebLogicRestRequest doBuild() throws WebLogicRestRequestException {
            LOGGER.entering(Builder.class.getName(), "build");
            if (this.path == null) {
                throw new WebLogicRestRequestException("path is a required builder item!");
            }
            return new WebLogicRestRequestImpl(this);
        }
    }
}

