/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.utils;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.common.utils.MessageUtils;
import weblogic.remoteconsole.server.utils.ResponseHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

public class WebLogicRestClientHelper {
    public static Response getWebLogicRestErrorMessages(Response response) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (WebLogicRestClientHelper.addMessagesFromJsonEntity(response, messages) || !WebLogicRestClientHelper.addMessageFromStringEntity(response, messages)) {
            // empty if block
        }
        JsonObject entity = Json.createObjectBuilder().add("messages", (JsonValue)MessageUtils.createMessagesJsonArray(messages)).build();
        return Response.status((int)response.getStatus(), (String)response.getStatusInfo().getReasonPhrase()).entity((Object)entity).header("Content-Type", (Object)"application/json").build();
    }

    public static MultivaluedMap<String, Object> createHeaders(WebLogicRestRequest request) {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-type", (Object)"application/json");
        headers.add((Object)"X-Requested-By", (Object)"ConsoleBackendRestClient");
        headers.add((Object)"X-Skip-Resource-Links", (Object)"true");
        headers.add((Object)"weblogic.edit.session", (Object)"default");
        for (String header : request.headers().keySet()) {
            headers.add((Object)header, request.headers().get(header));
        }
        return headers;
    }

    public static boolean isErrorResponse(String httpMethod, int httpStatus) {
        boolean result;
        switch (httpMethod) {
            case "PUT": {
                result = httpStatus != Response.Status.NO_CONTENT.getStatusCode();
                break;
            }
            case "POST": {
                result = httpStatus != Response.Status.OK.getStatusCode() && httpStatus != Response.Status.CREATED.getStatusCode() && httpStatus != Response.Status.ACCEPTED.getStatusCode();
                break;
            }
            default: {
                result = httpStatus != Response.Status.OK.getStatusCode();
            }
        }
        return result;
    }

    private static boolean addMessagesFromJsonEntity(Response response, List<Message> messages) {
        JsonObject entity = ResponseHelper.getEntityAsJson(response);
        if (entity == null) {
            return false;
        }
        if (WebLogicRestClientHelper.addMessagesFromErrorsDetails(entity, messages)) {
            return true;
        }
        if (WebLogicRestClientHelper.addMessageFromJsonMessage(entity, messages)) {
            return true;
        }
        return true;
    }

    private static boolean addMessagesFromErrorsDetails(JsonObject entity, List<Message> messages) {
        String errorKey = "wls:errorsDetails";
        if (!entity.containsKey((Object)errorKey)) {
            return false;
        }
        JsonArray errors = entity.getJsonArray(errorKey);
        for (int i = 0; i < errors.size(); ++i) {
            WebLogicRestClientHelper.addMessageFromJsonMessage(errors.getJsonObject(i), messages);
        }
        return true;
    }

    private static boolean addMessageFromJsonMessage(JsonObject json, List<Message> messages) {
        if (!json.containsKey((Object)"title")) {
            return false;
        }
        String severity = json.getString("title");
        String text = json.getString("detail");
        String property = null;
        if (json.containsKey((Object)"o:errorPath")) {
            property = json.getString("o:errorPath");
        }
        messages.add(new Message(severity, property, text));
        return true;
    }

    private static boolean addMessageFromStringEntity(Response response, List<Message> messages) {
        String entity = ResponseHelper.getEntityAsString(response);
        if (entity == null) {
            return false;
        }
        if (WebLogicRestClientHelper.isSuccess(response.getStatus())) {
            messages.add(Message.newSuccessMessage(entity));
        } else {
            messages.add(Message.newFailureMessage(entity));
        }
        return true;
    }

    private static boolean isSuccess(int httpStatus) {
        return httpStatus == Response.Status.OK.getStatusCode() || httpStatus == Response.Status.CREATED.getStatusCode();
    }
}

