/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.utils;

import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.net.ssl.SSLException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import weblogic.remoteconsole.common.repodef.LocalizedConstants;
import weblogic.remoteconsole.server.utils.ResponseHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestClientException;
import weblogic.remoteconsole.server.utils.WebLogicRestClientHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

public class WebLogicRestClient {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestClient.class.getName());

    public static Response get(WebLogicRestRequest request) throws WebLogicRestClientException {
        return WebLogicRestClient.get(request, "application/json");
    }

    public static Response get(WebLogicRestRequest request, String accept) throws WebLogicRestClientException {
        WebTarget webTarget = WebLogicRestClient.getWebTarget(request);
        MultivaluedMap<String, Object> headers = WebLogicRestClientHelper.createHeaders(request);
        Response response = null;
        try {
            response = webTarget.request().headers(headers).accept(new String[]{accept}).get();
            if (WebLogicRestClientHelper.isErrorResponse("GET", response.getStatus())) {
                response = WebLogicRestClientHelper.getWebLogicRestErrorMessages(response);
            }
        }
        catch (ProcessingException pe) {
            if (response != null) {
                response.close();
            }
            response = WebLogicRestClient.handleProcessingException(pe);
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            e.printStackTrace();
            response = ResponseHelper.createExceptionResponse(e);
        }
        return response;
    }

    public static Response post(WebLogicRestRequest request, Entity<Object> entity, String acceptType) throws WebLogicRestClientException {
        WebTarget webTarget = WebLogicRestClient.getWebTarget(request);
        MultivaluedMap<String, Object> headers = WebLogicRestClientHelper.createHeaders(request);
        Response response = null;
        try {
            response = (Response)webTarget.request().headers(headers).accept(new String[]{acceptType}).post(entity, Response.class);
            if (WebLogicRestClientHelper.isErrorResponse("POST", response.getStatus())) {
                response = WebLogicRestClientHelper.getWebLogicRestErrorMessages(response);
            }
        }
        catch (ProcessingException pe) {
            if (response != null) {
                response.close();
            }
            response = WebLogicRestClient.handleProcessingException(pe);
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            e.printStackTrace();
            response = ResponseHelper.createExceptionResponse(e);
        }
        return response;
    }

    public static Response post(WebLogicRestRequest request, Entity<Object> entity) throws WebLogicRestClientException {
        return WebLogicRestClient.post(request, entity, "application/json");
    }

    public static Response post(WebLogicRestRequest request, JsonObject data) throws WebLogicRestClientException {
        LOGGER.finest("data=" + String.valueOf(data));
        return WebLogicRestClient.post(request, (Entity<Object>)Entity.entity((Object)data, (String)"application/json"));
    }

    public static Response post(WebLogicRestRequest request, FormDataMultiPart parts) throws WebLogicRestClientException {
        return WebLogicRestClient.post(request, (Entity<Object>)Entity.entity((Object)parts, (String)"multipart/form-data"));
    }

    public static Response downloadAsInputStream(WebLogicRestRequest request, JsonObject data, String acceptType) {
        try {
            Response response = WebLogicRestClient.post(request, (Entity<Object>)Entity.entity((Object)data, (String)"application/json"), acceptType);
            if (WebLogicRestClientHelper.isErrorResponse("POST", response.getStatus())) {
                return response;
            }
            return Response.ok((Object)response.readEntity(InputStream.class)).build();
        }
        catch (WebLogicRestClientException e) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getAsInputStream(WebLogicRestRequest request, String acceptType) {
        WebApplicationException we;
        block11: {
            Response response = null;
            boolean succeeded = false;
            we = null;
            try {
                WebTarget webTarget = WebLogicRestClient.getWebTarget(request);
                MultivaluedMap<String, Object> headers = WebLogicRestClientHelper.createHeaders(request);
                response = webTarget.request().headers(headers).accept(new String[]{acceptType}).get();
                if (WebLogicRestClientHelper.isErrorResponse("GET", response.getStatus())) {
                    we = new WebApplicationException(WebLogicRestClientHelper.getWebLogicRestErrorMessages(response));
                    break block11;
                }
                succeeded = true;
                InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                return inputStream;
            }
            catch (ProcessingException pe) {
                try {
                    we = new WebApplicationException(WebLogicRestClient.handleProcessingException(pe));
                }
                catch (Exception ce) {
                    we = new WebApplicationException(ResponseHelper.createExceptionResponse(ce));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                we = new WebApplicationException(ResponseHelper.createExceptionResponse(e));
            }
            finally {
                if (!succeeded && response != null) {
                    response.close();
                }
            }
        }
        throw we;
    }

    public static Response delete(WebLogicRestRequest request) throws WebLogicRestClientException {
        WebTarget webTarget = WebLogicRestClient.getWebTarget(request);
        MultivaluedMap<String, Object> headers = WebLogicRestClientHelper.createHeaders(request);
        Response response = null;
        try {
            response = (Response)webTarget.request().headers(headers).accept(new String[]{"application/json"}).delete(Response.class);
            if (WebLogicRestClientHelper.isErrorResponse("DELETE", response.getStatus())) {
                response = WebLogicRestClientHelper.getWebLogicRestErrorMessages(response);
            }
        }
        catch (ProcessingException pe) {
            if (response != null) {
                response.close();
            }
            response = WebLogicRestClient.handleProcessingException(pe);
        }
        catch (Exception e) {
            if (response != null) {
                response.close();
            }
            e.printStackTrace();
            response = ResponseHelper.createExceptionResponse(e);
        }
        return response;
    }

    public static WebTarget getWebTarget(WebLogicRestRequest request) throws WebLogicRestClientException {
        String targetUri = WebLogicRestClient.calculateTargetUri(request);
        if (targetUri == null) {
            throw new WebLogicRestClientException("Unable to determine console backend connection endpoint.");
        }
        Client client = WebLogicRestClient.getClient(request);
        if (client == null) {
            throw new WebLogicRestClientException("Unable to obtain target of backend connection.");
        }
        WebTarget target = client.target(targetUri);
        for (String string : request.path()) {
            target = target.path(string);
        }
        for (Map.Entry entry : request.queryParams().entrySet()) {
            target = target.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
        }
        if (request.readTimeoutCustomized()) {
            target = (WebTarget)target.property("jersey.config.client.readTimeout", (Object)request.readTimeout());
        }
        if (request.connectTimeoutCustomized()) {
            target = (WebTarget)target.property("jersey.config.client.connectTimeout", (Object)request.connectTimeout());
        }
        return target.queryParam("enableConsoleRestExtension", new Object[]{true});
    }

    private static Client getClient(WebLogicRestRequest request) {
        Client client = null;
        if (request.client() != null) {
            client = request.client();
            LOGGER.finest("Client from WebLogicRestRequest");
        } else if (request.connection() != null) {
            client = request.connection().getClient();
            LOGGER.finest("Client from WebLogicRestRequest Connection");
        }
        return client;
    }

    private static String calculateTargetUri(WebLogicRestRequest request) {
        String root = request.root();
        String calculatedTargetUri = null;
        if (request.serverUrl() != null) {
            calculatedTargetUri = request.serverUrl() + root;
            LOGGER.finest("Request Server URL calculatedTargetUri=" + calculatedTargetUri);
        } else if (request.connection() != null) {
            calculatedTargetUri = request.connection().getDomainUrl() + root;
            LOGGER.finest("Request Connection URL calculatedTargetUri=" + calculatedTargetUri);
        }
        return calculatedTargetUri;
    }

    public static Response handleProcessingException(Throwable t) throws WebLogicRestClientException {
        Throwable cause = t.getCause();
        if (cause instanceof SSLException) {
            return ResponseHelper.createExceptionResponse(Response.Status.BAD_REQUEST, cause, cause.getMessage());
        }
        if (cause instanceof ConnectException) {
            return ResponseHelper.createExceptionResponse(Response.Status.NOT_FOUND, cause, cause.getMessage());
        }
        if (cause instanceof SocketTimeoutException) {
            String message = LocalizedConstants.WEBLOGIC_REST_REQUEST_TIMED_OUT.getEnglishText(new Object[0]);
            return ResponseHelper.createExceptionResponse(Response.Status.GATEWAY_TIMEOUT, null, message);
        }
        if (cause instanceof SocketException) {
            return ResponseHelper.createExceptionResponse(Response.Status.INTERNAL_SERVER_ERROR, cause, cause.getMessage());
        }
        if (cause != null) {
            return WebLogicRestClient.handleProcessingException(cause);
        }
        throw new WebLogicRestClientException(t);
    }
}

