/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.utils;

import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.common.utils.MessageUtils;

public class ResponseHelper {
    private ResponseHelper() {
    }

    public static JsonObject getEntityAsJson(Response response) {
        if (!response.hasEntity()) {
            return null;
        }
        Object entity = response.getEntity();
        if (entity instanceof JsonObject) {
            return (JsonObject)entity;
        }
        if (!"application/json".equals(response.getHeaderString("Content-Type"))) {
            return null;
        }
        return (JsonObject)response.readEntity(JsonObject.class);
    }

    public static String getEntityAsString(Response response) {
        if (!response.hasEntity()) {
            return null;
        }
        Object entity = response.getEntity();
        if (entity instanceof String) {
            return (String)entity;
        }
        try {
            return (String)response.readEntity(String.class);
        }
        catch (IllegalStateException ise) {
            return response.getEntity().toString();
        }
    }

    public static Response createExceptionResponse(Throwable cause) {
        return ResponseHelper.createExceptionResponse(cause, null);
    }

    public static Response createExceptionResponse(Throwable cause, String text) {
        return ResponseHelper.createExceptionResponse(Response.Status.INTERNAL_SERVER_ERROR, cause, text);
    }

    public static Response createExceptionResponse(Response.Status status, Throwable cause, String text) {
        return Response.status((Response.Status)status).entity((Object)MessageUtils.throwableAsMessagesJsonObject(cause, text)).build();
    }
}

