/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.token;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.LinkedHashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import weblogic.remoteconsole.server.ConsoleBackendRuntime;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.providers.AdminServerDataProvider;

public class SsoTokenManager {
    private static final Logger LOGGER = Logger.getLogger(SsoTokenManager.class.getName());
    private static final int SEED_SIZE = 16;
    private static final int NONCE_SIZE = 8;
    private SecureRandom nonceGenerator = null;
    private volatile Timer ssoTimer = null;
    private volatile ConcurrentHashMap<String, ProviderEntry> ssoTokenIdMap = new ConcurrentHashMap();

    public static void setInRequestContext(ContainerRequestContext requestContext) {
        ConsoleBackendRuntime.INSTANCE.getSsoTokenManager().storeInRequestContext(requestContext);
    }

    public static SsoTokenManager getFromRequestContext(ContainerRequestContext requestContext) {
        return (SsoTokenManager)requestContext.getProperty(SsoTokenManager.class.getName());
    }

    public static SsoTokenManager getFromResourceContext(ResourceContext resourceContext) {
        return SsoTokenManager.getFromRequestContext((ContainerRequestContext)resourceContext.getResource(ContainerRequestContext.class));
    }

    private long getSSOTimerMillis() {
        return ConsoleBackendRuntimeConfig.getSsoTimerSeconds() * 1000L;
    }

    private long getSSOTimeoutMillis() {
        return ConsoleBackendRuntimeConfig.getSsoTimeoutSeconds() * 1000L;
    }

    public void storeInRequestContext(ContainerRequestContext requestContext) {
        requestContext.setProperty(SsoTokenManager.class.getName(), (Object)this);
    }

    public AdminServerDataProvider get(String ssoid) {
        AdminServerDataProvider provider = this.getProviderFromEntry(ssoid);
        LOGGER.fine("Get provider with ssoid '" + ssoid + (provider == null ? "' NOT FOUND!" : "'"));
        return provider;
    }

    public String add(AdminServerDataProvider provider) {
        String ssoid = this.getNonce();
        LOGGER.fine("Add provider '" + provider.getName() + "' ssoid: " + ssoid);
        this.addProviderEntry(ssoid, provider);
        this.checkSsoTimer();
        return ssoid;
    }

    public String remove(AdminServerDataProvider provider) {
        String ssoid = provider.getSsoTokenId();
        if (ssoid != null) {
            LOGGER.fine("Remove provider '" + provider.getName() + "' ssoid: " + ssoid);
            this.ssoTokenIdMap.remove(ssoid);
            this.checkSsoTimer();
        }
        return ssoid;
    }

    public boolean isAllowedOrigin(String origin) {
        boolean result = false;
        if (origin != null && !origin.isBlank()) {
            String allowed = this.ssoTokenIdMap.searchValues(1L, entry -> {
                String domainOrigin = entry.getProvider().getURLOrigin();
                if (origin.equalsIgnoreCase(domainOrigin)) {
                    return domainOrigin;
                }
                return null;
            });
            result = allowed != null;
        }
        LOGGER.fine("isAllowedOrigin('" + origin + "') returning: " + result);
        return result;
    }

    private void addProviderEntry(String ssoid, AdminServerDataProvider provider) {
        this.ssoTokenIdMap.put(ssoid, new ProviderEntry(provider, this.getSSOTimeoutMillis()));
    }

    private AdminServerDataProvider getProviderFromEntry(String ssoid) {
        AdminServerDataProvider provider = null;
        ProviderEntry entry = this.ssoTokenIdMap.get(ssoid);
        if (entry != null) {
            provider = entry.getProvider();
        }
        return provider;
    }

    private synchronized void checkSsoTimer() {
        if (this.ssoTokenIdMap.isEmpty() && this.ssoTimer != null) {
            this.ssoTimer.cancel();
            this.ssoTimer = null;
            LOGGER.fine("Canceled SSO timer!");
        } else if (!this.ssoTokenIdMap.isEmpty() && this.ssoTimer == null) {
            this.ssoTimer = new Timer("SsoTokenManager", true);
            this.ssoTimer.schedule((TimerTask)new SsoTokenTimer(), this.getSSOTimerMillis(), this.getSSOTimerMillis());
            LOGGER.fine("Started SSO timer with interval millis: " + this.getSSOTimerMillis());
        }
    }

    private synchronized String getNonce() {
        if (this.nonceGenerator == null) {
            this.nonceGenerator = new SecureRandom();
            this.initializeNonceGenerator();
        }
        byte[] bytes = new byte[8];
        this.nonceGenerator.nextBytes(bytes);
        return new BigInteger(1, bytes).toString(16);
    }

    private void initializeNonceGenerator() {
        this.nonceGenerator.setSeed(this.nonceGenerator.generateSeed(16));
    }

    private class ProviderEntry {
        private long expireTime;
        private AdminServerDataProvider provider;

        ProviderEntry(AdminServerDataProvider adminServerDataProvider, long timeout) {
            this.provider = adminServerDataProvider;
            this.expireTime = System.currentTimeMillis() + timeout;
        }

        AdminServerDataProvider getProvider() {
            return this.provider;
        }

        long getExpireTime() {
            return this.expireTime;
        }
    }

    private class SsoTokenTimer
    extends TimerTask {
        private SsoTokenTimer() {
        }

        @Override
        public void run() {
            LOGGER.fine("SsoTokenTimer executing with SSO timeout millis: " + SsoTokenManager.this.getSSOTimeoutMillis());
            LinkedHashSet removes = new LinkedHashSet();
            long now = System.currentTimeMillis();
            SsoTokenManager.this.ssoTokenIdMap.forEach((ssoid, entry) -> {
                if (now > entry.getExpireTime()) {
                    removes.add(ssoid);
                }
            });
            if (!removes.isEmpty()) {
                LOGGER.fine("SsoTokenTimer removing expired entries: " + String.valueOf(removes));
                removes.forEach(ssoid -> SsoTokenManager.this.ssoTokenIdMap.remove(ssoid));
            }
            SsoTokenManager.this.checkSsoTimer();
        }
    }
}

