/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.BeanValueDef;
import weblogic.remoteconsole.server.repo.ArrayValue;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BooleanValue;
import weblogic.remoteconsole.server.repo.DateAsLongValue;
import weblogic.remoteconsole.server.repo.DateValue;
import weblogic.remoteconsole.server.repo.DoubleValue;
import weblogic.remoteconsole.server.repo.EntitleNetExpressionValue;
import weblogic.remoteconsole.server.repo.HealthStateValue;
import weblogic.remoteconsole.server.repo.IntValue;
import weblogic.remoteconsole.server.repo.LongValue;
import weblogic.remoteconsole.server.repo.NullReference;
import weblogic.remoteconsole.server.repo.PropertiesValue;
import weblogic.remoteconsole.server.repo.ReferenceAsReferencesValue;
import weblogic.remoteconsole.server.repo.SecretValue;
import weblogic.remoteconsole.server.repo.StringValue;
import weblogic.remoteconsole.server.repo.ThrowableValue;
import weblogic.remoteconsole.server.repo.UnresolvedReference;
import weblogic.remoteconsole.server.repo.Value;

class WebLogicRestValueBuilder {
    private BeanRepo beanRepo;
    private BeanChildDef rootChildDef;
    private static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    WebLogicRestValueBuilder(BeanRepo beanRepo, BeanChildDef rootChildDef) {
        this.beanRepo = beanRepo;
        this.rootChildDef = rootChildDef;
    }

    Value buildValue(BeanValueDef valueDef, JsonValue jsonValue) {
        return this.getValue(valueDef, jsonValue, false);
    }

    Value buildReference(JsonValue jsonValue) {
        return this.getReference(jsonValue, false);
    }

    Value buildReferences(JsonValue jsonValue) {
        ArrayList<Value> values = new ArrayList<Value>();
        if (jsonValue != JsonValue.NULL) {
            for (JsonValue jsonVal : jsonValue.asJsonArray()) {
                values.add(this.getReference(jsonVal, true));
            }
        }
        return new ArrayValue(values);
    }

    private Value getValue(BeanValueDef valueDef, JsonValue jsonValue, boolean processingArray) {
        if (valueDef.isReferenceAsReferences()) {
            ArrayList<Value> values = new ArrayList<Value>();
            for (JsonValue jsonVal : jsonValue.asJsonArray()) {
                values.add(this.getReference(jsonVal, true));
            }
            return new ReferenceAsReferencesValue(values);
        }
        if (valueDef.isArray() && !processingArray) {
            return this.getArray(valueDef, jsonValue);
        }
        if (valueDef.isReference()) {
            return this.getReference(jsonValue, processingArray);
        }
        if (valueDef.isString()) {
            String value = jsonValue == JsonValue.NULL ? null : ((JsonString)jsonValue).getString();
            return new StringValue(value);
        }
        if (valueDef.isSecret()) {
            String value = jsonValue == JsonValue.NULL ? null : ((JsonString)jsonValue).getString();
            return new SecretValue(value);
        }
        if (valueDef.isBoolean()) {
            return new BooleanValue(jsonValue == JsonValue.TRUE);
        }
        if (valueDef.isInt()) {
            int value = jsonValue == JsonValue.NULL ? 0 : ((JsonNumber)jsonValue).intValue();
            return new IntValue(value);
        }
        if (valueDef.isLong()) {
            long value = jsonValue == JsonValue.NULL ? 0L : ((JsonNumber)jsonValue).longValue();
            return new LongValue(value);
        }
        if (valueDef.isDouble()) {
            double value = jsonValue == JsonValue.NULL ? 0.0 : ((JsonNumber)jsonValue).doubleValue();
            return new DoubleValue(value);
        }
        if (valueDef.isDateAsLong()) {
            long value = jsonValue == JsonValue.NULL ? 0L : ((JsonNumber)jsonValue).longValue();
            return new DateAsLongValue(value);
        }
        if (valueDef.isProperties()) {
            return new PropertiesValue(this.getProperties(jsonValue));
        }
        if (valueDef.isHealthState()) {
            return new HealthStateValue(this.getHealthState(jsonValue));
        }
        if (valueDef.isEntitleNetExpression()) {
            return new EntitleNetExpressionValue(jsonValue);
        }
        if (valueDef.isThrowable()) {
            return new ThrowableValue(this.getThrowable(jsonValue));
        }
        if (valueDef.isDate()) {
            return new DateValue(this.getDate(jsonValue));
        }
        throw new AssertionError((Object)("Unsupported value kind: " + String.valueOf(valueDef) + " " + String.valueOf((Object)valueDef.getValueKind())));
    }

    private ArrayValue getArray(BeanValueDef valueDef, JsonValue jsonValue) {
        ArrayList<Value> values = new ArrayList<Value>();
        if (jsonValue != JsonValue.NULL) {
            for (JsonValue jsonVal : jsonValue.asJsonArray()) {
                values.add(this.getValue(valueDef, jsonVal, true));
            }
        }
        return new ArrayValue(values);
    }

    private Properties getProperties(JsonValue jsonValue) {
        Properties properties = new Properties();
        if (jsonValue != JsonValue.NULL) {
            JsonObject jsonObj = jsonValue.asJsonObject();
            for (String key : jsonObj.keySet()) {
                String value = jsonObj.getString(key);
                properties.setProperty(key, value);
            }
        }
        return properties;
    }

    private Date getDate(JsonValue jsonValue) {
        String iso8601 = ((JsonString)jsonValue).getString();
        if (StringUtils.isEmpty((String)iso8601)) {
            return null;
        }
        try {
            return new SimpleDateFormat(ISO_8601_DATE_TIME_FORMAT).parse(iso8601);
        }
        catch (ParseException e) {
            throw new AssertionError("Can't parse as iso8601: " + iso8601, e);
        }
    }

    private Throwable getThrowable(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue == JsonValue.NULL) {
            return null;
        }
        JsonObject jsonObj = jsonValue.asJsonObject();
        String message = jsonObj.getString("message");
        Throwable cause = this.getThrowable((JsonValue)jsonObj.get((Object)"cause"));
        return new Throwable(message, cause);
    }

    private String getHealthState(JsonValue jsonValue) {
        String result = null;
        if (jsonValue != null && jsonValue != JsonValue.NULL) {
            result = jsonValue.asJsonObject().getString("state");
        }
        return result;
    }

    private Value getReference(JsonValue jsonValue, boolean processingArray) {
        if (processingArray) {
            jsonValue = jsonValue.asJsonObject().getJsonArray("identity");
        }
        if (jsonValue == JsonValue.NULL) {
            return NullReference.INSTANCE;
        }
        BeanChildDef startingChildBean = this.rootChildDef;
        Path beanPath = new Path();
        beanPath.addComponent(startingChildBean.getChildName());
        BeanTypeDef typeDef = startingChildBean.getChildTypeDef();
        JsonArray restSegments = jsonValue.asJsonArray();
        for (int i = 0; i < restSegments.size(); ++i) {
            boolean searchSubTypes;
            String restName = restSegments.getString(i);
            String childName = StringUtils.getBeanName((String)restName);
            BeanChildDef childDef = typeDef.getChildDef(new Path(childName), searchSubTypes = true);
            if (childDef == null) {
                return new UnresolvedReference(restSegments.getString(restSegments.size() - 1));
            }
            beanPath.addComponent(childDef.getChildName());
            if (childDef.isCollection() && i < restSegments.size() - 1) {
                beanPath.addComponent(restSegments.getString(++i));
            }
            typeDef = childDef.getChildTypeDef();
        }
        return BeanTreePath.create(this.beanRepo, beanPath);
    }
}

