/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.Map;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;

public class WebLogicRestSearchResultsFixer {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestSearchResultsFixer.class.getName());
    protected static final String PROP_IDENTITY = "identity";
    protected static final String PROP_ITEMS = "items";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_TYPE = "type";
    protected static final String PROP_SERVER_RUNTIMES = "serverRuntimes";

    static JsonObject fixServerRuntimes(JsonObject unfixedSlice, BeanTypeDef rootTypeDef) {
        return new Fixer(unfixedSlice, rootTypeDef).fixIdentities();
    }

    private static class Fixer {
        private boolean ignore;
        private BeanTypeDef beanTypeDef;
        private JsonObject unfixedBean;
        private JsonObjectBuilder fixedBeanBuilder;
        private JsonArray fixedIdentity;
        private String typedPath;
        private String serverName;

        private boolean isIgnore() {
            return this.ignore;
        }

        private BeanTypeDef getBeanTypeDef() {
            return this.beanTypeDef;
        }

        private JsonObject getUnfixedBean() {
            return this.unfixedBean;
        }

        private JsonObjectBuilder getFixedBeanBuilder() {
            return this.fixedBeanBuilder;
        }

        private JsonArray getFixedIdentity() {
            return this.fixedIdentity;
        }

        private String getTypedPath() {
            return this.typedPath;
        }

        private String getServerName() {
            return this.serverName;
        }

        Fixer(JsonObject unfixedRootBean, BeanTypeDef rootTypeDef) {
            this.unfixedBean = unfixedRootBean;
            this.fixedBeanBuilder = Json.createObjectBuilder((JsonObject)this.getUnfixedBean());
            this.beanTypeDef = rootTypeDef;
            this.fixedIdentity = Json.createArrayBuilder().build();
            this.typedPath = "[ type=domainRuntime ]";
        }

        private Fixer(Fixer parent, BeanTypeDef beanTypeDef, Boolean isCollection, String propRestName, JsonObject unfixedBean) {
            boolean isServerRuntime = WebLogicRestSearchResultsFixer.PROP_SERVER_RUNTIMES.equals(propRestName);
            LOGGER.finest("Fixer " + propRestName + " for " + String.valueOf(beanTypeDef));
            if (isServerRuntime && unfixedBean.containsKey((Object)"httpStatus")) {
                this.ignore = true;
                LOGGER.finest("Ignoring " + propRestName + " " + String.valueOf(unfixedBean));
                return;
            }
            this.unfixedBean = unfixedBean;
            this.fixedBeanBuilder = Json.createObjectBuilder((JsonObject)this.getUnfixedBean());
            String name = null;
            if (!unfixedBean.containsKey((Object)WebLogicRestSearchResultsFixer.PROP_NAME)) {
                JsonArray identity;
                if (unfixedBean.containsKey((Object)WebLogicRestSearchResultsFixer.PROP_IDENTITY) && !(identity = unfixedBean.getJsonArray(WebLogicRestSearchResultsFixer.PROP_IDENTITY)).isEmpty()) {
                    name = identity.getString(identity.size() - 1);
                }
                if (name == null) {
                    name = StringUtils.getSimpleTypeName((String)beanTypeDef.getTypeName());
                }
            } else {
                name = unfixedBean.getString(WebLogicRestSearchResultsFixer.PROP_NAME);
            }
            String type = null;
            type = !unfixedBean.containsKey((Object)WebLogicRestSearchResultsFixer.PROP_TYPE) ? StringUtils.getSimpleTypeName((String)beanTypeDef.getTypeName()) : unfixedBean.getString(WebLogicRestSearchResultsFixer.PROP_TYPE);
            this.beanTypeDef = beanTypeDef;
            JsonArrayBuilder fixedIdentityBuilder = Json.createArrayBuilder((JsonArray)parent.getFixedIdentity()).add(propRestName);
            if (isCollection.booleanValue()) {
                fixedIdentityBuilder.add(name);
            }
            this.fixedIdentity = fixedIdentityBuilder.build();
            this.serverName = isServerRuntime ? name : parent.getServerName();
            this.typedPath = parent.getTypedPath() + " [ prop=" + propRestName + " type=" + type + " ]";
        }

        private JsonObject fixIdentities() {
            for (Map.Entry unfixedBeanProperty : this.getUnfixedBean().entrySet()) {
                String propertyName = (String)unfixedBeanProperty.getKey();
                if (WebLogicRestSearchResultsFixer.PROP_IDENTITY.equals(propertyName)) {
                    this.fixIdentityProperty(((JsonValue)unfixedBeanProperty.getValue()).asJsonArray());
                    continue;
                }
                this.fixNonIdentityProperty(propertyName, (JsonValue)unfixedBeanProperty.getValue());
            }
            return this.getFixedBeanBuilder().build();
        }

        private void fixIdentityProperty(JsonArray unfixedIdentity) {
            JsonArray fixedIdentity = this.getFixedIdentity();
            if (this.getServerName() != null) {
                unfixedIdentity = this.serverRuntimeIdentityToDomainRuntimeIdentity(unfixedIdentity);
            }
            if (!fixedIdentity.toString().equals(unfixedIdentity.toString())) {
                LOGGER.fine("Unexpected identity.  path: " + this.getTypedPath() + " expected: " + String.valueOf(fixedIdentity) + " have:" + String.valueOf(unfixedIdentity));
            }
            this.getFixedBeanBuilder().add(WebLogicRestSearchResultsFixer.PROP_IDENTITY, (JsonValue)fixedIdentity);
        }

        private void fixNonIdentityProperty(String propertyName, JsonValue unfixedPropertyValue) {
            Path beanPath = new Path(StringUtils.getBeanName((String)propertyName));
            boolean searchSubTypes = true;
            if (this.getBeanTypeDef().hasChildDef(beanPath, searchSubTypes)) {
                BeanChildDef beanChildDef = this.getBeanTypeDef().getChildDef(beanPath, searchSubTypes);
                if (beanChildDef.isCollection()) {
                    LOGGER.finest("Fixer isContainedCollection");
                    this.fixContainedCollection(beanChildDef, propertyName, unfixedPropertyValue.asJsonObject().getJsonArray(WebLogicRestSearchResultsFixer.PROP_ITEMS));
                } else {
                    LOGGER.finest("Fixer isContainedSingleton");
                    this.fixContainedSingleton(beanChildDef, propertyName, unfixedPropertyValue);
                }
            } else if (this.getBeanTypeDef().hasPropertyDef(beanPath, searchSubTypes)) {
                BeanPropertyDef beanPropDef = this.getBeanTypeDef().getPropertyDef(beanPath, searchSubTypes);
                if (beanPropDef.isReference()) {
                    if (!beanPropDef.isArray()) {
                        LOGGER.finest("Fixer isReference");
                        this.fixReferenceProperty(propertyName, unfixedPropertyValue);
                    } else {
                        LOGGER.finest("Fixer isReferences");
                        this.fixReferencesProperty(propertyName, unfixedPropertyValue.asJsonArray());
                    }
                } else {
                    LOGGER.finest("Skipping " + propertyName + " on " + String.valueOf(this.getBeanTypeDef()));
                }
            } else {
                LOGGER.info("Type information not found: " + propertyName + " on " + String.valueOf(this.getBeanTypeDef()));
            }
        }

        private void fixReferenceProperty(String propertyName, JsonValue unfixedReference) {
            if (unfixedReference == JsonValue.NULL || this.getServerName() == null) {
                return;
            }
            this.getFixedBeanBuilder().add(propertyName, (JsonValue)this.serverRuntimeIdentityToDomainRuntimeIdentity(unfixedReference.asJsonArray()));
        }

        private void fixReferencesProperty(String propertyName, JsonArray unfixedReferences) {
            if (unfixedReferences.isEmpty() || this.getServerName() == null) {
                return;
            }
            JsonArrayBuilder fixedReferencesBuilder = Json.createArrayBuilder();
            for (int i = 0; i < unfixedReferences.size(); ++i) {
                JsonValue unfixedReference = (JsonValue)unfixedReferences.getJsonObject(i).get((Object)WebLogicRestSearchResultsFixer.PROP_IDENTITY);
                JsonValue fixedReference = unfixedReference != JsonValue.NULL ? this.serverRuntimeIdentityToDomainRuntimeIdentity(unfixedReference.asJsonArray()) : JsonValue.NULL;
                fixedReferencesBuilder.add(fixedReference);
            }
            this.getFixedBeanBuilder().add(propertyName, fixedReferencesBuilder);
        }

        private void fixContainedCollection(BeanChildDef beanChildDef, String propertyName, JsonArray unfixedChildBeans) {
            if (unfixedChildBeans.isEmpty()) {
                return;
            }
            JsonArrayBuilder fixedChildBeansBuilder = Json.createArrayBuilder();
            for (int i = 0; i < unfixedChildBeans.size(); ++i) {
                JsonObject unfixedChildBean = unfixedChildBeans.getJsonObject(i);
                Fixer childBeanFixer = new Fixer(this, beanChildDef.getChildTypeDef(), true, propertyName, unfixedChildBean);
                if (childBeanFixer.isIgnore()) continue;
                fixedChildBeansBuilder.add((JsonValue)childBeanFixer.fixIdentities());
            }
            this.getFixedBeanBuilder().add(propertyName, Json.createObjectBuilder().add(WebLogicRestSearchResultsFixer.PROP_ITEMS, fixedChildBeansBuilder));
        }

        private void fixContainedSingleton(BeanChildDef beanChildDef, String propertyName, JsonValue unfixedChildBean) {
            if (unfixedChildBean == JsonValue.NULL) {
                return;
            }
            Fixer childBeanFixer = new Fixer(this, beanChildDef.getChildTypeDef(), false, propertyName, unfixedChildBean.asJsonObject());
            if (!childBeanFixer.isIgnore()) {
                this.getFixedBeanBuilder().add(propertyName, (JsonValue)childBeanFixer.fixIdentities());
            }
        }

        private JsonArray serverRuntimeIdentityToDomainRuntimeIdentity(JsonArray serverRuntimeIdentity) {
            JsonArrayBuilder domainRuntimeIdentityBuilder = Json.createArrayBuilder().add(WebLogicRestSearchResultsFixer.PROP_SERVER_RUNTIMES).add(this.getServerName());
            for (int i = 0; i < serverRuntimeIdentity.size(); ++i) {
                domainRuntimeIdentityBuilder.add((JsonValue)serverRuntimeIdentity.get(i));
            }
            return domainRuntimeIdentityBuilder.build();
        }
    }
}

