/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;

public class WebLogicRestSearchQueryBuilder {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestSearchQueryBuilder.class.getName());
    private static final Set<String> FIX_IDENTITIES_FIELDS = Set.of("type", "name", "identity");
    private WebLogicRestBeanRepoSearchBuilder builder;
    private WebLogicRestSearchQueryBuilder parent;
    private BeanTypeDef typeDef;
    private boolean settable;
    private boolean fixIdentities = false;
    private boolean customized = false;
    private boolean allKeys = false;
    private Set<String> keys = new HashSet<String>();
    private Map<String, WebLogicRestSearchQueryBuilder> children = new HashMap<String, WebLogicRestSearchQueryBuilder>();
    private Set<String> fields = new HashSet<String>();
    private boolean includeChangeManagerStatus = false;
    private boolean includeChanges = false;

    public WebLogicRestSearchQueryBuilder(WebLogicRestBeanRepoSearchBuilder builder, BeanTypeDef typeDef, boolean fixIdentities) {
        this(builder, typeDef, null);
        this.fixIdentities = fixIdentities;
        LOGGER.finest("WebLogicRestSearchQueryBuilder fix identities: " + fixIdentities);
    }

    private WebLogicRestSearchQueryBuilder(WebLogicRestBeanRepoSearchBuilder builder, BeanTypeDef typeDef, WebLogicRestSearchQueryBuilder parent) {
        this.builder = builder;
        this.typeDef = typeDef;
        this.parent = parent;
        this.settable = typeDef.isSettable();
        this.fixIdentities = parent != null ? parent.isFixIdentities() : false;
    }

    BeanTypeDef getBeanTypeDef() {
        return this.typeDef;
    }

    WebLogicRestSearchQueryBuilder addChangeManagerStatus() {
        this.includeChangeManagerStatus = true;
        this.setCustomized();
        return this;
    }

    WebLogicRestSearchQueryBuilder addChanges() {
        this.addChangeManagerStatus();
        this.includeChanges = true;
        this.setCustomized();
        return this;
    }

    WebLogicRestSearchQueryBuilder addProperty(BeanPropertyDef propertyDef) {
        String field = propertyDef.getOnlinePropertyName();
        if (this.fields == null) {
            this.fields = new HashSet<String>();
        }
        this.fields.add(field);
        return this.setCustomized();
    }

    WebLogicRestSearchQueryBuilder getOrCreateChild(BeanChildDef childDef) {
        String childRestName = childDef.getOnlineChildName();
        WebLogicRestSearchQueryBuilder child = this.children.get(childRestName);
        if (child == null) {
            boolean settable = childDef.getChildTypeDef().isSettable();
            if (!settable) {
                this.setSettable(false);
            }
            child = new WebLogicRestSearchQueryBuilder(this.builder, childDef.getChildTypeDef(), this);
            this.children.put(childRestName, child);
        }
        this.setCustomized();
        return child;
    }

    WebLogicRestSearchQueryBuilder setAllKeys() {
        this.allKeys = true;
        return this.setCustomized();
    }

    WebLogicRestSearchQueryBuilder addKey(String key) {
        if (!this.allKeys) {
            this.keys.add(key);
        }
        return this.setCustomized();
    }

    private WebLogicRestSearchQueryBuilder setCustomized() {
        this.customized = true;
        return this;
    }

    private void setSettable(boolean val) {
        if (this.parent != null) {
            this.parent.setSettable(val);
        } else {
            this.settable = val;
        }
    }

    protected boolean isSettable() {
        if (this.parent != null) {
            return this.parent.isSettable();
        }
        return this.settable;
    }

    boolean isFixIdentities() {
        return this.fixIdentities;
    }

    boolean isReturnExpandedValues() {
        return this.builder.isIncludeIsSet() && this.isSettable();
    }

    JsonObjectBuilder getJsonObjectBuilder() {
        if (!this.customized) {
            return null;
        }
        JsonObjectBuilder bldr = Json.createObjectBuilder();
        this.addFieldsToRestQuery(bldr);
        this.addKeysToRestQuery(bldr);
        this.addChildrenToRestQuery(bldr);
        return bldr;
    }

    private void addFieldsToRestQuery(JsonObjectBuilder bldr) {
        BeanPropertyDef keyPropertyDef = this.typeDef.getKeyPropertyDef();
        if (keyPropertyDef != null) {
            this.addProperty(keyPropertyDef);
        }
        JsonArrayBuilder fieldsBldr = Json.createArrayBuilder();
        for (String field : this.fields) {
            fieldsBldr.add(field);
        }
        if (this.fixIdentities) {
            for (String fixIdentitiesField : FIX_IDENTITIES_FIELDS) {
                if (this.fields.contains(fixIdentitiesField)) continue;
                fieldsBldr.add(fixIdentitiesField);
            }
        }
        bldr.add("fields", fieldsBldr);
    }

    private void addKeysToRestQuery(JsonObjectBuilder bldr) {
        if (!this.allKeys && !this.keys.isEmpty()) {
            JsonArrayBuilder keysBldr = Json.createArrayBuilder();
            for (String key : this.keys) {
                keysBldr.add(key);
            }
            bldr.add(this.typeDef.getKeyPropertyDef().getOnlinePropertyName(), keysBldr);
        }
    }

    private void addChildrenToRestQuery(JsonObjectBuilder bldr) {
        JsonObjectBuilder childrenBldr = null;
        if (this.children != null) {
            for (Map.Entry<String, WebLogicRestSearchQueryBuilder> entry : this.children.entrySet()) {
                JsonObjectBuilder childBldr = entry.getValue().getJsonObjectBuilder();
                if (childBldr == null) continue;
                if (childrenBldr == null) {
                    childrenBldr = Json.createObjectBuilder();
                }
                childrenBldr.add(entry.getKey(), childBldr);
            }
        }
        if (this.includeChangeManagerStatus) {
            if (childrenBldr == null) {
                childrenBldr = Json.createObjectBuilder();
            }
            this.addChangeManagerStatusToQuery(childrenBldr);
        }
        if (childrenBldr != null) {
            bldr.add("children", childrenBldr);
        }
    }

    private void addChangeManagerStatusToQuery(JsonObjectBuilder childrenBldr) {
        this.addChangeManagerToQuery(childrenBldr);
        this.addConsoleChangeManagerToQuery(childrenBldr);
    }

    private void addChangeManagerToQuery(JsonObjectBuilder childrenBldr) {
        JsonArrayBuilder fieldsBldr = Json.createArrayBuilder();
        fieldsBldr.add("locked");
        fieldsBldr.add("lockOwner");
        fieldsBldr.add("hasChanges");
        fieldsBldr.add("mergeNeeded");
        JsonObjectBuilder changeManagerBldr = Json.createObjectBuilder();
        changeManagerBldr.add("fields", fieldsBldr);
        childrenBldr.add("changeManager", changeManagerBldr);
    }

    private void addConsoleChangeManagerToQuery(JsonObjectBuilder childrenBldr) {
        JsonObjectBuilder consoleChangeManagerBldr = Json.createObjectBuilder();
        if (this.includeChanges) {
            this.addChangesToQuery(consoleChangeManagerBldr);
        }
        childrenBldr.add("consoleChangeManager", consoleChangeManagerBldr);
    }

    private void addChangesToQuery(JsonObjectBuilder consoleChangeManagerBldr) {
        JsonObjectBuilder changesBldr = Json.createObjectBuilder();
        JsonArrayBuilder fieldsBldr = Json.createArrayBuilder();
        fieldsBldr.add("additions");
        fieldsBldr.add("modifications");
        fieldsBldr.add("removals");
        changesBldr.add("fields", fieldsBldr);
        JsonObjectBuilder childrenBldr = Json.createObjectBuilder();
        childrenBldr.add("changes", changesBldr);
        consoleChangeManagerBldr.add("children", childrenBldr);
        this.setSettable(false);
    }
}

