/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicRuntimeTreeBeanRepoDef;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.server.repo.BeanEditorRepo;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;

public class WebLogicRestRuntimeTreeBeanRepo
extends WebLogicRestBeanRepo
implements BeanEditorRepo {
    private static final String SERVER_CONFIG = "serverConfig";
    private static final boolean EXPANDED_VALUES_FALSE = false;
    private static final boolean SAVE_CHANGES_FALSE = false;
    private static final boolean ASYNC_FALSE = false;

    public WebLogicRestRuntimeTreeBeanRepo(WebLogicMBeansVersion mbeansVersion) {
        super(mbeansVersion.findOrCreate(WebLogicRuntimeTreeBeanRepoDef.class), Map.of("DomainRuntime", "domainRuntime", "Domain", SERVER_CONFIG));
    }

    @Override
    public Response<Void> updateBean(InvocationContext ic, BeanPropertyValues propertyValues) {
        Response response = new Response();
        Response<JsonObject> postResponse = WebLogicRestInvoker.post(ic, this.getRestPath(propertyValues.getBeanTreePath()), this.propertyValuesToJson(propertyValues), false, false, false);
        this.convertRestMessagesToRepoMessages(postResponse, response);
        return response.copyStatus(postResponse);
    }

    @Override
    public Response<Void> createBean(InvocationContext ic, BeanPropertyValues propertyValues) {
        Response response = new Response();
        BeanTreePath beanTreePath = propertyValues.getBeanTreePath();
        Response<JsonObject> postResponse = WebLogicRestInvoker.post(ic, this.getRestPath(beanTreePath), this.propertyValuesToJson(propertyValues), false, false, beanTreePath.isAsyncCreate());
        this.convertRestMessagesToRepoMessages(postResponse, response);
        return response.copyStatus(postResponse);
    }

    @Override
    public Response<Void> deleteBean(InvocationContext ic, BeanTreePath beanTreePath) {
        Response<Void> response = new Response<Void>();
        Response<JsonObject> deleteResponse = WebLogicRestInvoker.delete(ic, this.getRestPath(beanTreePath), false, beanTreePath.isAsyncDelete());
        if (!deleteResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(deleteResponse);
        }
        return response;
    }

    private JsonObject propertyValuesToJson(BeanPropertyValues propertyValues) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (BeanPropertyValue propertyValue : propertyValues.getPropertyValues()) {
            builder.add(propertyValue.getPropertyDef().getOnlinePropertyName(), this.toJson(propertyValue.getValue().getValue()));
        }
        return builder.build();
    }

    private Path getRestPath(BeanTreePath beanTreePath) {
        String rootBeanName = beanTreePath.getPath().getFirstComponent();
        Path restPath = new Path(this.getWebLogicRestTreeName(rootBeanName));
        restPath.addPath(WebLogicRestRuntimeTreeBeanRepo.getTreeRelativeRestPath(beanTreePath));
        return restPath;
    }
}

