/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.LocalizableString;
import weblogic.remoteconsole.common.repodef.LocalizedConsoleRestExtensionConstants;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.utils.ResponseHelper;
import weblogic.remoteconsole.server.utils.WebLogicRestClient;
import weblogic.remoteconsole.server.utils.WebLogicRestClientException;
import weblogic.remoteconsole.server.utils.WebLogicRestRequest;

public class WebLogicRestInvoker {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestInvoker.class.getName());

    private WebLogicRestInvoker() {
    }

    public static Response<JsonObject> get(InvocationContext ic, Path path, boolean expandedValues) {
        return WebLogicRestInvoker.get(ic, path, expandedValues, WebLogicRestInvoker.builder());
    }

    public static Response<JsonObject> get(InvocationContext ic, Path path, boolean expandedValues, WebLogicRestRequest.Builder builder) {
        Response<JsonObject> response;
        block8: {
            Response response2 = new Response();
            WebLogicRestRequest request = builder.connection(ic.getConnection()).path(UrlUtils.pathToRelativeUri(path)).expandedValues(expandedValues).internal(true).build();
            javax.ws.rs.core.Response restResponse = WebLogicRestClient.get(request);
            try {
                boolean allowCreated = false;
                boolean asynchronous = false;
                response = WebLogicRestInvoker.restResponseToResponse(ic, restResponse, allowCreated, asynchronous);
                if (restResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restResponse != null) {
                        try {
                            restResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WebLogicRestClientException e) {
                    LOGGER.log(Level.WARNING, "Unexpected WebLogic Rest exception", e);
                    return response2.setServiceNotAvailable();
                }
            }
            restResponse.close();
        }
        return response;
    }

    public static Response<JsonObject> post(InvocationContext ic, Path path, JsonObject requestBody, boolean expandedValues, boolean saveChanges, boolean asynchronous) {
        return WebLogicRestInvoker.post(ic, path, requestBody, expandedValues, saveChanges, asynchronous, WebLogicRestInvoker.builder());
    }

    public static Response<JsonObject> post(InvocationContext ic, Path path, JsonObject requestBody, boolean expandedValues, boolean saveChanges, boolean asynchronous, WebLogicRestRequest.Builder builder) {
        Response<JsonObject> response;
        block8: {
            Response response2 = new Response();
            WebLogicRestRequest request = builder.connection(ic.getConnection()).path(UrlUtils.pathToRelativeUri(path)).saveChanges(saveChanges).expandedValues(expandedValues).asynchronous(asynchronous).internal(true).build();
            javax.ws.rs.core.Response restResponse = WebLogicRestClient.post(request, requestBody);
            try {
                boolean allowCreated = true;
                response = WebLogicRestInvoker.restResponseToResponse(ic, restResponse, allowCreated, asynchronous);
                if (restResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restResponse != null) {
                        try {
                            restResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WebLogicRestClientException e) {
                    LOGGER.log(Level.WARNING, "Unexpected WebLogic Rest exception", e);
                    return response2.setServiceNotAvailable();
                }
            }
            restResponse.close();
        }
        return response;
    }

    public static Response<JsonObject> post(InvocationContext ic, Path path, FormDataMultiPart parts, boolean expandedValues, boolean saveChanges, boolean asynchronous) {
        Response<JsonObject> response;
        block8: {
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(ic.getConnection()).path(UrlUtils.pathToRelativeUri(path)).saveChanges(saveChanges).expandedValues(expandedValues).asynchronous(asynchronous).internal(true).build();
            javax.ws.rs.core.Response restResponse = WebLogicRestClient.post(request, parts);
            try {
                boolean allowCreated = true;
                response = WebLogicRestInvoker.restResponseToResponse(ic, restResponse, allowCreated, asynchronous);
                if (restResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restResponse != null) {
                        try {
                            restResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WebLogicRestClientException e) {
                    LOGGER.log(Level.WARNING, "Unexpected WebLogic Rest exception", e);
                    return new Response().setServiceNotAvailable();
                }
            }
            restResponse.close();
        }
        return response;
    }

    public static Response<JsonObject> delete(InvocationContext ic, Path path, boolean saveChanges, boolean asynchronous) {
        Response<JsonObject> response;
        block8: {
            WebLogicRestRequest request = WebLogicRestRequest.builder().connection(ic.getConnection()).path(UrlUtils.pathToRelativeUri(path)).saveChanges(saveChanges).asynchronous(asynchronous).build();
            javax.ws.rs.core.Response restResponse = WebLogicRestClient.delete(request);
            try {
                boolean allowCreated = false;
                response = WebLogicRestInvoker.restResponseToResponse(ic, restResponse, allowCreated, asynchronous);
                if (restResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (restResponse != null) {
                        try {
                            restResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WebLogicRestClientException e) {
                    LOGGER.log(Level.WARNING, "Unexpected WebLogic Rest exception", e);
                    return new Response().setServiceNotAvailable();
                }
            }
            restResponse.close();
        }
        return response;
    }

    public static WebLogicRestRequest.Builder builder() {
        return WebLogicRestRequest.builder().root("/management/weblogic/12.2.1.0.0");
    }

    private static Response<JsonObject> restResponseToResponse(InvocationContext ic, javax.ws.rs.core.Response restResponse, boolean allowCreated, boolean asynchronous) {
        Response<JsonObject> response = new Response<JsonObject>();
        JsonObject entity = ResponseHelper.getEntityAsJson(restResponse);
        JsonObject entityWithoutMessages = WebLogicRestInvoker.moveMessagesToResponse(ic, response, entity);
        int status = restResponse.getStatus();
        if (Response.Status.OK.getStatusCode() == status || Response.Status.CREATED.getStatusCode() == status && allowCreated || Response.Status.ACCEPTED.getStatusCode() == status && asynchronous) {
            return response.setSuccess(entityWithoutMessages);
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == status) {
            return response.setNotFound();
        }
        if (Response.Status.BAD_REQUEST.getStatusCode() == status) {
            return response.setUserBadRequest();
        }
        if (Response.Status.GATEWAY_TIMEOUT.getStatusCode() == status) {
            return response.setTimeout();
        }
        LOGGER.warning("Unexpected WebLogic Rest Response status " + status);
        return response.setServiceNotAvailable();
    }

    private static JsonObject moveMessagesToResponse(InvocationContext ic, Response<JsonObject> response, JsonObject entityJson) {
        if (entityJson == null || !entityJson.containsKey((Object)"messages")) {
            return entityJson;
        }
        JsonArray messagesJson = entityJson.getJsonArray("messages");
        for (int i = 0; i < messagesJson.size(); ++i) {
            JsonObject messageJson = messagesJson.getJsonObject(i);
            response.addMessage(new Message(messageJson.getString("severity"), messageJson.getString("field", null), WebLogicRestInvoker.localizeWebLogicRestMessage(ic, messageJson.getString("message"))));
        }
        return Json.createObjectBuilder((JsonObject)entityJson).remove("messages").build();
    }

    private static String localizeWebLogicRestMessage(InvocationContext ic, String message) {
        String constantKey;
        LocalizableString ls;
        if (message.startsWith("consoleRestExtension.") && (ls = LocalizedConsoleRestExtensionConstants.findConstant(constantKey = message.split(" ")[0])) != null) {
            Object[] args = WebLogicRestInvoker.getArgsFromUnlocalizedMessage(message, constantKey);
            return ic.getLocalizer().localizeString(ls, args);
        }
        return message;
    }

    private static Object[] getArgsFromUnlocalizedMessage(String message, String constantKey) {
        ArrayList<String> args = new ArrayList<String>();
        int startOfArgs = constantKey.length() + 1;
        if (message.length() > startOfArgs) {
            String argsAsJsonArray = message.substring(startOfArgs);
            try (StringReader reader = new StringReader(argsAsJsonArray);){
                JsonArray ja = Json.createReader((Reader)reader).readArray();
                for (int i = 0; i < ja.size(); ++i) {
                    args.add(ja.getString(i));
                }
            }
        }
        return args.toArray();
    }
}

