/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.server.repo.AddedBean;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.ChangeManagerBeanRepoSearchResults;
import weblogic.remoteconsole.server.repo.ChangeManagerStatus;
import weblogic.remoteconsole.server.repo.Changes;
import weblogic.remoteconsole.server.repo.ModifiedBeanProperty;
import weblogic.remoteconsole.server.repo.RemovedBean;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestValueBuilder;

class WebLogicRestEditTreeBeanRepoSearchResults
extends WebLogicRestBeanRepoSearchResults
implements ChangeManagerBeanRepoSearchResults {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestEditTreeBeanRepoSearchResults.class.getName());

    public WebLogicRestEditTreeBeanRepoSearchResults(WebLogicRestBeanRepoSearchBuilder builder, Map<String, JsonObject> rootBeanNameToSearchResultsMap) {
        super(builder, rootBeanNameToSearchResultsMap);
    }

    @Override
    public ChangeManagerStatus getChangeManagerStatus() {
        JsonObject searchResults = this.getRootBeanNameToSearchResultsMap().get("Domain");
        if (searchResults == null) {
            return null;
        }
        JsonObject changeManager = searchResults.getJsonObject("changeManager");
        if (changeManager == null) {
            return null;
        }
        JsonObject consoleChangeManager = searchResults.getJsonObject("consoleChangeManager");
        return new ChangeManagerStatus(changeManager.getBoolean("locked"), changeManager.getString("lockOwner", null), changeManager.getBoolean("hasChanges", false), changeManager.getBoolean("mergeNeeded"), consoleChangeManager != null);
    }

    @Override
    public Changes getChanges() {
        Changes changes = new Changes(this.getChangeManagerStatus());
        ChangeManagerStatus status = changes.getChangeManagerStatus();
        if (status != null && status.isSupportsChanges()) {
            this.addChanges(changes);
        }
        return changes;
    }

    private void addChanges(Changes changes) {
        JsonObject weblogicChanges = this.getRootBeanNameToSearchResultsMap().get("Domain").getJsonObject("consoleChangeManager").getJsonObject("changes");
        new ChangesBuilder(weblogicChanges, changes).build();
    }

    private class ChangesBuilder {
        private JsonObject weblogicChanges;
        private Changes changes;
        private WebLogicRestValueBuilder valueBuilder;

        private ChangesBuilder(JsonObject weblogicChanges, Changes changes) {
            this.weblogicChanges = weblogicChanges;
            this.changes = changes;
            WebLogicRestBeanRepo beanRepo = WebLogicRestEditTreeBeanRepoSearchResults.this.getBuilder().getBeanRepo();
            BeanChildDef rootChildDef = beanRepo.getBeanRepoDef().getRootTypeDef().getChildDef(new Path("Domain"));
            this.valueBuilder = new WebLogicRestValueBuilder(beanRepo, rootChildDef);
        }

        private void build() {
            this.buildModifications();
            this.buildAdditions();
            this.buildRemovals();
        }

        private void buildModifications() {
            JsonArray weblogicVals = this.weblogicChanges.getJsonArray("modifications");
            if (weblogicVals == null) {
                return;
            }
            for (int i = 0; i < weblogicVals.size(); ++i) {
                this.buildModification(weblogicVals.getJsonObject(i));
            }
        }

        private void buildAdditions() {
            JsonArray weblogicVals = this.weblogicChanges.getJsonArray("additions");
            if (weblogicVals == null) {
                return;
            }
            for (int i = 0; i < weblogicVals.size(); ++i) {
                this.buildAddition(weblogicVals.getJsonObject(i));
            }
        }

        private void buildRemovals() {
            JsonArray weblogicVals = this.weblogicChanges.getJsonArray("removals");
            if (weblogicVals == null) {
                return;
            }
            for (int i = 0; i < weblogicVals.size(); ++i) {
                this.buildRemoval(weblogicVals.getJsonObject(i));
            }
        }

        private void buildModification(JsonObject weblogicVal) {
            BeanTreePath beanPath = this.getBeanTreePath(weblogicVal);
            String propertyRestName = weblogicVal.getString("property");
            Path propertyPath = new Path(StringUtils.getBeanName((String)propertyRestName));
            if (beanPath.getTypeDef().hasPropertyDef(propertyPath, true)) {
                BeanPropertyDef propertyDef = beanPath.getTypeDef().getPropertyDef(propertyPath, true);
                this.changes.getModifications().add(new ModifiedBeanProperty(beanPath, propertyDef.getPropertyPath(), weblogicVal.getBoolean("unset"), this.getModificationValue(beanPath, propertyDef, (JsonValue)weblogicVal.get((Object)"oldValue")), this.getModificationValue(beanPath, propertyDef, (JsonValue)weblogicVal.get((Object)"newValue"))));
            } else if (beanPath.getTypeDef().hasChildDef(propertyPath, true)) {
                BeanChildDef childDef = beanPath.getTypeDef().getChildDef(propertyPath, true);
                this.changes.getModifications().add(new ModifiedBeanProperty(beanPath, childDef.getChildPath(), weblogicVal.getBoolean("unset"), this.getModificationValue(beanPath, null, (JsonValue)weblogicVal.get((Object)"oldValue")), this.getModificationValue(beanPath, null, (JsonValue)weblogicVal.get((Object)"newValue"))));
            } else {
                LOGGER.finest("buildModification can't find property " + String.valueOf(propertyPath) + " " + String.valueOf(beanPath));
            }
        }

        private Value getModificationValue(BeanTreePath beanPath, BeanPropertyDef propertyDef, JsonValue jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            BeanChildDef rootChildBean = beanPath.getSegments().get(0).getChildDef();
            WebLogicRestValueBuilder builder = new WebLogicRestValueBuilder(beanPath.getBeanRepo(), rootChildBean);
            if (WebLogicRestEditTreeBeanRepoSearchResults.this.isHaveExpandedValues(beanPath)) {
                jsonVal = (JsonValue)jsonVal.asJsonObject().get((Object)"value");
            }
            if (propertyDef == null) {
                return builder.buildReferences(jsonVal);
            }
            return builder.buildValue(propertyDef, jsonVal);
        }

        private void buildAddition(JsonObject weblogicVal) {
            this.changes.getAdditions().add(new AddedBean(this.getBeanTreePath(weblogicVal)));
        }

        private void buildRemoval(JsonObject weblogicVal) {
            this.changes.getRemovals().add(new RemovedBean(this.getBeanTreePath(weblogicVal)));
        }

        private BeanTreePath getBeanTreePath(JsonObject weblogicVal) {
            BeanTreePath rtn = this.valueBuilder.buildReference((JsonValue)weblogicVal.get((Object)"identity")).asBeanTreePath();
            return rtn;
        }
    }
}

