/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.Map;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicEditTreeBeanRepoDef;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.server.repo.BeanPropertyValue;
import weblogic.remoteconsole.server.repo.BeanPropertyValues;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanRepo;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.ChangeManagerBeanRepo;
import weblogic.remoteconsole.server.repo.FileContentsValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestEditTreeBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;

public class WebLogicRestEditTreeBeanRepo
extends WebLogicRestBeanRepo
implements ChangeManagerBeanRepo {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestEditTreeBeanRepo.class.getName());
    private static final String EDIT = "edit";
    private static final Path EDIT_PATH = new Path("edit");
    private static final Path CHANGE_MANAGER_PATH = EDIT_PATH.childPath("changeManager");

    public static BeanRepo getInstance(InvocationContext ic) {
        return ic.getPageRepo().getBeanRepo();
    }

    public WebLogicRestEditTreeBeanRepo(WebLogicMBeansVersion mbeansVersion) {
        super(mbeansVersion.findOrCreate(WebLogicEditTreeBeanRepoDef.class), Map.of("Domain", EDIT, "DomainRuntime", "domainRuntime"));
    }

    @Override
    public BeanReaderRepoSearchBuilder createSearchBuilder(InvocationContext invocationContext, boolean includeIsSet) {
        LOGGER.fine("createSearchBuilder " + String.valueOf(invocationContext.getBeanTreePath()));
        return new WebLogicRestEditTreeBeanRepoSearchBuilder(this, invocationContext, includeIsSet);
    }

    @Override
    public Response<Void> startEdit(InvocationContext ic) {
        return this.invokeChangeManagerAction(ic, "startEdit");
    }

    @Override
    public Response<Void> saveChanges(InvocationContext ic) {
        Response response = new Response();
        Response<JsonObject> postResponse = WebLogicRestInvoker.post(ic, EDIT_PATH, Json.createObjectBuilder().build(), false, true, false);
        if (!postResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(postResponse);
        }
        return response.copyMessages(postResponse);
    }

    @Override
    public Response<Void> commitChanges(InvocationContext ic) {
        return this.invokeChangeManagerAction(ic, "activate");
    }

    @Override
    public Response<Void> discardChanges(InvocationContext ic) {
        return this.invokeChangeManagerAction(ic, "cancelEdit");
    }

    @Override
    public Response<Void> updateBean(InvocationContext ic, BeanPropertyValues propertyValues) {
        Response response = new Response();
        boolean useExpandedValues = propertyValues.getBeanTreePath().getTypeDef().isSettable();
        boolean isCreate = false;
        Response<JsonObject> postResponse = WebLogicRestInvoker.post(ic, EDIT_PATH.childPath(WebLogicRestEditTreeBeanRepo.getTreeRelativeRestPath(propertyValues.getBeanTreePath())), this.propertyValuesToJson(useExpandedValues, isCreate, propertyValues), useExpandedValues, false, false);
        this.convertRestMessagesToRepoMessages(postResponse, response);
        return response.copyStatus(postResponse);
    }

    @Override
    public Response<Void> createBean(InvocationContext ic, BeanPropertyValues propertyValues) {
        Response response = new Response();
        boolean useExpandedValues = false;
        boolean isCreate = true;
        boolean saveChanges = false;
        JsonObject requestBody = this.propertyValuesToJson(useExpandedValues, isCreate, propertyValues);
        BeanTreePath beanTreePath = propertyValues.getBeanTreePath();
        Path restPath = EDIT_PATH.childPath(WebLogicRestEditTreeBeanRepo.getTreeRelativeRestPath(beanTreePath));
        boolean async = beanTreePath.isAsyncCreate();
        Response<JsonObject> postResponse = null;
        if (this.isMultiPart(propertyValues)) {
            FormDataMultiPart parts = this.getParts(requestBody, propertyValues);
            postResponse = WebLogicRestInvoker.post(ic, restPath, parts, useExpandedValues, saveChanges, async);
        } else {
            postResponse = WebLogicRestInvoker.post(ic, restPath, requestBody, useExpandedValues, saveChanges, async);
        }
        this.convertRestMessagesToRepoMessages(postResponse, response);
        return response.copyStatus(postResponse);
    }

    @Override
    public Response<Void> deleteBean(InvocationContext ic, BeanTreePath beanTreePath) {
        Response<Void> response = new Response<Void>();
        Response<JsonObject> deleteResponse = WebLogicRestInvoker.delete(ic, EDIT_PATH.childPath(WebLogicRestEditTreeBeanRepo.getTreeRelativeRestPath(beanTreePath)), false, beanTreePath.isAsyncDelete());
        if (!deleteResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(deleteResponse);
        }
        return response;
    }

    private boolean isMultiPart(BeanPropertyValues propertyValues) {
        for (BeanPropertyValue propertyValue : propertyValues.getPropertyValues()) {
            if (!propertyValue.getValue().getValue().isFileContents()) continue;
            return true;
        }
        return false;
    }

    private FormDataMultiPart getParts(JsonObject requestBody, BeanPropertyValues propertyValues) {
        FormDataMultiPart parts = new FormDataMultiPart();
        parts.field("model", (Object)requestBody.toString(), MediaType.APPLICATION_JSON_TYPE);
        for (BeanPropertyValue propertyValue : propertyValues.getPropertyValues()) {
            Value value = propertyValue.getValue().getValue();
            if (!value.isFileContents()) continue;
            FileContentsValue fcValue = value.asFileContents();
            parts.bodyPart((BodyPart)new StreamDataBodyPart(propertyValue.getPropertyDef().getOnlinePropertyName(), fcValue.getInputStream(), fcValue.getFileName()));
        }
        return parts;
    }

    private JsonObject propertyValuesToJson(boolean useExpandedValues, boolean isCreate, BeanPropertyValues propertyValues) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (BeanPropertyValue propertyValue : propertyValues.getPropertyValues()) {
            JsonValue jsonValue = this.propertyValueToJson(useExpandedValues, isCreate, propertyValue);
            if (jsonValue == null) continue;
            builder.add(propertyValue.getPropertyDef().getOnlinePropertyName(), jsonValue);
        }
        return builder.build();
    }

    private JsonValue propertyValueToJson(boolean useExpandedValues, boolean isCreate, BeanPropertyValue propertyValue) {
        JsonValue jsonValue;
        Value value;
        SettableValue settableValue = propertyValue.getValue();
        boolean unset = settableValue.isUnset();
        if (unset) {
            if (isCreate) {
                return null;
            }
            if (!useExpandedValues) {
                return null;
            }
        }
        if ((value = settableValue.getValue()) != null && value.isFileContents()) {
            return null;
        }
        JsonValue jsonValue2 = jsonValue = unset ? null : this.toJson(value);
        if (!useExpandedValues) {
            return jsonValue;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("set", !unset);
        if (!unset) {
            builder.add("value", jsonValue);
        }
        return builder.build();
    }

    private Response<Void> invokeChangeManagerAction(InvocationContext ic, String action) {
        Response response = new Response();
        Response<JsonObject> postResponse = WebLogicRestInvoker.post(ic, CHANGE_MANAGER_PATH.childPath(action), Json.createObjectBuilder().build(), false, false, false);
        if (!postResponse.isSuccess()) {
            return response.copyUnsuccessfulResponse(postResponse);
        }
        return response.copyMessages(postResponse);
    }
}

