/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.server.providers.Root;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Link;
import weblogic.remoteconsole.server.repo.Page;
import weblogic.remoteconsole.server.repo.Response;

public class WebLogicRestConfigPageRepoUtils {
    public static Response<Page> addConfigLink(String rootName, InvocationContext ic, Response<Page> response) {
        if (response.isSuccess()) {
            WebLogicRestConfigPageRepoUtils.addConfigLink(rootName, ic, response.getResults());
        }
        return response;
    }

    private static void addConfigLink(String rootName, InvocationContext ic, Page page) {
        if (ic.getPagePath().isCreateFormPagePath()) {
            return;
        }
        if ("RecentSearchMBean".equals(ic.getBeanTreePath().getTypeDef().getTypeName())) {
            return;
        }
        Root root = ic.getProvider().getRoots().get(rootName);
        if (root == null) {
            return;
        }
        Path resourceData = new Path(root.getName());
        resourceData.addComponent("data");
        resourceData.addPath(ic.getBeanTreePath().getPath());
        String label = WebLogicRestConfigPageRepoUtils.getLastBreadCrumbLabel(ic) + " - " + ic.getLocalizer().localizeString(root.getLabel(), new Object[0]);
        Link link = new Link();
        link.setResourceData(resourceData);
        link.setLabel(label);
        page.getLinks().add(0, link);
    }

    private static String getLastBreadCrumbLabel(InvocationContext ic) {
        BeanTreePathSegment lastSegment = ic.getBeanTreePath().getLastSegment();
        BeanChildDef childDef = lastSegment.getChildDef();
        if (childDef.isCollection() && lastSegment.isKeySet()) {
            return lastSegment.getKey();
        }
        return ic.getLocalizer().localizeString(childDef.getLabel(), new Object[0]);
    }
}

