/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.SettableValue;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestValueBuilder;

public class WebLogicRestBeanSearchResults
implements BeanSearchResults {
    private WebLogicRestBeanRepoSearchResults results;
    private BeanTreePath beanPath;
    private boolean haveExpandedValues;
    private JsonObject weblogicBeanResults;

    public WebLogicRestBeanSearchResults(WebLogicRestBeanRepoSearchResults results, BeanTreePath beanPath, boolean haveExpandedValues, JsonObject weblogicBeanResults) {
        this.results = results;
        this.beanPath = beanPath;
        this.haveExpandedValues = haveExpandedValues;
        this.weblogicBeanResults = weblogicBeanResults;
    }

    @Override
    public BeanReaderRepoSearchResults getSearchResults() {
        return this.results;
    }

    @Override
    public BeanTreePath getBeanTreePath() {
        return this.beanPath;
    }

    protected boolean isHaveExpandedValues() {
        return this.haveExpandedValues;
    }

    protected JsonObject getWebLogicBeanResults() {
        return this.weblogicBeanResults;
    }

    @Override
    public Value getUnsortedValue(BeanPropertyDef propertyDef) {
        JsonValue unwrappedValue;
        JsonObject wlBeanResults = this.getWebLogicBeanResults();
        BeanTypeDef typeDef = this.getBeanTreePath().getTypeDef();
        for (String parent : propertyDef.getParentPath().getComponents()) {
            BeanChildDef childDef = typeDef.getChildDef(new Path(parent), true);
            String parentRestName = childDef.getOnlineChildName();
            if (!wlBeanResults.containsKey((Object)parentRestName) || wlBeanResults.isNull(parentRestName)) {
                return null;
            }
            wlBeanResults = wlBeanResults.getJsonObject(parentRestName);
            typeDef = childDef.getChildTypeDef();
        }
        String restName = propertyDef.getOnlinePropertyName();
        if (!wlBeanResults.containsKey((Object)restName)) {
            return null;
        }
        if (this.isHaveExpandedValues()) {
            unwrappedValue = null;
            boolean set = false;
            if (propertyDef.isIdentity()) {
                unwrappedValue = (JsonValue)wlBeanResults.get((Object)restName);
            } else {
                JsonObject wrappedValue = wlBeanResults.getJsonObject(restName);
                unwrappedValue = (JsonValue)wrappedValue.get((Object)"value");
                set = wrappedValue.getBoolean("set");
            }
            return new SettableValue(this.getValue(propertyDef, unwrappedValue), set);
        }
        unwrappedValue = (JsonValue)wlBeanResults.get((Object)restName);
        return this.getValue(propertyDef, unwrappedValue);
    }

    private Value getValue(BeanPropertyDef propertyDef, JsonValue jsonValue) {
        BeanChildDef rootChildBean = this.getBeanTreePath().getSegments().get(0).getChildDef();
        WebLogicRestValueBuilder builder = new WebLogicRestValueBuilder(this.getBeanTreePath().getBeanRepo(), rootChildBean);
        return builder.buildValue(propertyDef, jsonValue);
    }
}

