/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanTypeSearchHelper;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanSearchResults;

class WebLogicRestBeanRepoSearchResults
implements BeanReaderRepoSearchResults {
    private WebLogicRestBeanRepoSearchBuilder builder;
    private Map<String, JsonObject> rootBeanNameToSearchResultsMap;

    public WebLogicRestBeanRepoSearchResults(WebLogicRestBeanRepoSearchBuilder builder, Map<String, JsonObject> rootBeanNameToSearchResultsMap) {
        this.builder = builder;
        this.rootBeanNameToSearchResultsMap = rootBeanNameToSearchResultsMap;
    }

    WebLogicRestBeanRepoSearchBuilder getBuilder() {
        return this.builder;
    }

    protected Map<String, JsonObject> getRootBeanNameToSearchResultsMap() {
        return this.rootBeanNameToSearchResultsMap;
    }

    @Override
    public BeanSearchResults getBean(BeanTreePath beanPath) {
        if (beanPath.isCollection()) {
            throw new AssertionError((Object)("getBean can't return collections " + String.valueOf(beanPath)));
        }
        boolean haveExpandedValues = this.isHaveExpandedValues(beanPath);
        JsonObject weblogicBeanResults = this.findWebLogicSearchResults(beanPath, haveExpandedValues);
        if (weblogicBeanResults == null) {
            return null;
        }
        return new WebLogicRestBeanSearchResults(this, beanPath, haveExpandedValues, weblogicBeanResults);
    }

    @Override
    public List<BeanSearchResults> getUnsortedCollection(BeanTreePath collectionPath) {
        if (!collectionPath.isCollection()) {
            throw new AssertionError((Object)("getBeanCollection can't return single beans " + String.valueOf(collectionPath)));
        }
        boolean haveExpandedValues = this.isHaveExpandedValues(collectionPath);
        JsonObject weblogicCollectionResults = this.findWebLogicSearchResults(collectionPath, haveExpandedValues);
        if (weblogicCollectionResults == null) {
            return null;
        }
        ArrayList<BeanSearchResults> rtn = new ArrayList<BeanSearchResults>();
        JsonArray items = weblogicCollectionResults.getJsonArray("items");
        for (int i = 0; i < items.size(); ++i) {
            JsonObject weblogicBeanResults = items.getJsonObject(i);
            String key = this.getKey(collectionPath.getLastSegment(), weblogicBeanResults, haveExpandedValues);
            BeanTreePath collectionChildPath = BeanTreePath.create(collectionPath.getBeanRepo(), collectionPath.getPath().childPath(key));
            rtn.add(new WebLogicRestBeanSearchResults(this, collectionChildPath, haveExpandedValues, weblogicBeanResults));
        }
        return rtn;
    }

    private JsonObject findWebLogicSearchResults(BeanTreePath beanTreePath, boolean haveExpandedValues) {
        return WebLogicBeanTypeSearchHelper.getHelper(beanTreePath).findWebLogicSearchResults(this, beanTreePath, haveExpandedValues);
    }

    JsonObject findDefaultWebLogicSearchResults(BeanTreePath beanTreePath, boolean haveExpandedValues) {
        JsonObject searchResults;
        if (beanTreePath.isRoot()) {
            return Json.createObjectBuilder().build();
        }
        String rootBeanName = this.getBuilder().getBeanRepo().getRootBeanName(beanTreePath);
        JsonObject childResults = searchResults = this.getRootBeanNameToSearchResultsMap().get(rootBeanName);
        for (int i = 1; i < beanTreePath.getSegments().size(); ++i) {
            BeanTreePathSegment segment = beanTreePath.getSegments().get(i);
            JsonObject segmentResults = this.findSegmentResults(childResults, segment, haveExpandedValues);
            if (segmentResults == null) {
                return null;
            }
            childResults = segmentResults;
        }
        return childResults;
    }

    private JsonObject findSegmentResults(JsonObject parentResults, BeanTreePathSegment segment, boolean haveExpandedValues) {
        if (parentResults == null) {
            return null;
        }
        BeanChildDef childDef = segment.getChildDef();
        String childRestName = childDef.getOnlineChildName();
        if (!parentResults.containsKey((Object)childRestName)) {
            return null;
        }
        if (parentResults.isNull(childRestName)) {
            return null;
        }
        JsonObject segmentResults = parentResults.getJsonObject(childRestName);
        if (segment.getChildDef().isCollection() && segment.isKeySet()) {
            return this.findCollectionChild(segmentResults, segment, haveExpandedValues);
        }
        return segmentResults;
    }

    private JsonObject findCollectionChild(JsonObject collectionSearchResults, BeanTreePathSegment segment, boolean haveExpandedValues) {
        JsonArray items = collectionSearchResults.getJsonArray("items");
        for (int i = 0; i < items.size(); ++i) {
            JsonObject beanResults = items.getJsonObject(i);
            if (!segment.getKey().equals(this.getKey(segment, beanResults, haveExpandedValues))) continue;
            return beanResults;
        }
        return null;
    }

    private String getKey(BeanTreePathSegment segment, JsonObject beanResults, boolean haveExpandedValues) {
        String restKeyProp = this.getRestKeyPropertyName(segment);
        if (beanResults.containsKey((Object)restKeyProp)) {
            if (haveExpandedValues) {
                return beanResults.getJsonObject(restKeyProp).getString("value");
            }
            return beanResults.getString(restKeyProp);
        }
        return null;
    }

    private String getRestKeyPropertyName(BeanTreePathSegment segment) {
        return segment.getChildDef().getChildTypeDef().getKeyPropertyDef().getOnlinePropertyName();
    }

    public boolean isHaveExpandedValues(BeanTreePath beanTreePath) {
        if (!this.getBuilder().isIncludeIsSet()) {
            return false;
        }
        String rootBean = this.getBuilder().getBeanRepo().getRootBeanName(beanTreePath);
        return this.getBuilder().getRootBeanNameToQueryBuilderMap().get(rootBean).isReturnExpandedValues();
    }
}

