/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.HashMap;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.server.ConsoleBackendRuntimeConfig;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanTypeSearchHelper;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestSearchQueryBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestSearchResultsFixer;

public class WebLogicRestBeanRepoSearchBuilder
implements BeanReaderRepoSearchBuilder {
    private WebLogicRestBeanRepo beanRepo;
    private InvocationContext invocationContext;
    private boolean includeIsSet;
    private Map<String, WebLogicRestSearchQueryBuilder> rootBeanNameToQueryBuilderMap = new HashMap<String, WebLogicRestSearchQueryBuilder>();
    private Map<String, JsonObject> rootBeanNameToQueryMap = new HashMap<String, JsonObject>();
    private Map<String, JsonObject> rootBeanNameToRawResultsMap = new HashMap<String, JsonObject>();

    protected WebLogicRestBeanRepoSearchBuilder(WebLogicRestBeanRepo beanRepo, InvocationContext invocationContext, boolean includeIsSet) {
        this.beanRepo = beanRepo;
        this.invocationContext = invocationContext;
        this.includeIsSet = includeIsSet;
        for (String rootBeanName : this.getBeanRepo().getRootBeanNames()) {
            BeanChildDef beanChildDef = this.getBeanRepo().getBeanRepoDef().getRootTypeDef().getChildDef(new Path(rootBeanName));
            if (beanChildDef == null) continue;
            BeanTypeDef rootTypeDef = this.getBeanRepo().getBeanRepoDef().getRootTypeDef().getChildDef(new Path(rootBeanName)).getChildTypeDef();
            boolean fixIdentities = "DomainRuntime".equals(rootBeanName);
            this.getRootBeanNameToQueryBuilderMap().put(rootBeanName, new WebLogicRestSearchQueryBuilder(this, rootTypeDef, fixIdentities));
        }
    }

    protected WebLogicRestBeanRepo getBeanRepo() {
        return this.beanRepo;
    }

    protected InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    boolean isIncludeIsSet() {
        return this.includeIsSet;
    }

    Map<String, WebLogicRestSearchQueryBuilder> getRootBeanNameToQueryBuilderMap() {
        return this.rootBeanNameToQueryBuilderMap;
    }

    @Override
    public void addProperty(BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
        WebLogicBeanTypeSearchHelper.getHelper(beanTreePath).addProperty(this, beanTreePath, propertyDef);
    }

    void defaultAddProperty(BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
        WebLogicRestSearchQueryBuilder builder = this.getWebLogicRestSearchQueryBuilder(beanTreePath);
        BeanTypeDef typeDef = beanTreePath.getTypeDef();
        for (String component : propertyDef.getParentPath().getComponents()) {
            BeanChildDef childDef = typeDef.getChildDef(new Path(component), true);
            builder = builder.getOrCreateChild(childDef);
            typeDef = childDef.getChildTypeDef();
        }
        builder.addProperty(propertyDef);
    }

    @Override
    public Response<BeanReaderRepoSearchResults> search() {
        Response<BeanReaderRepoSearchResults> response = new Response<BeanReaderRepoSearchResults>();
        HashMap<String, JsonObject> searchResults = new HashMap<String, JsonObject>();
        for (String rootBeanName : this.getBeanRepo().getRootBeanNames()) {
            JsonObjectBuilder builder;
            WebLogicRestSearchQueryBuilder queryBuilder = this.getRootBeanNameToQueryBuilderMap().get(rootBeanName);
            if (queryBuilder == null || (builder = queryBuilder.getJsonObjectBuilder()) == null) continue;
            JsonObject query = builder.build();
            this.rootBeanNameToQueryMap.put(rootBeanName, query);
            Response<JsonObject> searchResponse = this.doQuery(queryBuilder, this.getBeanRepo().getWebLogicRestTreeName(rootBeanName), query);
            if (!searchResponse.isSuccess()) {
                return response.copyUnsuccessfulResponse(searchResponse);
            }
            JsonObject rootBeanSearchResults = searchResponse.getResults();
            this.rootBeanNameToRawResultsMap.put(rootBeanName, rootBeanSearchResults);
            if (queryBuilder.isFixIdentities()) {
                rootBeanSearchResults = WebLogicRestSearchResultsFixer.fixServerRuntimes(rootBeanSearchResults, queryBuilder.getBeanTypeDef());
            }
            searchResults.put(rootBeanName, rootBeanSearchResults);
        }
        return response.setSuccess(this.createSearchResults(searchResults));
    }

    protected BeanReaderRepoSearchResults createSearchResults(Map<String, JsonObject> searchResults) {
        return new WebLogicRestBeanRepoSearchResults(this, searchResults);
    }

    private Response<JsonObject> doQuery(WebLogicRestSearchQueryBuilder queryBuilder, String weblogicRestTreeName, JsonObject query) {
        boolean returnExpandedValues = queryBuilder.isReturnExpandedValues();
        return WebLogicRestInvoker.post(this.getInvocationContext(), new Path(weblogicRestTreeName).childPath("search"), query, returnExpandedValues, false, false, WebLogicRestInvoker.builder().queryParam("requestMaxWaitMillis", this.getWlsToWlsReadTimeoutMillis()));
    }

    private long getWlsToWlsReadTimeoutMillis() {
        long cbeToWlsReadTimeoutMillis = ConsoleBackendRuntimeConfig.getReadTimeout();
        long desiredTimeoutMillis = cbeToWlsReadTimeoutMillis - 3000L;
        long minTimeoutMillis = 3000L;
        return Math.max(desiredTimeoutMillis, minTimeoutMillis);
    }

    private WebLogicRestSearchQueryBuilder getWebLogicRestSearchQueryBuilder(BeanTreePath beanTreePath) {
        this.getBeanRepo().verifySupportsBean(beanTreePath);
        String rootBean = this.getBeanRepo().getRootBeanName(beanTreePath);
        WebLogicRestSearchQueryBuilder rtn = this.getRootBeanNameToQueryBuilderMap().get(rootBean);
        for (int i = 1; i < beanTreePath.getSegments().size(); ++i) {
            BeanTreePathSegment segment = beanTreePath.getSegments().get(i);
            BeanChildDef childDef = segment.getChildDef();
            rtn = rtn.getOrCreateChild(childDef);
            if (!childDef.isCollection()) continue;
            if (segment.isKeySet()) {
                rtn.addKey(segment.getKey());
                continue;
            }
            rtn.setAllKeys();
        }
        return rtn;
    }
}

