/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import weblogic.console.utils.Path;
import weblogic.console.utils.StringUtils;
import weblogic.remoteconsole.common.repodef.BeanActionDef;
import weblogic.remoteconsole.common.repodef.BeanActionParamDef;
import weblogic.remoteconsole.common.repodef.BeanChildDef;
import weblogic.remoteconsole.common.repodef.BeanRepoDef;
import weblogic.remoteconsole.common.utils.Message;
import weblogic.remoteconsole.server.repo.BeanActionArg;
import weblogic.remoteconsole.server.repo.BeanReaderRepo;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.BeanTreePathSegment;
import weblogic.remoteconsole.server.repo.FileContentsValue;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.Value;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicBeanTypeActionHelper;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestInvoker;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestValueBuilder;

public abstract class WebLogicRestBeanRepo
extends WebLogicBeanRepo
implements BeanReaderRepo {
    private static final Logger LOGGER = Logger.getLogger(WebLogicRestBeanRepo.class.getName());
    private Map<String, String> rootBeanNameToWebLogicRestTreeNameMap;

    protected WebLogicRestBeanRepo(BeanRepoDef beanRepoDef, Map<String, String> rootBeanNameToWebLogicRestTreeNameMap) {
        super(beanRepoDef);
        this.rootBeanNameToWebLogicRestTreeNameMap = rootBeanNameToWebLogicRestTreeNameMap;
    }

    protected Map<String, String> getRootBeanNameToWebLogicRestTreeNameMap() {
        return this.rootBeanNameToWebLogicRestTreeNameMap;
    }

    Set<String> getRootBeanNames() {
        return this.getRootBeanNameToWebLogicRestTreeNameMap().keySet();
    }

    String getRootBeanName(BeanTreePath beanTreePath) {
        return beanTreePath.getSegments().get(0).getChildDef().getChildName();
    }

    void verifySupportsBean(BeanTreePath beanTreePath) {
        this.getWebLogicRestTreeName(this.getRootBeanName(beanTreePath));
    }

    String getWebLogicRestTreeName(String rootBeanName) {
        String rtn = this.getRootBeanNameToWebLogicRestTreeNameMap().get(rootBeanName);
        if (rtn == null) {
            throw new AssertionError((Object)("Can't find WebLogic REST tree name for " + rootBeanName + " " + String.valueOf(this.getRootBeanNameToWebLogicRestTreeNameMap())));
        }
        return rtn;
    }

    @Override
    public BeanReaderRepoSearchBuilder createSearchBuilder(InvocationContext invocationContext, boolean includeIsSet) {
        LOGGER.fine("createSearchBuilder " + String.valueOf(invocationContext.getBeanTreePath()));
        return new WebLogicRestBeanRepoSearchBuilder(this, invocationContext, includeIsSet);
    }

    @Override
    public Response<Value> invokeAction(InvocationContext ic, BeanTreePath beanPath, BeanActionDef actionDef, List<BeanActionArg> args) {
        Response<Value> response = new Response<Value>();
        Response<JsonObject> reqBodyResponse = this.createRestActionRequestBody(actionDef, args);
        if (!reqBodyResponse.isSuccess()) {
            response.copyUnsuccessfulResponse(reqBodyResponse);
            return response;
        }
        Path restPath = this.getRestActionPath(ic, beanPath, actionDef);
        JsonObject restRequestBody = reqBodyResponse.getResults();
        boolean async = actionDef.isAsynchronous();
        Response<JsonObject> postResponse = null;
        boolean expandedValues = false;
        boolean saveChanges = false;
        if (this.isMultiPart(args)) {
            FormDataMultiPart parts = this.getParts(restRequestBody, args);
            postResponse = WebLogicRestInvoker.post(ic, restPath, parts, expandedValues, saveChanges, async);
        } else {
            postResponse = WebLogicRestInvoker.post(ic, restPath, restRequestBody, expandedValues, saveChanges, async);
        }
        this.convertRestActionResponseToRepoResponse(beanPath, response, postResponse, actionDef, async);
        return response;
    }

    private boolean isMultiPart(List<BeanActionArg> args) {
        for (BeanActionArg arg : args) {
            if (!arg.getValue().isFileContents()) continue;
            return true;
        }
        return false;
    }

    private FormDataMultiPart getParts(JsonObject requestBody, List<BeanActionArg> args) {
        FormDataMultiPart parts = new FormDataMultiPart();
        parts.field("model", (Object)requestBody.toString(), MediaType.APPLICATION_JSON_TYPE);
        for (BeanActionArg arg : args) {
            Value value = arg.getValue();
            if (!value.isFileContents()) continue;
            FileContentsValue fcValue = value.asFileContents();
            parts.bodyPart((BodyPart)new StreamDataBodyPart(arg.getParamDef().getOnlineParamName(), fcValue.getInputStream(), fcValue.getFileName()));
        }
        return parts;
    }

    private Response<JsonObject> createRestActionRequestBody(BeanActionDef actionDef, List<BeanActionArg> args) {
        Response<JsonObject> response = new Response<JsonObject>();
        List<BeanActionParamDef> paramDefs = actionDef.getParamDefs();
        JsonObjectBuilder bldr = Json.createObjectBuilder();
        boolean argsOK = true;
        if (args.size() == paramDefs.size()) {
            for (BeanActionParamDef paramDef : paramDefs) {
                if (!argsOK) continue;
                BeanActionArg arg = this.findActionArg(paramDef, args);
                if (arg != null) {
                    Value value = arg.getValue();
                    if (value != null && value.isFileContents()) continue;
                    bldr.add(arg.getParamDef().getOnlineParamName(), this.toJson(arg.getValue()));
                    continue;
                }
                argsOK = false;
            }
        }
        if (argsOK) {
            response.setSuccess(bldr.build());
        } else {
            response.addFailureMessage("Action args mismatch " + String.valueOf(actionDef) + " expected " + String.valueOf(paramDefs) + " received " + String.valueOf(args));
            response.setFrontEndBadRequest();
        }
        return response;
    }

    private void convertRestActionResponseToRepoResponse(BeanTreePath beanPath, Response<Value> response, Response<JsonObject> restResponse, BeanActionDef actionDef, boolean async) {
        if (!restResponse.isSuccess()) {
            response.copyUnsuccessfulResponse(restResponse);
            return;
        }
        response.copyMessages(restResponse);
        if (async) {
            response.setSuccess(null);
        } else if (actionDef.isVoid()) {
            response.setSuccess(null);
        } else {
            JsonValue restResult = (JsonValue)restResponse.getResults().get((Object)"return");
            BeanChildDef rootChildBean = beanPath.getSegments().get(0).getChildDef();
            WebLogicRestValueBuilder builder = new WebLogicRestValueBuilder(beanPath.getBeanRepo(), rootChildBean);
            Value repoResult = builder.buildValue(actionDef, restResult);
            response.setSuccess(repoResult);
        }
    }

    private BeanActionArg findActionArg(BeanActionParamDef paramDef, List<BeanActionArg> args) {
        for (BeanActionArg arg : args) {
            if (!paramDef.getParamName().equals(arg.getParamDef().getParamName())) continue;
            return arg;
        }
        return null;
    }

    private Path getRestActionPath(InvocationContext ic, BeanTreePath beanPath, BeanActionDef actionDef) {
        BeanTreePath actionBeanPath = WebLogicBeanTypeActionHelper.getHelper(beanPath).getActionBeanPath(beanPath);
        String rootBeanName = actionBeanPath.getPath().getFirstComponent();
        Path restActionPath = new Path(this.getWebLogicRestTreeName(rootBeanName));
        restActionPath.addPath(WebLogicRestBeanRepo.getTreeRelativeRestPath(actionBeanPath));
        restActionPath.addPath(actionDef.getParentPath());
        restActionPath.addComponent(actionDef.getRemoteActionName());
        return WebLogicRestBeanRepo.shortcutAdminServerRuntimePath(ic, restActionPath);
    }

    protected void convertRestMessagesToRepoMessages(Response<?> restResponse, Response<?> repoResponse) {
        for (Message restMessage : restResponse.getMessages()) {
            repoResponse.addMessage(new Message(restMessage.getSeverity(), StringUtils.getBeanName((String)restMessage.getProperty()), restMessage.getText()));
        }
    }

    protected JsonValue toJson(Value value) {
        boolean arrayElement = false;
        return this.toJson(value, arrayElement);
    }

    private JsonValue toJson(Value value, boolean arrayElement) {
        if (value.isString()) {
            String str = value.asString().getValue();
            return str == null ? JsonValue.NULL : Json.createValue((String)str);
        }
        if (value.isSecret()) {
            String str = value.asSecret().getValue();
            return str == null ? JsonValue.NULL : Json.createValue((String)str);
        }
        if (value.isBoolean()) {
            return value.asBoolean().getValue() ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value.isInt()) {
            return Json.createValue((int)value.asInt().getValue());
        }
        if (value.isLong()) {
            return Json.createValue((long)value.asLong().getValue());
        }
        if (value.isDouble()) {
            return Json.createValue((double)value.asDouble().getValue());
        }
        if (value.isNullReference()) {
            return JsonValue.NULL;
        }
        if (value.isBeanTreePath()) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            Path path = WebLogicRestBeanRepo.getLocalTreeRelativeRestPath(value.asBeanTreePath());
            for (String component : path.getComponents()) {
                builder.add(component);
            }
            if (arrayElement) {
                JsonObjectBuilder itemBuilder = Json.createObjectBuilder();
                itemBuilder.add("identity", builder);
                return itemBuilder.build();
            }
            return builder.build();
        }
        if (value.isDate()) {
            throw new AssertionError((Object)"Setting Date properties is not currently supported");
        }
        if (value.isProperties()) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            Properties properties = value.asProperties().getValue();
            for (String key : properties.stringPropertyNames()) {
                builder.add(key, properties.getProperty(key));
            }
            return builder.build();
        }
        if (value.isEntitleNetExpression()) {
            return value.asEntitleNetExpression().getValue();
        }
        if (value.isArray()) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            boolean arrElement = true;
            for (Value val : value.asArray().getValues()) {
                builder.add(this.toJson(val, arrElement));
            }
            return builder.build();
        }
        throw new AssertionError((Object)("Unsupported value : " + String.valueOf(value)));
    }

    public static Path shortcutAdminServerRuntimePath(InvocationContext ic, Path path) {
        List components = path.getComponents();
        if (components.size() >= 3 && ((String)components.get(0)).equals("domainRuntime") && ((String)components.get(1)).equals("serverRuntimes") && ((String)components.get(2)).equals(ic.getConnection().getAdminServerName())) {
            return new Path("serverRuntime").childPath(path.subPath(3, path.length()));
        }
        return path;
    }

    private static Path getLocalTreeRelativeRestPath(BeanTreePath beanTreePath) {
        Path path = WebLogicRestBeanRepo.getTreeRelativeRestPath(beanTreePath);
        List components = path.getComponents();
        if (components.size() >= 2 && ((String)components.get(0)).equals("serverRuntimes")) {
            return path.subPath(2, path.length());
        }
        return path;
    }

    public static Path getTreeRelativeRestPath(BeanTreePath beanTreePath) {
        Path restPath = new Path();
        boolean first = true;
        for (BeanTreePathSegment segment : beanTreePath.getSegments()) {
            if (first) {
                first = false;
                continue;
            }
            restPath.addComponent(segment.getChildDef().getOnlineChildName());
            if (!segment.isKeySet()) continue;
            restPath.addComponent(segment.getKey());
        }
        return restPath;
    }
}

