/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.repo.weblogic;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.BeanPropertyDef;
import weblogic.remoteconsole.common.repodef.BeanTypeDef;
import weblogic.remoteconsole.common.repodef.weblogic.WebLogicRuntimeTreeBeanRepoDef;
import weblogic.remoteconsole.common.utils.WebLogicMBeansVersion;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.BeanReaderRepoSearchResults;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepo;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchBuilder;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestBeanRepoSearchResults;
import weblogic.remoteconsole.server.repo.weblogic.WebLogicRestSearchResultsFixer;

public class WebLogicFileRuntimeTreeBeanRepo
extends WebLogicRestBeanRepo {
    private static final Logger LOGGER = Logger.getLogger(WebLogicFileRuntimeTreeBeanRepo.class.getName());
    private static Map<String, String> rootBeanNameToWebLogicRestTreeNameMap = Map.of("DomainRuntime", "domainRuntime");
    private JsonObject searchResults = null;

    public WebLogicFileRuntimeTreeBeanRepo(WebLogicMBeansVersion mbeansVersion, String filename) {
        super(mbeansVersion.findOrCreate(WebLogicRuntimeTreeBeanRepoDef.class), rootBeanNameToWebLogicRestTreeNameMap);
        this.searchResults = this.createSearchResultsFromFile(filename);
    }

    private JsonObject createSearchResultsFromFile(String filename) {
        JsonObject runtime = null;
        try {
            try (JsonReader reader = Json.createReader((Reader)new FileReader(filename));){
                runtime = reader.readObject();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("\n>>>> WebLogic JSON response: <<<<\n" + runtime.toString() + "\n>>>> END response <<<<");
                }
            }
            LOGGER.info("FILE: WebLogicFileRuntimeTreeBeanRepo using file: " + new File(filename).getAbsolutePath());
            Path tree = new Path("DomainRuntime");
            BeanTypeDef rootTypeDef = this.getBeanRepoDef().getRootTypeDef().getChildDef(tree).getChildTypeDef();
            runtime = WebLogicRestSearchResultsFixer.fixServerRuntimes(runtime, rootTypeDef);
            LOGGER.info("FILE: WebLogicFileRuntimeTreeBeanRepo completed fixServerRuntimes()");
        }
        catch (Exception exc) {
            LOGGER.log(Level.INFO, "FILE: Unable to create WebLogicFileRuntimeTreeBeanRepo with exception: " + exc.toString(), exc);
        }
        return runtime;
    }

    @Override
    public BeanReaderRepoSearchBuilder createSearchBuilder(InvocationContext invocationContext, boolean includeIsSet) {
        LOGGER.fine("FILE: WebLogicFileRuntimeTreeBeanRepo createSearchBuilder() " + String.valueOf(invocationContext.getBeanTreePath()));
        return new FileBeanReaderRepoSearchBuilder(this.searchResults, (WebLogicRestBeanRepoSearchBuilder)super.createSearchBuilder(invocationContext, false));
    }

    class FileBeanReaderRepoSearchBuilder
    implements BeanReaderRepoSearchBuilder {
        private JsonObject rootBeanSearchResults = null;
        private WebLogicRestBeanRepoSearchBuilder weblogicRestBeanRepoSearchBuilder;

        public FileBeanReaderRepoSearchBuilder(JsonObject rootBeanSearchResults, WebLogicRestBeanRepoSearchBuilder weblogicRestBeanRepoSearchBuilder) {
            this.rootBeanSearchResults = rootBeanSearchResults;
            this.weblogicRestBeanRepoSearchBuilder = weblogicRestBeanRepoSearchBuilder;
        }

        @Override
        public void addProperty(BeanTreePath beanTreePath, BeanPropertyDef propertyDef) {
            WebLogicFileRuntimeTreeBeanRepo.this.verifySupportsBean(beanTreePath);
        }

        @Override
        public Response<BeanReaderRepoSearchResults> search() {
            LOGGER.fine("FILE: WebLogicFileRuntimeTreeBeanRepo search()");
            Response<WebLogicRestBeanRepoSearchResults> response = new Response<WebLogicRestBeanRepoSearchResults>();
            if (this.rootBeanSearchResults == null) {
                return response.setNotFound();
            }
            HashMap<String, JsonObject> searchResults = new HashMap<String, JsonObject>();
            searchResults.put("DomainRuntime", this.rootBeanSearchResults);
            return response.setSuccess(new WebLogicRestBeanRepoSearchResults(this.weblogicRestBeanRepoSearchBuilder, searchResults));
        }
    }
}

